/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class AggregateComponentService<T>
implements Service<T> {
    private final Class<T> aggregationType;
    private final Function<T[], T> aggregator;
    private List<InjectedValue<T>> injections = new ArrayList<InjectedValue<T>>();
    private T aggregation;

    AggregateComponentService(Class<T> aggregationType, Function<T[], T> aggregator) {
        this.aggregationType = aggregationType;
        this.aggregator = aggregator;
    }

    public void start(StartContext context) throws StartException {
        ArrayList<Object> toAggregate = new ArrayList<Object>(this.injections.size());
        for (InjectedValue<T> current : this.injections) {
            toAggregate.add(current.getValue());
        }
        this.aggregation = this.aggregator.apply((Object[][])toAggregate.toArray((Object[])Array.newInstance(this.aggregationType, toAggregate.size())));
    }

    public void stop(StopContext context) {
        this.aggregation = null;
    }

    Injector<T> newInjector() {
        InjectedValue injectedValue = new InjectedValue();
        this.injections.add(injectedValue);
        return injectedValue;
    }

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.aggregation;
    }
}

