/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.comparator;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;

public abstract class AbstractComparator<C>
implements Comparator<C>,
Serializable {
    private static final long serialVersionUID = -4687855076462717763L;
    private Collator collator = Collator.getInstance();

    AbstractComparator() {
        this.collator.setStrength(0);
    }

    protected void strictComparisonOnText() {
        this.collator = null;
    }

    <T> boolean areInstancesComparable(T comp1, T comp2) {
        return comp1 != null && comp2 != null;
    }

    <T> int compareInstance(T comp1, T comp2) {
        int result = 0;
        if (comp1 == null && comp2 != null) {
            result = -1;
        } else if (comp1 != null && comp2 == null) {
            result = 1;
        }
        return result;
    }

    @Override
    protected <T> int compare(Comparable<? super T> comp1, T comp2) {
        int result = 0;
        if (comp1 == null && comp2 != null) {
            result = -1;
        } else if (comp1 != null && comp2 == null) {
            result = 1;
        } else if (this.collator != null && comp1 instanceof String) {
            result = this.collator.compare(comp1, (Object)comp2);
        } else if (comp1 != null) {
            result = comp1.compareTo(comp2);
        }
        return result;
    }
}

