/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionService;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.SubscriptionMethod;
import org.silverpeas.core.subscription.service.GroupSubscriptionSubscriber;
import org.silverpeas.core.subscription.service.SubscribeRuntimeException;
import org.silverpeas.core.subscription.service.SubscriptionDao;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.subscription.util.SubscriptionList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
@Named(value="subscriptionService")
public class SimpleSubscriptionService
implements SubscriptionService,
ComponentInstanceDeletion {
    private static final long serialVersionUID = 7299411620583862933L;
    @Inject
    private SubscriptionDao subscriptionDao;
    @Inject
    private OrganizationController organisationController;

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void subscribe(Subscription subscription) {
        this.subscribe(Collections.singletonList(subscription));
    }

    @Override
    @Transactional
    public void subscribe(Collection<? extends Subscription> subscriptions) {
        Connection con = null;
        try {
            con = this.getConnection();
            for (Subscription subscription : subscriptions) {
                if (this.subscriptionDao.existsSubscription(con, subscription)) continue;
                subscription.getSubscriber().checkValid();
                this.subscriptionDao.add(con, subscription);
            }
        }
        catch (SQLException e) {
            DBUtil.rollback((Connection)con);
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void unsubscribe(Subscription subscription) {
        this.unsubscribe(Collections.singletonList(subscription));
    }

    @Override
    @Transactional
    public void unsubscribe(Collection<? extends Subscription> subscriptions) {
        Connection con = null;
        try {
            con = this.getConnection();
            for (Subscription subscription : subscriptions) {
                this.subscriptionDao.remove(con, subscription);
            }
        }
        catch (SQLException e) {
            DBUtil.rollback((Connection)con);
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void unsubscribeBySubscriber(SubscriptionSubscriber subscriber) {
        this.unsubscribeBySubscribers(Collections.singletonList(subscriber));
    }

    @Override
    @Transactional
    public void unsubscribeBySubscribers(Collection<? extends SubscriptionSubscriber> subscribers) {
        Connection con = null;
        try {
            con = this.getConnection();
            for (SubscriptionSubscriber subscriptionSubscriber : subscribers) {
                this.subscriptionDao.removeBySubscriber(con, subscriptionSubscriber);
            }
        }
        catch (SQLException e) {
            DBUtil.rollback((Connection)con);
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void unsubscribeByResource(SubscriptionResource resource) {
        this.unsubscribeByResources(Collections.singletonList(resource));
    }

    @Override
    @Transactional
    public void unsubscribeByResources(Collection<? extends SubscriptionResource> resources) {
        Connection con = null;
        try {
            con = this.getConnection();
            for (SubscriptionResource subscriptionResource : resources) {
                this.subscriptionDao.removeByResource(con, subscriptionResource);
            }
        }
        catch (SQLException e) {
            DBUtil.rollback((Connection)con);
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public boolean existsSubscription(Subscription subscription) {
        Connection con = null;
        try {
            con = this.getConnection();
            boolean bl = this.subscriptionDao.existsSubscription(con, subscription);
            return bl;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SubscriptionList getByResource(SubscriptionResource resource) {
        return this.getByResource(resource, SubscriptionMethod.UNKNOWN);
    }

    @Override
    public SubscriptionList getByResource(SubscriptionResource resource, SubscriptionMethod method) {
        SubscriptionList subscriptionList;
        block8: {
            Connection con = this.getConnection();
            try {
                subscriptionList = this.subscriptionDao.getSubscriptionsByResource(con, resource, method);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SubscribeRuntimeException(e);
                }
            }
            con.close();
        }
        return subscriptionList;
    }

    @Override
    public SubscriptionList getByUserSubscriber(String userId) {
        SubscriptionList subscriptions = this.getBySubscriber(UserSubscriptionSubscriber.from(userId));
        for (String groupId : this.organisationController.getAllGroupIdsOfUser(userId)) {
            subscriptions.addAll(this.getBySubscriber(GroupSubscriptionSubscriber.from(groupId)));
        }
        return subscriptions;
    }

    @Override
    public SubscriptionList getBySubscriber(SubscriptionSubscriber subscriber) {
        Connection con = null;
        try {
            con = this.getConnection();
            SubscriptionList subscriptionList = this.subscriptionDao.getSubscriptionsBySubscriber(con, subscriber);
            return subscriptionList;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SubscriptionList getBySubscriberAndComponent(SubscriptionSubscriber subscriber, String instanceId) {
        Connection con = null;
        try {
            con = this.getConnection();
            SubscriptionList subscriptionList = this.subscriptionDao.getSubscriptionsBySubscriberAndComponent(con, subscriber, instanceId);
            return subscriptionList;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SubscriptionList getBySubscriberAndResource(SubscriptionSubscriber subscriber, SubscriptionResource resource) {
        Connection con = null;
        try {
            con = this.getConnection();
            SubscriptionList subscriptionList = this.subscriptionDao.getSubscriptionsBySubscriberAndResource(con, subscriber, resource);
            return subscriptionList;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SubscriptionSubscriberList getSubscribers(SubscriptionResource resource) {
        return this.getSubscribers(resource, SubscriptionMethod.UNKNOWN);
    }

    @Override
    public SubscriptionSubscriberList getSubscribers(SubscriptionResource resource, SubscriptionMethod method) {
        Connection con = null;
        try {
            con = this.getConnection();
            SubscriptionSubscriberList subscriptionSubscriberList = this.subscriptionDao.getSubscribers(con, resource, method);
            return subscriptionSubscriberList;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SubscriptionSubscriberList getSubscribers(Collection<? extends SubscriptionResource> resources) {
        return this.getSubscribers(resources, SubscriptionMethod.UNKNOWN);
    }

    @Override
    public SubscriptionSubscriberList getSubscribers(Collection<? extends SubscriptionResource> resources, SubscriptionMethod method) {
        Connection con = null;
        try {
            con = this.getConnection();
            SubscriptionSubscriberList subscriptionSubscriberList = this.subscriptionDao.getSubscribers(con, resources, method);
            return subscriptionSubscriberList;
        }
        catch (Exception e) {
            throw new SubscribeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public boolean isSubscriberSubscribedToResource(SubscriptionSubscriber subscriber, SubscriptionResource resource) {
        return !this.getBySubscriberAndResource(subscriber, resource).isEmpty();
    }

    @Override
    public boolean isUserSubscribedToResource(String userId, SubscriptionResource resource) {
        return this.getSubscribers(resource).getAllUserIds().contains(userId);
    }

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = this.getConnection();){
            this.subscriptionDao.removeByInstanceId(connection, componentInstanceId);
        }
        catch (SQLException ex) {
            throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }
}

