/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.token;

import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.annotation.TokenGenerator;
import org.silverpeas.core.security.token.exception.TokenGenerationException;

public class TokenGeneratorProvider {
    private TokenGeneratorProvider() {
    }

    public static org.silverpeas.core.security.token.TokenGenerator getTokenGenerator(Class<? extends Token> type) {
        TokenGenerator annotation = type.getAnnotation(TokenGenerator.class);
        try {
            Class generatorType = annotation.value();
            return (org.silverpeas.core.security.token.TokenGenerator)generatorType.newInstance();
        }
        catch (InstantiationException ex) {
            throw new TokenGenerationException("Cannot instantiate the token generator mapped with the token type " + type.getName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new TokenGenerationException("Cannot access the default constructor of the token generator mapped with the token type " + type.getName(), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw new TokenGenerationException("No token generator mapped with the token type " + type.getName(), (Throwable)ex);
        }
    }
}

