/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.ComponentInstanceAccessControlExtension;
import org.silverpeas.kernel.annotation.Base;

@Base
@Singleton
@Named
public class DefaultInstanceAccessControlExtension
implements ComponentInstanceAccessControlExtension {
    @Override
    public boolean fillUserRolesFromComponentInstance(ComponentAccessController.DataManager dataManager, User user, String componentId, AccessControlContext context, Set<SilverpeasRole> userRoles) {
        Optional<SilverpeasComponentInstance> optionalInstance = dataManager.getComponentInstance(componentId);
        if (optionalInstance.isEmpty() || !this.canAnonymousAccessInstance(context) && user.isAnonymous()) {
            return true;
        }
        Set operations = context.getOperations();
        SilverpeasComponentInstance componentInstance = optionalInstance.get();
        if (componentInstance.isPersonal()) {
            userRoles.addAll(componentInstance.getSilverpeasRolesFor(user));
            if (AccessControlOperation.isPersistActionFrom((Collection)operations) || AccessControlOperation.isDownloadActionFrom((Collection)operations) || AccessControlOperation.isSharingActionFrom((Collection)operations)) {
                userRoles.remove(SilverpeasRole.USER);
            }
            return true;
        }
        if (this.mustUserBeComponentInstanceAdminIfManagerOfParentSpace(dataManager, user, componentInstance)) {
            userRoles.add(SilverpeasRole.ADMIN);
        }
        if (componentInstance.isPublic() || dataManager.isPublicFilesEnabled(componentId)) {
            userRoles.add(SilverpeasRole.USER);
        }
        return false;
    }

    protected boolean mustUserBeComponentInstanceAdminIfManagerOfParentSpace(ComponentAccessController.DataManager dataManager, User user, SilverpeasComponentInstance componentInstance) {
        return false;
    }

    protected boolean canAnonymousAccessInstance(AccessControlContext context) {
        return true;
    }
}

