/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.engine;

import java.text.MessageFormat;
import javax.mail.Address;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import org.silverpeas.core.mail.MailToSend;
import org.silverpeas.kernel.logging.SilverLogger;

public class SmtpMailSendReportListener
implements TransportListener {
    private final MailToSend mailToSend;

    SmtpMailSendReportListener(MailToSend mailToSend) {
        this.mailToSend = mailToSend;
    }

    public void messageDelivered(TransportEvent e) {
        String message = MessageFormat.format("Mail with subject ''{0}'' has been successfully delivered.", this.mailToSend.getSubject());
        SilverLogger.getLogger((Object)this).debug(message, new Object[0]);
        this.report(e);
    }

    public void messageNotDelivered(TransportEvent e) {
        String message = MessageFormat.format("Mail with subject ''{0}'' has not been delivered.", this.mailToSend.getSubject());
        SilverLogger.getLogger((Object)this).error(message, new Object[0]);
        this.report(e);
    }

    public void messagePartiallyDelivered(TransportEvent e) {
        String message = MessageFormat.format("Mail with subject ''{0}'' has been partially delivered.", this.mailToSend.getSubject());
        SilverLogger.getLogger((Object)this).warn(message, new Object[0]);
        this.report(e);
    }

    private void report(TransportEvent e) {
        StringBuilder errorMessage;
        if (e.getValidSentAddresses() != null && e.getValidSentAddresses().length > 0) {
            StringBuilder logMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - delivered successfully to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getValidSentAddresses()) {
                logMessage.append("\t").append(address).append("\n");
            }
        }
        if (e.getValidUnsentAddresses() != null && e.getValidUnsentAddresses().length > 0) {
            errorMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - has not been delivered to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getValidUnsentAddresses()) {
                errorMessage.append("\t").append(address).append("\n");
            }
            SilverLogger.getLogger((Object)this).error(errorMessage.toString(), new Object[]{e});
        }
        if (e.getInvalidAddresses() != null && e.getInvalidAddresses().length > 0) {
            errorMessage = new StringBuilder(1000).append(MessageFormat.format("Mail with subject ''{0}'' - has not been delivered to emails:\n", this.mailToSend.getSubject()));
            for (Address address : e.getInvalidAddresses()) {
                errorMessage.append("\t").append(address).append("\n");
            }
            SilverLogger.getLogger((Object)this).error(errorMessage.toString(), new Object[]{e});
        }
    }
}

