/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.video;

import java.util.EnumSet;
import java.util.Set;

public enum ThumbnailPeriod {
    Thumbnail0(0, 0.1),
    Thumbnail1(1, 0.3),
    Thumbnail2(2, 0.5),
    Thumbnail3(3, 0.7),
    Thumbnail4(4, 0.9),
    ERROR(-1, 0.0);

    public static final Set<ThumbnailPeriod> ALL_VALIDS;
    public static final String VIDEO_THUMBNAIL_FILE_PREFIX = "img";
    public static final String VIDEO_THUMBNAIL_FILE_EXTENSION = ".jpg";
    private int index;
    private double percent;

    private ThumbnailPeriod(int index, double percent) {
        this.index = index;
        this.percent = percent;
    }

    public int getIndex() {
        return this.index;
    }

    public double getPercent() {
        return this.percent;
    }

    public String getFilename() {
        return VIDEO_THUMBNAIL_FILE_PREFIX + this.getIndex() + VIDEO_THUMBNAIL_FILE_EXTENSION;
    }

    public static ThumbnailPeriod fromIndex(String index) {
        if ("0".equals(index)) {
            return Thumbnail0;
        }
        if ("1".equals(index)) {
            return Thumbnail1;
        }
        if ("2".equals(index)) {
            return Thumbnail2;
        }
        if ("3".equals(index)) {
            return Thumbnail3;
        }
        if ("4".equals(index)) {
            return Thumbnail4;
        }
        return ERROR;
    }

    static {
        ALL_VALIDS = EnumSet.allOf(ThumbnailPeriod.class);
        ALL_VALIDS.remove((Object)ERROR);
    }
}

