/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.control;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.process.io.file.AbstractDummyHandledFile;
import org.silverpeas.core.util.file.FileUtil;

public class ThumbnailDummyHandledFile
extends AbstractDummyHandledFile {
    private final Thumbnail thumbnail;
    private final File thumbnailFile;
    private final boolean deleted;
    private ResourceReference targetPK = null;

    public ThumbnailDummyHandledFile(Thumbnail thumbnail, File thumbnailFile) {
        this(thumbnail, thumbnailFile, false);
    }

    public ThumbnailDummyHandledFile(Thumbnail thumbnail, File thumbnailFile, ResourceReference targetPK) {
        this(thumbnail, thumbnailFile);
        this.targetPK = targetPK;
    }

    public ThumbnailDummyHandledFile(Thumbnail thumbnail, File thumbnailFile, boolean deleted) {
        this.thumbnail = thumbnail;
        this.thumbnailFile = thumbnailFile;
        this.deleted = deleted;
    }

    @Override
    public String getComponentInstanceId() {
        if (this.targetPK != null) {
            return this.targetPK.getInstanceId();
        }
        return this.thumbnail.getReference().getComponentInstanceId();
    }

    @Override
    public String getPath() {
        return this.thumbnailFile.getPath();
    }

    @Override
    public String getName() {
        return this.thumbnailFile.getName();
    }

    @Override
    public long getSize() {
        if (!this.thumbnailFile.exists()) {
            return 0L;
        }
        return FileUtils.sizeOf((File)this.thumbnailFile);
    }

    @Override
    public String getMimeType() {
        if (this.thumbnailFile.exists() && this.thumbnailFile.isFile()) {
            return FileUtil.getMimeType(this.thumbnailFile.getPath());
        }
        return this.thumbnail.getMimeType();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

