/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.datereminder;

import java.text.MessageFormat;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.datereminder.PublicationDateReminderUserNotification;
import org.silverpeas.core.contribution.publication.datereminder.PublicationNoteReference;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.datereminder.persistence.PersistentResourceDateReminder;
import org.silverpeas.core.datereminder.provider.DateReminderProcess;
import org.silverpeas.core.datereminder.provider.DateReminderProcessRegistration;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class PublicationDateReminderProcess
implements DateReminderProcess,
Initialization {
    public void init() {
        DateReminderProcessRegistration.register(PublicationDetail.class, this);
    }

    public void release() {
        DateReminderProcessRegistration.unregister(PublicationDetail.class, this);
    }

    public PublicationNoteReference perform(PersistentResourceDateReminder resourceDateReminder) {
        PublicationNoteReference pubNoteReference = (PublicationNoteReference)resourceDateReminder.getResource(PublicationNoteReference.class);
        if (pubNoteReference != null && pubNoteReference.getEntity() != null) {
            PublicationDateReminderUserNotification publicationDateReminderUserNotification = new PublicationDateReminderUserNotification(resourceDateReminder);
            UserNotificationHelper.buildAndSend(publicationDateReminderUserNotification);
        } else {
            String id = pubNoteReference == null ? "unknown" : pubNoteReference.getId();
            SilverLogger.getLogger((Object)this).warn(MessageFormat.format("publication with id {0} does not exist anymore, reminder is marked as processed", id), new Object[0]);
        }
        return pubNoteReference;
    }
}

