/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.IdentifiedRecordTemplate;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class GenericDataRecord
implements DataRecord,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id = -1;
    private String externalId;
    private final Field[] fields;
    private final transient RecordTemplate template;
    private String language;
    private final Map<String, List<Field>> fieldsByName;

    public GenericDataRecord(RecordTemplate template) throws FormException {
        this.template = template;
        ArrayList allFields = new ArrayList();
        this.fieldsByName = new HashMap<String, List<Field>>();
        for (String fieldName : template.getFieldNames()) {
            FieldTemplate fieldTemplate = template.getFieldTemplate(fieldName);
            ArrayList<Field> occurrences = new ArrayList<Field>();
            int maximumNumberOfOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
            for (int o = 0; o < maximumNumberOfOccurrences; ++o) {
                Field field = fieldTemplate.getEmptyField(o);
                occurrences.add(field);
            }
            this.fieldsByName.put(fieldName, occurrences);
            allFields.addAll(occurrences);
        }
        this.fields = allFields.toArray(new Field[0]);
    }

    @Override
    public String getId() {
        return this.externalId;
    }

    @Override
    public void setId(String id) {
        this.externalId = id;
    }

    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public Field getField(String fieldName) throws FormException {
        return this.getField(fieldName, 0);
    }

    @Override
    public Field getField(String fieldName, int occurrence) {
        List<Field> occurrences = this.fieldsByName.get(fieldName);
        Field field = null;
        if (occurrences != null && occurrence < occurrences.size()) {
            field = occurrences.get(occurrence);
        }
        if (field == null) {
            SilverLogger.getLogger((Object)this).warn("Unknown field {0}: not found in the XML descriptor", new Object[]{fieldName});
        }
        return field;
    }

    @Override
    public Field getField(int fieldIndex) throws FormException {
        if (fieldIndex >= 0 && fieldIndex < this.fields.length) {
            return this.fields[fieldIndex];
        }
        throw new FormException("Index " + fieldIndex + " out of bounds", new String[0]);
    }

    @Override
    public int size() {
        return this.fields.length;
    }

    @Override
    public boolean isNew() {
        return this.id == -1;
    }

    int getInternalId() {
        return this.id;
    }

    void setInternalId(int id) {
        this.id = id;
    }

    @Override
    public String[] getFieldNames() {
        return this.template.getFieldNames();
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Map<String, String> getValues(String language) {
        HashMap<String, String> formValues = new HashMap<String, String>();
        String[] fieldNames = this.getFieldNames();
        PagesContext pageContext = new PagesContext();
        pageContext.setObjectId(this.externalId);
        if (this.template instanceof IdentifiedRecordTemplate) {
            pageContext.setComponentId(((IdentifiedRecordTemplate)this.template).getInstanceId());
        }
        pageContext.setLanguage(language);
        for (String fieldName : fieldNames) {
            try {
                Field field = this.getField(fieldName);
                GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)this.template.getFieldTemplate(fieldName);
                FieldDisplayer<Field> fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                if ("wysiwyg".equals(fieldTemplate.getDisplayerName())) {
                    fieldTemplate.setReadOnly(true);
                    fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "wysiwyg");
                }
                if (fieldTemplate.isRepeatable()) {
                    formValues.put(fieldName, this.getRepeatableFieldDisplayableValues(field, fieldTemplate, fieldDisplayer, pageContext));
                    continue;
                }
                String value = this.getFieldDisplayableValue(field, fieldTemplate, fieldDisplayer, pageContext);
                if (!StringUtil.isDefined((String)value)) continue;
                formValues.put(fieldName, value);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Cannot get value of field " + fieldName + " of the object " + this.externalId, (Throwable)e);
            }
        }
        return formValues;
    }

    private String getRepeatableFieldDisplayableValues(Field field, FieldTemplate fieldTemplate, FieldDisplayer<Field> fieldDisplayer, PagesContext pageContext) throws FormException {
        int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
        StringBuilder fieldValues = new StringBuilder();
        for (int occ = 0; occ < maxOccurrences; ++occ) {
            String value;
            Field fieldOcc = this.getField(field.getName(), occ);
            if (fieldOcc == null || fieldOcc.isNull() || !StringUtil.isDefined((String)(value = this.getFieldDisplayableValue(fieldOcc, fieldTemplate, fieldDisplayer, pageContext)))) continue;
            if (fieldValues.length() > 0) {
                fieldValues.append(" / ");
            }
            fieldValues.append(value);
        }
        return fieldValues.toString();
    }

    private <T extends Field> String getFieldDisplayableValue(T field, FieldTemplate fieldTemplate, FieldDisplayer<T> fieldDisplayer, PagesContext pageContext) throws FormException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        fieldDisplayer.display(out, field, fieldTemplate, pageContext);
        return sw.toString();
    }

    @Override
    public ResourceReference getResourceReference() {
        String componentId = "unknown";
        if (this.template instanceof IdentifiedRecordTemplate) {
            componentId = ((IdentifiedRecordTemplate)this.template).getInstanceId();
        }
        return new ResourceReference(this.externalId, componentId);
    }
}

