/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.form;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.contribution.content.form.AbstractForm;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.logging.SilverLogger;

public class HtmlForm
extends AbstractForm {
    private DataRecord record;
    private PagesContext pagesContext;
    private String m_FileName;
    private BufferedReader m_HtmlFile;
    private String currentLine = "";
    private static String TAG_BEGIN = "<%=";
    private static String TAG_END = "%>";

    public HtmlForm(RecordTemplate template) throws FormException {
        super(template);
    }

    public void setFileName(String fileName) {
        this.m_FileName = fileName;
    }

    private void closeHtmlFile() throws IOException {
        if (this.m_HtmlFile != null) {
            try {
                this.m_HtmlFile.close();
                this.m_HtmlFile = null;
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnClosingFile((String)this.m_FileName), (Throwable)e);
                throw e;
            }
        }
    }

    private void openHtmlFile() throws IOException {
        this.closeHtmlFile();
        this.m_HtmlFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_FileName), Charsets.UTF_8));
    }

    private void parseFile(PrintWriter out) throws IOException {
        boolean endOfFile;
        this.openHtmlFile();
        PagesContext pc = new PagesContext(this.pagesContext);
        pc.incCurrentFieldIndex(1);
        do {
            if (endOfFile = this.printBeforeTag(out)) continue;
            this.processTag(out, pc);
        } while (!endOfFile);
        this.closeHtmlFile();
    }

    private boolean printBeforeTag(PrintWriter out) throws IOException {
        if (this.currentLine == null || this.currentLine.isEmpty()) {
            this.currentLine = this.m_HtmlFile.readLine();
        }
        if (this.currentLine == null) {
            return true;
        }
        int pos = this.currentLine.indexOf(TAG_BEGIN);
        if (pos == -1) {
            out.println(this.currentLine);
            this.currentLine = "";
            return this.printBeforeTag(out);
        }
        out.print(this.currentLine.substring(0, pos));
        this.currentLine = this.currentLine.substring(pos, this.currentLine.length());
        return false;
    }

    private void processTag(PrintWriter out, PagesContext pc) throws IOException {
        if (this.currentLine == null || this.currentLine.isEmpty()) {
            this.currentLine = this.m_HtmlFile.readLine();
        }
        if (this.currentLine == null) {
            SilverLogger.getLogger((Object)this).error("end of file", new Object[0]);
            return;
        }
        int beginPos = this.currentLine.indexOf(TAG_BEGIN);
        if (beginPos != 0) {
            SilverLogger.getLogger((Object)this).error("TAG not found", new Object[0]);
            return;
        }
        int endPos = this.currentLine.indexOf(TAG_END);
        while (endPos == -1) {
            String newLine = this.m_HtmlFile.readLine();
            if (newLine == null) {
                SilverLogger.getLogger((Object)this).error("end of file", new Object[0]);
                return;
            }
            this.currentLine = this.currentLine + newLine;
            endPos = this.currentLine.indexOf(TAG_END);
        }
        String fieldName = this.currentLine.substring(beginPos + TAG_BEGIN.length(), endPos);
        if (fieldName.endsWith(".label")) {
            fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
            this.printFieldLabel(out, fieldName, pc);
        } else {
            this.printField(out, fieldName, pc);
        }
        this.currentLine = this.currentLine.substring(endPos + TAG_END.length(), this.currentLine.length());
    }

    private void printField(PrintWriter out, String fieldName, PagesContext pc) {
        try {
            Field field;
            String currentFieldName = fieldName;
            boolean fieldFound = false;
            boolean workflowPrintForm = false;
            if (currentFieldName.indexOf(46) != -1) {
                currentFieldName = currentFieldName.substring(currentFieldName.indexOf(46));
                workflowPrintForm = true;
            }
            for (FieldTemplate fieldTemplate : this.getFieldTemplates()) {
                FieldDisplayer<Field> fieldDisplayer;
                if (fieldTemplate == null || !fieldTemplate.getFieldName().equalsIgnoreCase(currentFieldName)) continue;
                if (workflowPrintForm) {
                    ((GenericFieldTemplate)fieldTemplate).setDisplayerName("simpletext");
                    ((GenericFieldTemplate)fieldTemplate).setFieldName(fieldName);
                }
                if ((fieldDisplayer = this.getFieldDisplayer(fieldTemplate)) != null) {
                    if (!fieldTemplate.isRepeatable()) {
                        Field field2 = this.getSureField(fieldTemplate, this.record, 0);
                        fieldDisplayer.display(out, field2, fieldTemplate, pc);
                    } else {
                        boolean isWriting = !"simpletext".equals(fieldTemplate.getDisplayerName()) && !fieldTemplate.isReadOnly();
                        int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
                        out.println("<ul class=\"repeatable-field-list field_" + fieldName + "\">");
                        for (int occ = 0; occ < maxOccurrences; ++occ) {
                            Field field3 = this.getSureField(fieldTemplate, this.record, occ);
                            if (!this.pagesContext.isDesignMode() && !isWriting && occ != 0 && field3.isNull()) continue;
                            if (occ != 0) {
                                ((GenericFieldTemplate)fieldTemplate).setMandatory(false);
                            }
                            out.println("<li class=\"repeatable-field-list-element" + occ + "\">");
                            fieldDisplayer.display(out, field3, fieldTemplate, pc);
                            out.println("</li>");
                        }
                        out.println("</ul>");
                    }
                }
                fieldFound = true;
                break;
            }
            if (!fieldFound && (field = this.record.getField(fieldName)) != null) {
                out.print(field.getValue(pc.getLanguage()));
            }
        }
        catch (FormException fe) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnRendering((String)"fieldName", (Object)fieldName), new Object[0]);
        }
    }

    private void printFieldLabel(PrintWriter out, String fieldName, PagesContext pc) {
        fieldName = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.length());
        for (FieldTemplate fieldTemplate : this.getFieldTemplates()) {
            if (fieldTemplate == null || !fieldTemplate.getFieldName().equalsIgnoreCase(fieldName)) continue;
            out.print(fieldTemplate.getLabel(pc.getLanguage()));
            break;
        }
    }

    @Override
    public void display(JspWriter jw, PagesContext pagesContext, DataRecord record) {
        String recordId = "";
        try {
            recordId = record.getId();
            jw.write(this.toString(pagesContext, record));
        }
        catch (IOException fe) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnRendering((String)"record data", (Object)recordId), (Throwable)fe);
        }
    }

    @Override
    public String toString(PagesContext pageContext, DataRecord record) {
        this.record = record;
        this.pagesContext = pageContext;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
        try {
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)buffer, Charsets.UTF_8), true);
            out.println(this.getSkippableSnippet(pageContext));
            out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
            this.parseFile(out);
            out.flush();
        }
        catch (FileNotFoundException fe) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnOpeningFile((String)"from record"), (Throwable)fe);
        }
        catch (IOException fe) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnRendering((String)"record data for HTML layer", (Object)""), (Throwable)fe);
        }
        return new String(buffer.toByteArray(), Charsets.UTF_8);
    }

    @Override
    public String getTitle() {
        return "";
    }
}

