/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.kernel.util.StringUtil;

public class LdapField
extends TextField {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "ldap";
    public static final String VARIABLE_LOGIN = "$$login";
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public LDAPConnection connectLdap(String host, String port) throws FormException {
        if (!StringUtil.isDefined((String)host) || !StringUtil.isDefined((String)port)) {
            throw new FormException("LDAP connection to " + host + ":" + port + " failed!", new String[0]);
        }
        try {
            LDAPConnection ldapConnection = new LDAPConnection();
            int portInt = Integer.parseInt(port);
            ldapConnection.connect(host, portInt);
            return ldapConnection;
        }
        catch (Exception e) {
            throw new FormException(e);
        }
    }

    public void disconnectLdap(LDAPConnection connection) throws FormException {
        try {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new FormException(e);
        }
    }

    public void bindLdap(LDAPConnection ldapConnection, String version, String distinguishedName, byte[] password) throws FormException {
        if (!StringUtil.isDefined((String)version) || !StringUtil.isDefined((String)distinguishedName)) {
            throw new FormException("Cannot bind " + distinguishedName + " in LDAP", new String[0]);
        }
        try {
            int versionInt = Integer.parseInt(version);
            ldapConnection.bind(versionInt, distinguishedName, password);
        }
        catch (Exception e) {
            throw new FormException(e);
        }
    }

    public void setConstraintLdap(LDAPConnection ldapConnection, String maxResultDisplayed) throws FormException {
        try {
            int maxResultDisplayedInt = Integer.parseInt(maxResultDisplayed);
            LDAPSearchConstraints ldapConstraint = new LDAPSearchConstraints();
            ldapConstraint.setMaxResults(maxResultDisplayedInt);
            ldapConnection.setConstraints((LDAPConstraints)ldapConstraint);
        }
        catch (Exception e) {
            throw new FormException(e);
        }
    }

    public Collection<String> searchLdap(LDAPConnection ldapConnection, String baseDn, String scope, String filter, String attribute, boolean typesOnly, String currentUserId) throws FormException {
        LDAPSearchResults searchResult;
        filter = LdapField.parseFilter(filter, currentUserId);
        String[] tabSearchAttribute = null;
        try {
            int scopeInt = 2;
            if (StringUtil.isDefined((String)scope) && StringUtil.isInteger((String)scope)) {
                scopeInt = Integer.parseInt(scope);
            }
            if (StringUtil.isDefined((String)attribute)) {
                tabSearchAttribute = new String[]{attribute};
            }
            searchResult = ldapConnection.search(baseDn, scopeInt, filter, tabSearchAttribute, typesOnly);
        }
        catch (Exception e) {
            throw new FormException(e);
        }
        if (searchResult == null) {
            return List.of();
        }
        return LdapField.processSearchResult(ldapConnection, searchResult, tabSearchAttribute);
    }

    private static List<String> processSearchResult(LDAPConnection ldapConnection, LDAPSearchResults searchResult, String[] tabSearchAttribute) throws FormException {
        ArrayList<String> listRes = new ArrayList<String>();
        String theValue = null;
        try {
            for (int nbRead = 0; searchResult.hasMore() && ldapConnection.getSearchConstraints().getMaxResults() > nbRead; ++nbRead) {
                LDAPEntry entry = searchResult.next();
                if (tabSearchAttribute != null) {
                    LDAPAttribute ldapAttribute = entry.getAttribute(tabSearchAttribute[0]);
                    if (ldapAttribute == null) continue;
                    theValue = ldapAttribute.getStringValue();
                    continue;
                }
                theValue = entry.getDN();
                if (!StringUtil.isDefined((String)theValue)) continue;
                listRes.add(theValue);
            }
        }
        catch (LDAPException e) {
            throw new FormException(e);
        }
        return listRes;
    }

    private static String parseFilter(String filter, String currentUserId) throws FormException {
        if (filter != null && filter.contains(VARIABLE_LOGIN)) {
            try {
                String valueLogin = User.getById((String)currentUserId).getLogin();
                filter = filter.replace(VARIABLE_LOGIN, valueLogin);
            }
            catch (Exception e) {
                throw new FormException(e);
            }
        }
        return filter;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

