/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ActifyDocumentProcessor {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.attachment.Attachment");
    private final SilverLogger logger = SilverLogger.getLogger((Object)this);

    public static boolean isActifySupportEnabled() {
        return settings.getBoolean("ActifyPublisherEnable", false);
    }

    public static String getCRONForActifyImport() {
        return settings.getString("ScheduledProcessActify");
    }

    public static String getCRONForActifyPurge() {
        return settings.getString("ScheduledPurgeActify");
    }

    public static String getActifySourcePath() {
        return FileRepositoryManager.getTemporaryPath() + settings.getString("ActifyPathSource");
    }

    public static String getActifyResultPath() {
        return FileRepositoryManager.getTemporaryPath() + settings.getString("ActifyPathResult");
    }

    public static String[] getSupportedCADExtensions() {
        String extensions = settings.getString("Actify3dFiles");
        if (StringUtil.isDefined((String)extensions)) {
            return extensions.split(",");
        }
        return new String[0];
    }

    public static int getDelayBeforeImport() {
        return Integer.parseInt(settings.getString("DelayBeforeProcess"));
    }

    public static int getDelayBeforePurge() {
        return Integer.parseInt(settings.getString("DelayBeforePurge"));
    }

    public static boolean isCADDocumentSupported(String fileName) {
        String[] extensions = ActifyDocumentProcessor.getSupportedCADExtensions();
        String type = FileRepositoryManager.getFileExtension(fileName);
        boolean fileForActify = false;
        for (int i = 0; i < extensions.length && !fileForActify; ++i) {
            fileForActify = type.equalsIgnoreCase(extensions[i]);
        }
        return fileForActify;
    }

    public static ActifyDocumentProcessor getProcessor() {
        return (ActifyDocumentProcessor)ServiceProvider.getService(ActifyDocumentProcessor.class, (Annotation[])new Annotation[0]);
    }

    public void process(SimpleDocument document) throws IOException {
        if (ActifyDocumentProcessor.isActifySupportEnabled()) {
            String componentId = document.getPk().getInstanceId();
            String id = document.getForeignId();
            String fileName = document.getFilename();
            if (ActifyDocumentProcessor.isCADDocumentSupported(fileName)) {
                String normalizedFileName;
                this.logger.debug("CAD document supported by Actify detected: {0}", new Object[]{fileName});
                String dirPrefix = document.isVersioned() ? "v_" : "a_";
                String dirDestName = dirPrefix + componentId + "_" + id;
                String actifyWorkingPath = ActifyDocumentProcessor.getActifySourcePath() + File.separatorChar + dirDestName;
                File destDir = new File(actifyWorkingPath);
                if (!destDir.exists()) {
                    FileUtils.forceMkdir((File)destDir);
                }
                if ((normalizedFileName = FilenameUtils.normalize((String)fileName)) == null) {
                    normalizedFileName = FilenameUtils.getName((String)fileName);
                }
                String destFile = actifyWorkingPath + File.separatorChar + normalizedFileName;
                FileRepositoryManager.copyFile(document.getAttachmentPath(), destFile);
            }
        }
    }

    protected ActifyDocumentProcessor() {
        this.prepareActifyDirectories();
    }

    private void prepareActifyDirectories() {
        try {
            if (ActifyDocumentProcessor.isActifySupportEnabled()) {
                File dir = new File(ActifyDocumentProcessor.getActifySourcePath());
                if (!dir.exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
                if (!(dir = new File(ActifyDocumentProcessor.getActifyResultPath())).exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

