/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.cmis.SilverpeasCmisSettings;
import org.silverpeas.core.cmis.model.Application;
import org.silverpeas.core.cmis.model.CmisObject;
import org.silverpeas.core.cmis.model.ContributionFolder;
import org.silverpeas.core.cmis.model.DocumentFile;
import org.silverpeas.core.cmis.model.Publication;
import org.silverpeas.core.cmis.model.Space;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.util.ServiceProvider;

@Provider
public class CmisObjectFactory {
    public static CmisObjectFactory getInstance() {
        return (CmisObjectFactory)ServiceProvider.getService(CmisObjectFactory.class, (Annotation[])new Annotation[0]);
    }

    public Space createRootSpace(String language) {
        User admin = User.getMainAdministrator();
        Date spawningDate = admin.getCreationDate() != null ? admin.getCreationDate() : admin.getStateSaveDate();
        String name = SilverpeasCmisSettings.get().getRepositoryName();
        return (Space)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new Space((ResourceIdentifier)Space.ROOT_ID, name, language).setParentId(null).setDescription("The Collaborative's root space"))).setCreator(admin.getDisplayedName()))).setCreationDate(spawningDate.getTime()))).setLastModifier(admin.getDisplayedName()))).setLastModificationDate(spawningDate.getTime()))).setAcesSupplier(this::theCommonsACE);
    }

    public Space createSpace(SpaceInstLight space, String language) {
        long lastModificationDate;
        User lastModifier;
        Object fatherId;
        if (space.getFatherId() == null) {
            fatherId = Space.ROOT_ID.asString();
        } else {
            String idPrefix = "WA";
            fatherId = (space.getFatherId().startsWith("WA") ? "" : "WA") + space.getFatherId();
        }
        User creator = space.getCreator();
        long creationDate = this.inMilliseconds(space.getCreationDate(), space.getLastUpdateDate());
        if (space.getUpdatedBy() < 0) {
            lastModifier = creator;
            lastModificationDate = creationDate;
        } else {
            lastModifier = space.getLastUpdater();
            lastModificationDate = space.getLastUpdateDate().getTime();
        }
        return (Space)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new Space((ResourceIdentifier)space.getIdentifier(), space.getName(language), language).setParentId((String)fatherId).setDescription(space.getDescription(language)))).setCreator(creator.getDisplayedName()))).setCreationDate(creationDate))).setLastModifier(lastModifier.getDisplayedName()))).setLastModificationDate(lastModificationDate))).setAcesSupplier(this::theCommonsACE);
    }

    public Application createApplication(ComponentInstLight component, String language) {
        long lastModificationDate;
        User lastModifier;
        User creator = User.getById((String)String.valueOf(component.getCreatedBy()));
        long creationDate = this.inMilliseconds(component.getCreationDate(), component.getLastUpdateDate());
        if (component.getUpdatedBy() < 0) {
            lastModifier = creator;
            lastModificationDate = creationDate;
        } else {
            lastModifier = User.getById((String)String.valueOf(component.getUpdatedBy()));
            lastModificationDate = component.getLastUpdateDate().getTime();
        }
        return (Application)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new Application((ResourceIdentifier)component.getIdentifier(), component.getName(language), language).setParentId(component.getSpaceId()).setDescription(component.getDescription(language)))).setCreator(creator.getDisplayedName()))).setCreationDate(creationDate))).setLastModifier(lastModifier.getDisplayedName()))).setLastModificationDate(lastModificationDate))).setAcesSupplier(this::theCommonsACE);
    }

    public ContributionFolder createContributionFolder(NodeDetail node, String language) {
        String parentId = node.getFatherPK().isRoot() ? node.getIdentifier().getComponentInstanceId() : ContributionIdentifier.from((ResourceReference)node.getFatherPK(), (String)"Node").asString();
        return (ContributionFolder)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new ContributionFolder(node.getIdentifier(), node.getName(language), language).setParentId(parentId).setDescription(node.getDescription(language)))).setCreator(node.getCreator().getDisplayedName()))).setCreationDate(this.inMilliseconds(node.getCreationDate(), node.getLastUpdateDate())))).setLastModifier(node.getLastUpdater().getDisplayedName()))).setLastModificationDate(node.getLastUpdateDate().getTime()))).setAcesSupplier(this::theCommonsACE);
    }

    public Publication createPublication(PublicationDetail pub, ContributionIdentifier folder, String language) {
        String parentId = folder.getLocalId().equals("0") ? folder.getComponentInstanceId() : folder.asString();
        return (Publication)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new Publication(pub.getIdentifier(), pub.getName(language), language).setParentId(parentId).setDescription(pub.getDescription(language)))).setCreator(pub.getCreator().getDisplayedName()))).setCreationDate(this.inMilliseconds(pub.getCreationDate(), pub.getLastUpdateDate())))).setLastModifier(pub.getLastUpdater().getDisplayedName()))).setLastModificationDate(pub.getLastUpdateDate().getTime()))).setAcesSupplier(this::theCommonsACE);
    }

    public DocumentFile createDocument(SimpleDocument document, ContributionIdentifier parentId) {
        User updater;
        Date updateDate;
        if (document.getLastUpdater() == null) {
            updateDate = document.getCreationDate();
            updater = document.getCreator();
        } else {
            updateDate = document.getLastUpdateDate();
            updater = document.getLastUpdater();
        }
        boolean readOnly = document.isReadOnly() || document.isVersioned() && !document.isEdited();
        return (DocumentFile)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)((CmisObject)((Object)new DocumentFile(document.getIdentifier(), document.getFilename(), document.getLanguage()).setTitle(document.getTitle()).setLastComment(document.getComment()).setMimeType(document.getContentType()).setSize(document.getSize()).setReadOnly(readOnly).setParentId(parentId.asString()).setDescription(document.getDescription()))).setCreator(document.getCreator().getDisplayedName()))).setCreationDate(this.inMilliseconds(document.getCreationDate(), document.getLastUpdateDate())))).setLastModifier(updater.getDisplayedName()))).setLastModificationDate(updateDate.getTime()))).setAcesSupplier(this::theCommonsACE);
    }

    private List<Ace> theCommonsACE(User user) {
        AccessControlEntryImpl entry = new AccessControlEntryImpl();
        entry.setPrincipal((Principal)new AccessControlPrincipalDataImpl(user.getLogin()));
        entry.setPermissions(new ArrayList());
        entry.getPermissions().add("cmis:read");
        entry.setDirect(true);
        return Collections.singletonList(entry);
    }

    private long inMilliseconds(Date date, Date defaultDate) {
        Date dateToUse;
        Date date2 = dateToUse = date == null ? defaultDate : date;
        if (dateToUse == null) {
            User admin = User.getMainAdministrator();
            dateToUse = admin.getCreationDate() != null ? admin.getCreationDate() : admin.getStateSaveDate();
        }
        return dateToUse.getTime();
    }
}

