/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cmis.model.TypeId;
import org.silverpeas.kernel.util.StringUtil;

public abstract class CmisObject
extends ObjectDataImpl {
    private final String id;
    private final String name;
    private String description;
    private String creator;
    private String lastModifier;
    private long creationDate;
    private long lastModificationDate;
    private transient Function<User, List<Ace>> aclSupplier = u -> Collections.emptyList();
    private final String language;

    CmisObject(ResourceIdentifier id, String name, String language) {
        this.id = id.asString();
        this.name = name;
        this.language = language;
    }

    public String getId() {
        return this.id;
    }

    public abstract String getSymbol();

    public abstract boolean isFileable();

    public boolean isDocument() {
        return this.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return StringUtil.isDefined((String)this.getSymbol()) ? this.getSymbol() + " " + this.getName() : this.getName();
    }

    public String getLanguage() {
        return this.language;
    }

    public abstract BaseTypeId getBaseTypeId();

    public abstract TypeId getTypeId();

    public String getDescription() {
        return this.description;
    }

    public <T extends CmisObject> T setDescription(String description) {
        this.description = description;
        return this.self();
    }

    public String getCreator() {
        return this.creator;
    }

    public <T extends CmisObject> T setCreator(String creator) {
        this.creator = creator;
        return this.self();
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public <T extends CmisObject> T setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
        return this.self();
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public <T extends CmisObject> T setCreationDate(long creationDate) {
        this.creationDate = creationDate;
        return this.self();
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public <T extends CmisObject> T setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
        return this.self();
    }

    public <T extends CmisObject> T addACEs(User user) {
        List<Ace> aces = this.aclSupplier.apply(user);
        if (this.getAcl() == null) {
            AccessControlListImpl acl = new AccessControlListImpl(new ArrayList());
            acl.setExact(Boolean.valueOf(false));
            this.setAcl((Acl)acl);
            super.setIsExactAcl(Boolean.valueOf(true));
        }
        this.getAcl().getAces().addAll(aces);
        return this.self();
    }

    public void setAcl(Acl acl) {
        super.setAcl(acl);
    }

    public void setIsExactAcl(Boolean isExactACL) {
    }

    public <T extends CmisObject> T setAcesSupplier(Function<User, List<Ace>> supplier) {
        this.aclSupplier = supplier;
        return this.self();
    }

    public Acl getAcl() {
        return super.getAcl();
    }

    public AllowableActions getAllowableActions() {
        return super.getAllowableActions();
    }

    public <T extends CmisObject> T setAllowableActions() {
        Supplier<Set<Action>> supplier = this.getAllowableActionsSupplier();
        AllowableActionsImpl allowableActions = new AllowableActionsImpl();
        allowableActions.setAllowableActions(supplier.get());
        this.setAllowableActions((AllowableActions)allowableActions);
        return this.self();
    }

    protected abstract Supplier<Set<Action>> getAllowableActionsSupplier();

    protected Set<Action> theCommonActions() {
        EnumSet<Action> actions = EnumSet.noneOf(Action.class);
        actions.add(Action.CAN_GET_PROPERTIES);
        actions.add(Action.CAN_GET_ACL);
        return actions;
    }

    private <T extends CmisObject> T self() {
        return (T)((Object)this);
    }
}

