/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Bean
@Singleton
public class SilverpeasCmisSettings {
    private static final String REPO_ID = "cmis.repository.id";
    private static final String REPO_NAME = "cmis.repository.name";
    private static final String REPO_DESC = "cmis.repository.description";
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.cmis.cmisSettings");
    private final Properties defaultSettings = new Properties();

    private SilverpeasCmisSettings() {
    }

    public static SilverpeasCmisSettings get() {
        return (SilverpeasCmisSettings)ServiceProvider.getService(SilverpeasCmisSettings.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    private void load() {
        InputStream stream = this.getClass().getResourceAsStream("/repository.properties");
        try {
            this.defaultSettings.load(stream);
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error("Unable to load the cmis-repository.properties CMIS configuration file", (Throwable)e);
        }
    }

    public String getRepositoryId() {
        return this.settings.getString(REPO_ID, this.defaultSettings.getProperty(REPO_ID));
    }

    public String getRepositoryName() {
        return this.settings.getString(REPO_NAME, this.defaultSettings.getProperty(REPO_NAME));
    }

    public String getRepositoryDescription() {
        return this.settings.getString(REPO_DESC, this.defaultSettings.getProperty(REPO_DESC));
    }
}

