/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.repository;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventFilter;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.util.SilverpeasList;

@Repository
public class DefaultCalendarEventRepository
extends BasicJpaEntityRepository<CalendarEvent>
implements CalendarEventRepository {
    private static final String CALENDARS_PARAMETER = "calendars";
    private static final String CALENDAR_PARAM = "calendar";
    private static final String CALENDAR_PARAMETER = "calendar";
    private static final String MOVE_CALENDAR_JPQL_PATTERN = "update CalendarComponent c set c.calendar = :target, c.lastUpdaterId = :lastUpdaterId, c.lastUpdateDate = :lastUpdateDate where c in (%s)";

    public CalendarEvent getByExternalId(Calendar calendar, String externalId) {
        NamedParameters params = this.newNamedParameters().add("calendar", (Object)calendar).add("externalId", (Object)externalId);
        return (CalendarEvent)this.getFromNamedQuery("calendarEventByCalendarAndExternalId", params);
    }

    public Stream<CalendarEvent> streamAll(CalendarEventFilter filter) {
        Optional optionalSynchroDate;
        String byParticipants = "ByParticipants";
        Object namedQuery = "calendarEvents";
        NamedParameters parameters = this.newNamedParameters();
        if (!filter.getCalendars().isEmpty()) {
            parameters.add(CALENDARS_PARAMETER, (Object)filter.getCalendars());
            namedQuery = (String)namedQuery + "ByCalendar";
        }
        if (!filter.getParticipants().isEmpty()) {
            parameters.add("participantIds", filter.getParticipants().stream().map(User::getId).collect(Collectors.toList()));
            namedQuery = (String)namedQuery + "ByParticipants";
        }
        if ((optionalSynchroDate = filter.getSynchronizationDateLimit()).isPresent()) {
            parameters.add("synchronizationDateLimit", optionalSynchroDate.get());
            if (((String)namedQuery).contains("ByParticipants")) {
                throw new UnsupportedOperationException("The filter on both participants and synchronization date isn't yet supported!");
            }
            namedQuery = (String)namedQuery + "BeforeSynchronizationDate";
        }
        return this.streamByNamedQuery((String)namedQuery, parameters, Object[].class).map(o -> (CalendarEvent)o[0]);
    }

    public long size(Calendar calendar) {
        NamedParameters params = this.newNamedParameters().add("calendar", (Object)calendar);
        return (Long)this.getFromNamedQuery("calendarEventCount", params, Long.class);
    }

    public List<CalendarEvent> getAllBetween(CalendarEventFilter filter, Instant startDateTime, Instant endDateTime) {
        Object namedQuery = "calendarEvents";
        NamedParameters parameters = this.newNamedParameters();
        if (!filter.getCalendars().isEmpty()) {
            parameters.add(CALENDARS_PARAMETER, (Object)filter.getCalendars());
            namedQuery = (String)namedQuery + "ByCalendar";
        }
        if (!filter.getParticipants().isEmpty()) {
            parameters.add("participantIds", filter.getParticipants().stream().map(User::getId).collect(Collectors.toList()));
            namedQuery = (String)namedQuery + "ByParticipants";
        }
        namedQuery = (String)namedQuery + "ByPeriod";
        parameters.add("startDateTime", (Object)startDateTime).add("endDateTime", (Object)endDateTime);
        return this.streamByNamedQuery((String)namedQuery, parameters, Object[].class).map(o -> (CalendarEvent)o[0]).collect(Collectors.toList());
    }

    public CalendarEvent moveToCalendar(CalendarEvent event, Calendar target) {
        OperationContext fromCache = OperationContext.getFromCache();
        NamedParameters params = this.newNamedParameters().add("target", (Object)target).add("event", (Object)event).add("lastUpdaterId", (Object)fromCache.getUser().getId()).add("lastUpdateDate", (Object)new Timestamp(new Date().getTime()));
        String updateEventQuery = String.format(MOVE_CALENDAR_JPQL_PATTERN, "select e.component from CalendarEvent e where e = :event");
        this.updateFromJpqlQuery(updateEventQuery, params);
        String updateEventOccurrenceQuery = String.format(MOVE_CALENDAR_JPQL_PATTERN, "select o.component from CalendarEventOccurrence o where o.event = :event");
        this.updateFromJpqlQuery(updateEventOccurrenceQuery, params);
        this.getEntityManager().clear();
        return (CalendarEvent)this.getById(event.getId());
    }

    public void deleteAll(Calendar calendar) {
        NamedParameters params = this.newNamedParameters().add("calendar", (Object)calendar);
        String idQuery = "select e.id.id from CalendarEvent e where e.component.calendar = :calendar";
        String eventBatchQuery = "select e from CalendarEvent e where e.id.id in :eventIds";
        SilverpeasList ids = this.listFromJpqlString(idQuery, params, String.class);
        for (Collection batchIds : this.split((Collection)ids)) {
            params = this.newNamedParameters().add("eventIds", (Object)batchIds);
            this.listFromJpqlString(eventBatchQuery, params).forEach(CalendarEvent::delete);
        }
    }
}

