/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.ProfileInstManager;
import org.silverpeas.core.admin.user.dao.RoleDAO;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.Pair;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class ProfiledObjectManager {
    @Inject
    private ProfileInstManager profileInstManager;
    @Inject
    private OrganizationSchema organizationSchema;
    @Inject
    private RoleDAO roleDAO;

    protected ProfiledObjectManager() {
    }

    public List<ProfileInst> getProfiles(ProfiledObjectId objectRef, int componentId) throws AdminException {
        String[] asProfileIds;
        ArrayList<ProfileInst> profiles = new ArrayList<ProfileInst>();
        try {
            int objectId = Integer.parseInt(objectRef.getId());
            String objectType = objectRef.getType().getCode();
            asProfileIds = this.organizationSchema.userRole().getAllUserRoleIdsOfObject(objectId, objectType, componentId);
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
        for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
            ProfileInst profileInst = this.profileInstManager.getProfileInst(asProfileIds[nI], false);
            if (profileInst == null) continue;
            profiles.add(profileInst);
        }
        return profiles;
    }

    public String[] getUserProfileNames(ProfiledObjectId objectRef, int componentId, int userId, List<String> groupIds) throws AdminException {
        String[] stringArray;
        block9: {
            if (objectRef.isNotDefined()) {
                return new String[0];
            }
            Connection con = DBUtil.openConnection();
            try {
                stringArray = (String[])this.roleDAO.getRoles(con, ProfiledObjectIds.fromProfileObjectId(objectRef), Collections.singleton(componentId), groupIds, userId).stream().map(UserRoleRow::getRoleName).distinct().toArray(String[]::new);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(e.getMessage(), e);
                }
            }
            con.close();
        }
        return stringArray;
    }

    public Map<Pair<Integer, Integer>, Set<String>> getUserProfileNames(ProfiledObjectIds profiledObjectIds, Collection<Integer> componentIds, int userId, List<String> groupIds) throws AdminException {
        Map<Pair<Integer, Integer>, Set<String>> map;
        block9: {
            if (profiledObjectIds.isEmpty() || profiledObjectIds.stream().anyMatch("-1"::equals)) {
                return Collections.emptyMap();
            }
            Connection con = DBUtil.openConnection();
            try {
                map = this.roleDAO.getRoles(con, profiledObjectIds, componentIds, groupIds, userId).stream().collect(Collectors.groupingBy(r -> Pair.of((Object)r.getInstanceId(), (Object)r.getObjectId()), Collectors.mapping(UserRoleRow::getRoleName, Collectors.toSet())));
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(e.getMessage(), e);
                }
            }
            con.close();
        }
        return map;
    }

    public Map<String, List<String>> getUserProfileNames(ProfiledObjectType profiledObjectType, int componentId, int userId, List<String> groupIds) throws AdminException {
        HashMap hashMap;
        block10: {
            Connection con = DBUtil.openConnection();
            try {
                List<UserRoleRow> roles = this.roleDAO.getRoles(con, ProfiledObjectIds.ofType(profiledObjectType), Collections.singleton(componentId), groupIds, userId);
                HashMap objectProfiles = new HashMap(roles.size());
                roles.sort(Comparator.comparingInt(UserRoleRow::getObjectId));
                int currentObjectId = -1;
                ArrayList<String> roleNames = new ArrayList<String>();
                for (UserRoleRow role : roles) {
                    if (currentObjectId != role.getObjectId()) {
                        currentObjectId = role.getObjectId();
                        roleNames = new ArrayList();
                        objectProfiles.put(String.valueOf(currentObjectId), roleNames);
                    }
                    roleNames.add(role.getRoleName());
                }
                hashMap = objectProfiles;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(e.getMessage(), e);
                }
            }
            con.close();
        }
        return hashMap;
    }

    public List<ProfileInst> getProfiles(int componentId) throws AdminException {
        String[] asProfileIds;
        ArrayList<ProfileInst> profiles = new ArrayList<ProfileInst>();
        try {
            asProfileIds = this.organizationSchema.userRole().getAllObjectUserRoleIdsOfInstance(componentId);
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
        for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
            ProfileInst profileInst = this.profileInstManager.getProfileInst(asProfileIds[nI], false);
            profiles.add(profileInst);
        }
        return profiles;
    }
}

