/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;

public class GroupSelection
extends ClipboardSelection
implements Serializable {
    private static final String TYPE = "Group";
    public static final DataFlavor GROUP_FLAVOR = new DataFlavor(Group.class, "Group");
    private final Group group;

    public GroupSelection(Group group) {
        this.group = group;
        super.addFlavor(GROUP_FLAVOR);
    }

    @Override
    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (GROUP_FLAVOR.equals(parFlavor)) {
                transferedData = this.group;
            }
            throw e;
        }
        return transferedData;
    }

    @Override
    public IndexEntry getIndexEntry() {
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey("Groups", TYPE, this.group.getId()));
        indexEntry.setTitle(this.group.getName());
        indexEntry.setPreview(this.group.getDescription());
        return indexEntry;
    }

    @Override
    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.group.getId());
        keyData.setTitle(this.group.getName());
        keyData.setCreationDate(this.group.getCreationDate());
        keyData.setDesc(this.group.getDescription());
        keyData.setType(TYPE);
        return keyData;
    }
}

