/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.googledriver;

import com.google.api.client.json.GenericJson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

class GoogleEntitySimpleAttributePathResolver {
    private static final Pattern PATH_PART_DECODER = Pattern.compile("(?i)^\\s*(\\S+)\\s*");

    static <T extends GenericJson> Object resolve(T entity, String attributePath) {
        return GoogleEntitySimpleAttributePathResolver.resolve(entity, GoogleEntitySimpleAttributePathResolver.decodePath(attributePath));
    }

    static <T extends GenericJson> Object resolve(T entity, AttributePathDecoder decoder) {
        return GoogleEntitySimpleAttributePathResolver.resolvePath(entity, decoder, 0, entity);
    }

    private GoogleEntitySimpleAttributePathResolver() {
        throw new IllegalAccessError("Utility class");
    }

    private static <T extends GenericJson> Object resolvePath(T entity, AttributePathDecoder attributePathDecoder, int pathLevel, Object data) {
        if (data instanceof GenericJson) {
            GenericJson json = (GenericJson)data;
            String[] path = attributePathDecoder.getExplodedPath();
            String pathPart = path[pathLevel];
            List subData = json.get((Object)pathPart);
            if (path.length == pathLevel + 1) {
                return GoogleEntitySimpleAttributePathResolver.decodeResult(subData);
            }
            if (subData instanceof List) {
                subData = ((List)subData).stream().map(i -> GoogleEntitySimpleAttributePathResolver.decodeValue(entity, attributePathDecoder, i)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return GoogleEntitySimpleAttributePathResolver.resolvePath(entity, attributePathDecoder, pathLevel + 1, subData);
        }
        if (data instanceof List) {
            List result = ((List)data).stream().flatMap(o -> Stream.of(GoogleEntitySimpleAttributePathResolver.resolvePath(entity, attributePathDecoder, pathLevel, o))).filter(Objects::nonNull).collect(Collectors.toList());
            return GoogleEntitySimpleAttributePathResolver.decodeResult(result);
        }
        throw new SilverpeasRuntimeException("unknown ");
    }

    private static Object decodeResult(Object subData) {
        if (subData instanceof List) {
            List list = (List)subData;
            if (list.size() == 1) {
                subData = list.get(0);
            } else if (list.isEmpty()) {
                subData = null;
            }
        }
        return subData;
    }

    private static <T extends GenericJson> GenericJson decodeValue(T entity, AttributePathDecoder attributePathDecoder, Object data) {
        GenericJson result;
        if (!(data instanceof GenericJson) && data instanceof Map) {
            GenericJson temp = new GenericJson();
            ((Map)data).forEach((arg_0, arg_1) -> ((GenericJson)temp).set(arg_0, arg_1));
            temp.set("id", entity.get((Object)"id"));
            result = temp;
        } else {
            result = "customSchemas".equals(attributePathDecoder.getExplodedPath()[0]) && data == null ? new GenericJson() : null;
        }
        return result;
    }

    static AttributePathDecoder decodePath(String attributePath) {
        SimpleAttributePathDecoder attrPathDecoder = new SimpleAttributePathDecoder(attributePath);
        if (!attrPathDecoder.isMatching()) {
            String message = "attribute path '" + attributePath + "' is not correct !";
            SilverLogger.getLogger(GoogleEntitySimpleAttributePathResolver.class).error(message, new Object[0]);
            throw new SilverpeasRuntimeException(message);
        }
        return attrPathDecoder;
    }

    static class SimpleAttributePathDecoder
    extends AttributePathDecoder {
        SimpleAttributePathDecoder(String attributePath) {
            super(attributePath);
        }

        @Override
        protected void decode() {
            Matcher matcher = PATH_PART_DECODER.matcher(this.getPath());
            if (matcher.find()) {
                this.path = matcher.group(1);
                this.explodedPath = this.path.split("[.]");
                this.match = true;
            }
        }
    }

    static abstract class AttributePathDecoder {
        String path;
        String[] explodedPath;
        boolean match = false;

        AttributePathDecoder(String attributePath) {
            this.path = attributePath;
            this.decode();
            this.explodedPath = this.path.split("[.]");
        }

        protected abstract void decode();

        public boolean isMatching() {
            return this.match;
        }

        public String getPath() {
            return this.path;
        }

        String[] getExplodedPath() {
            return this.explodedPath;
        }
    }
}

