/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Transient;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.admin.component.model.ComponentI18N;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasSharedComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.model.SpacePath;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

public class ComponentInstLight
extends AbstractI18NBean<ComponentI18N>
implements SilverpeasSharedComponentInstance {
    private static final long serialVersionUID = 4859368422448142768L;
    private String id;
    private String domainFatherId;
    private String name;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private int createdBy = -1;
    private int updatedBy = -1;
    private int removedBy = -1;
    private int orderNum = -1;
    private String creatorName = null;
    private String updaterName = null;
    private String removerName = null;
    private boolean isInheritanceBlocked = false;
    private boolean hidden = false;
    private boolean publicApp = false;
    @Transient
    private ComponentInst cachedComponentInst;

    @Override
    protected Class<ComponentI18N> getTranslationType() {
        return ComponentI18N.class;
    }

    public ComponentInstLight() {
        this.id = "";
        this.domainFatherId = "";
        this.name = "";
    }

    public ComponentInstLight(ComponentInstanceRow compo) {
        this.id = Integer.toString(compo.id);
        this.domainFatherId = Integer.toString(compo.spaceId);
        this.setLabel(compo.name);
        this.setDescription(compo.description);
        this.setLanguage(compo.lang);
        this.name = compo.componentName;
        if (compo.createTime != null) {
            this.createDate = new Date(Long.parseLong(compo.createTime));
        }
        if (compo.updateTime != null) {
            this.updateDate = new Date(Long.parseLong(compo.updateTime));
        }
        if (compo.removeTime != null) {
            this.removeDate = new Date(Long.parseLong(compo.removeTime));
        }
        this.status = compo.status;
        this.createdBy = compo.createdBy;
        this.updatedBy = compo.updatedBy;
        this.removedBy = compo.removedBy;
        this.orderNum = compo.orderNum;
        this.isInheritanceBlocked = compo.inheritanceBlocked == 1;
        this.hidden = compo.hidden == 1;
        this.publicApp = compo.publicAccess == 1;
    }

    public BasicIdentifier getIdentifier() {
        return new BasicIdentifier(this.getLocalId(), this.getId());
    }

    public String getId() {
        return this.name + this.id;
    }

    public String getSpaceId() {
        return this.domainFatherId;
    }

    public int getLocalId() {
        return Integer.parseInt(this.id);
    }

    public void setLocalId(int id) {
        this.id = String.valueOf(id);
    }

    public void setDomainFatherId(String sDomainFatherId) {
        this.domainFatherId = sDomainFatherId;
    }

    public String getDomainFatherId() {
        return this.getSpaceId();
    }

    public boolean hasDomainFather() {
        return StringUtil.isDefined((String)this.domainFatherId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return super.getName();
    }

    public void setLabel(String label) {
        super.setName(label);
    }

    public Date getCreationDate() {
        return this.createDate;
    }

    public Date getRemovalDate() {
        return this.removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getRemoverName() {
        return this.removerName;
    }

    public void setRemoverName(String removerName) {
        this.removerName = removerName;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public int getRemovedBy() {
        return this.removedBy;
    }

    public int getUpdatedBy() {
        return this.updatedBy;
    }

    public User getCreator() {
        return User.getById((String)String.valueOf(this.getCreatedBy()));
    }

    public User getLastUpdater() {
        return User.getById((String)String.valueOf(this.getUpdatedBy()));
    }

    public String getPath(String separator) {
        SpacePath spacePath = SpacePath.getPath(this.domainFatherId);
        return spacePath.format(this.getLanguage(), true, separator);
    }

    public String getLabel(String language) {
        return super.getName(language);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public int getOrderPosition() {
        return this.getOrderNum();
    }

    public boolean isInheritanceBlocked() {
        return this.isInheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.isInheritanceBlocked = isInheritanceBlocked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPublic() {
        return this.publicApp;
    }

    public boolean isWorkflow() {
        Optional<WAComponent> component = WAComponent.getByName(this.getName());
        return component.isPresent() && component.get().isWorkflow();
    }

    public boolean isTopicTracker() {
        Optional<WAComponent> component = WAComponent.getByName(this.getName());
        return component.isPresent() && component.get().isTopicTracker();
    }

    public String getIcon(boolean bigOne) {
        return ComponentInstLight.getIcon((SilverpeasComponentInstance)this, bigOne);
    }

    public static String getIcon(SilverpeasComponentInstance instance, boolean bigOne) {
        String app = instance.isWorkflow() ? "processManager" : instance.getName();
        String size = bigOne ? "Big.png" : "Small.gif";
        return URLUtil.getApplicationURL() + "/util/icons/component/" + app + size;
    }

    public Collection<SilverpeasRole> getSilverpeasRolesFor(User user) {
        Set silverpeasRoles = SilverpeasRole.fromStrings((String[])OrganizationController.get().getUserProfiles(user.getId(), this.getId()));
        silverpeasRoles.remove(SilverpeasRole.MANAGER);
        return silverpeasRoles;
    }

    public String getParameterValue(String parameterName) {
        return this.getCachedComponentInst().getParameterValue(parameterName);
    }

    public boolean isRemoved() {
        return "R".equals(this.getStatus());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInstLight other = (ComponentInstLight)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }

    private ComponentInst getCachedComponentInst() {
        if (this.cachedComponentInst == null && StringUtil.isDefined((String)this.getId())) {
            this.cachedComponentInst = OrganizationController.get().getComponentInst(this.getId());
        }
        return this.cachedComponentInst;
    }
}

