/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public class ICCPackedColorModel
extends PackedColorModel {
    private final ICC_ColorSpace colorSpace;
    private final int[] maskArray;
    private final int[] maskOffsets;

    private static int getBits(Raster raster) {
        int bits = 0;
        SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int[] bitOffsets = sm.getBitOffsets();
        int[] sampleSizes = sm.getSampleSize();
        for (int i = 0; i < bitOffsets.length; ++i) {
            bits = Math.max(bits, bitOffsets[i] + sampleSizes[i]);
        }
        return bits;
    }

    public ICCPackedColorModel(ICC_ColorSpace colorSpace, Raster raster) {
        super(colorSpace, ICCPackedColorModel.getBits(raster), ((SinglePixelPackedSampleModel)raster.getSampleModel()).getBitMasks(), 0, true, 1, raster.getTransferType());
        this.colorSpace = colorSpace;
        this.maskArray = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getBitMasks();
        this.maskOffsets = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getBitOffsets();
    }

    @Override
    public int getRGB(int pixel) {
        float[] rgbF = this.colorSpace.toRGB(new float[]{(float)(pixel & this.maskArray[0]) / (float)((long)this.maskArray[0] & 0xFFFFFFFFL), (float)(pixel & this.maskArray[1]) / (float)((long)this.maskArray[1] & 0xFFFFFFFFL), (float)(pixel & this.maskArray[2]) / (float)((long)this.maskArray[2] & 0xFFFFFFFFL), (float)(pixel & this.maskArray[3]) / (float)((long)this.maskArray[3] & 0xFFFFFFFFL)});
        return (int)(rgbF[0] * 255.0f) << 16 | (int)(rgbF[1] * 255.0f) << 8 | (int)(rgbF[2] * 255.0f) << 0;
    }

    @Override
    public int getRed(int pixel) {
        int rgb = this.getRGB(pixel);
        return (rgb & 0xFF0000) >> 16;
    }

    @Override
    public int getGreen(int pixel) {
        int rgb = this.getRGB(pixel);
        return (rgb & 0xFF00) >> 8;
    }

    @Override
    public int getBlue(int pixel) {
        int rgb = this.getRGB(pixel);
        return rgb & 0xFF;
    }

    @Override
    public int getAlpha(int pixel) {
        return 255;
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sm = raster.getSampleModel();
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel spsm = (SinglePixelPackedSampleModel)sm;
        if (spsm.getNumBands() != this.getNumComponents()) {
            return false;
        }
        int[] bitMasks = spsm.getBitMasks();
        for (int i = 0; i < 4; ++i) {
            if (bitMasks[i] == this.maskArray[i]) continue;
            return false;
        }
        return raster.getTransferType() == this.transferType;
    }

    @Override
    public final int[] getComponents(Object pixel, int[] components, int offset) {
        int intpixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] bdata = (byte[])pixel;
                intpixel = bdata[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sdata = (short[])pixel;
                intpixel = sdata[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] idata = (int[])pixel;
                intpixel = idata[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(intpixel, components, offset);
    }

    @Override
    public int[] getComponents(int pixel, int[] components, int offset) {
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[offset + numComponents];
        }
        for (int i = 0; i < numComponents; ++i) {
            components[offset + i] = (pixel & this.maskArray[i]) >>> this.maskOffsets[i];
        }
        return components;
    }
}

