/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.RecordId;

public class RecordIdSet {
    private final Map<String, IntSet> seenIds = new HashMap<String, IntSet>();

    public boolean addIfNotPresent(RecordId id) {
        String segmentId = id.getSegmentId().toString();
        IntSet offsets = this.seenIds.get(segmentId);
        if (offsets == null) {
            offsets = new IntSet();
            this.seenIds.put(segmentId, offsets);
        }
        return offsets.add(id.getRecordNumber());
    }

    public boolean contains(RecordId id) {
        String segmentId = id.getSegmentId().toString();
        IntSet offsets = this.seenIds.get(segmentId);
        return offsets != null && offsets.contains(id.getRecordNumber());
    }

    static class IntSet {
        int[] elements;

        IntSet() {
        }

        boolean add(int n) {
            if (this.elements == null) {
                this.elements = new int[1];
                this.elements[0] = n;
                return true;
            }
            int k = Arrays.binarySearch(this.elements, n);
            if (k < 0) {
                int l = -k - 1;
                int[] e = new int[this.elements.length + 1];
                System.arraycopy(this.elements, 0, e, 0, l);
                e[l] = n;
                int c = this.elements.length - l;
                if (c > 0) {
                    System.arraycopy(this.elements, l, e, l + 1, c);
                }
                this.elements = e;
                return true;
            }
            return false;
        }

        boolean contains(int n) {
            return this.elements != null && Arrays.binarySearch(this.elements, n) >= 0;
        }
    }
}

