/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.mylinks;

import java.lang.annotation.Annotation;
import java.net.URI;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.SilverpeasWebResource;

@Bean
@Singleton
public class MyLinksResourceURIs {
    public static final String MYLINKS_BASE_URI = "mylinks";
    public static final String MYLINKS_CATEGORY_URI_PART = "categories";

    public static MyLinksResourceURIs get() {
        return (MyLinksResourceURIs)ServiceProvider.getService(MyLinksResourceURIs.class, (Annotation[])new Annotation[0]);
    }

    public URI ofCategory(CategoryDetail category) {
        if (category == null || category.getId() == -1) {
            return null;
        }
        return this.getBase().path(MYLINKS_CATEGORY_URI_PART).path(String.valueOf(category.getId())).build(new Object[0]);
    }

    public URI ofLink(LinkDetail link) {
        if (link == null || link.getLinkId() == -1) {
            return null;
        }
        return this.getBase().path(String.valueOf(link.getLinkId())).build(new Object[0]);
    }

    private UriBuilder getBase() {
        return SilverpeasWebResource.getBasePathBuilder().path(MYLINKS_BASE_URI);
    }

    private MyLinksResourceURIs() {
    }
}

