/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.io.media.image.ImageInfoType;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.attachment.AbstractSimpleDocumentResource;
import org.silverpeas.core.webapi.attachment.SimpleDocumentEntity;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="documents/{componentId}/resource/{id}")
@Authorized
public class SimpleDocumentListResource
extends AbstractSimpleDocumentResource {
    @Inject
    private UserPrivilegeValidation validation;
    @PathParam(value="id")
    private String resourceId;
    @QueryParam(value="viewIndicators")
    private boolean viewIndicators = false;
    @QueryParam(value="viewWidthAndHeight")
    private boolean viewWidthAndHeight = false;
    @QueryParam(value="highestUserRole")
    private SilverpeasRole highestUserRole = null;

    public String getResourceId() {
        return this.resourceId;
    }

    @GET
    @Path(value="{lang}")
    @Produces(value={"application/json"})
    public List<SimpleDocumentEntity> getDocuments(@PathParam(value="lang") String lang) {
        SimpleDocumentList docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(this.getResourceReference(), DocumentType.attachment, lang);
        return this.asWebEntities((List<SimpleDocument>)docs);
    }

    @GET
    @Path(value="types/{type}/{lang}")
    @Produces(value={"application/json"})
    public List<SimpleDocumentEntity> getDocumentsByType(@PathParam(value="type") String type, @PathParam(value="lang") String lang) {
        DocumentType documentType = DocumentType.decode((String)type);
        if (documentType == null) {
            return Collections.emptyList();
        }
        SimpleDocumentList docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(this.getResourceReference(), documentType, lang);
        return this.asWebEntities((List<SimpleDocument>)docs);
    }

    private ResourceReference getResourceReference() {
        return new ResourceReference(this.getResourceId(), this.getComponentId());
    }

    private List<SimpleDocumentEntity> asWebEntities(List<SimpleDocument> docs) {
        SilverpeasRole userRole = this.highestUserRole != null ? this.highestUserRole : this.getHighestUserRole();
        return docs.stream().map(d -> {
            if (d.isVersioned() && !d.isPublic() && (userRole == SilverpeasRole.USER || userRole == SilverpeasRole.READER)) {
                return d.getLastPublicVersion();
            }
            return d;
        }).filter(d -> {
            try {
                this.validation.validateUserAuthorizationOnAttachment(this.getHttpServletRequest(), this.getUser(), d);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() != Response.Status.FORBIDDEN.getStatusCode()) {
                    throw e;
                }
                return false;
            }
            return true;
        }).map(d -> {
            SimpleDocumentEntity entity = SimpleDocumentEntity.fromAttachment(d);
            this.performViewIndicator((SimpleDocument)d, entity);
            this.performWidthAndHeight((SimpleDocument)d, entity);
            return entity;
        }).collect(Collectors.toList());
    }

    private void performViewIndicator(SimpleDocument d, SimpleDocumentEntity entity) {
        if (this.viewIndicators) {
            File file = new File(d.getAttachmentPath());
            entity.prewiewable(PreviewService.get().isPreviewable(file)).viewable(ViewService.get().isViewable(file)).displayAsContent(d.isDisplayableAsContent());
        }
    }

    private void performWidthAndHeight(SimpleDocument d, SimpleDocumentEntity entity) {
        if (this.viewWidthAndHeight && d.isContentImage()) {
            try {
                File file = new File(d.getAttachmentPath());
                String[] widthAndHeight = ImageTool.get().getImageInfo(file, new ImageInfoType[]{ImageInfoType.WIDTH_IN_PIXEL, ImageInfoType.HEIGHT_IN_PIXEL});
                if (widthAndHeight.length == 2) {
                    entity.widthInPixelOf(Integer.parseInt(widthAndHeight[0])).heightInPixelOf(Integer.parseInt(widthAndHeight[1]));
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            }
        }
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
    }
}

