/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import edu.psu.swe.scim.server.rest.UserResourceImpl;
import edu.psu.swe.scim.spec.adapter.FilterWrapper;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReferenceListWrapper;
import edu.psu.swe.scim.spec.protocol.data.PatchRequest;
import edu.psu.swe.scim.spec.protocol.data.SearchRequest;
import edu.psu.swe.scim.spec.protocol.search.SortOrder;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.resources.ScimUser;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.admin.scim.ScimLogger;
import org.silverpeas.core.webapi.admin.scim.ScimProtectedWebResource;
import org.silverpeas.core.webapi.admin.scim.ScimRequestContext;
import org.silverpeas.core.webapi.admin.scim.adaptation.SilverpeasPatchRequest;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="/domains/{domainId}/scim/Users")
@Authorized
@Alternative
@Priority(value=2010)
public class ScimV2UserResource
extends UserResourceImpl
implements ScimProtectedWebResource {
    @PathParam(value="domainId")
    private String domainId;
    @Inject
    private ScimRequestContext scimRequestContext;
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private HttpServletResponse httpResponse;

    @PostConstruct
    protected void initContext() {
        this.scimRequestContext.init(this.httpRequest, this.httpResponse, this.domainId);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/scim+json"})
    public Response getById(@PathParam(value="id") String id, @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) {
        return super.getById(id, attributes, excludedAttributes);
    }

    @GET
    @Produces(value={"application/scim+json"})
    public Response query(@QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes, @QueryParam(value="filter") FilterWrapper filter, @QueryParam(value="sortBy") AttributeReference sortBy, @QueryParam(value="sortOrder") SortOrder sortOrder, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count) {
        return super.query(attributes, excludedAttributes, filter, sortBy, sortOrder, startIndex, count);
    }

    @POST
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    public Response create(ScimUser resource, @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) {
        return super.create((ScimResource)resource, attributes, excludedAttributes);
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/scim+json"})
    public Response find(SearchRequest request) {
        return super.find(request);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    public Response update(ScimUser resource, @PathParam(value="id") String id, @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) {
        return super.update((ScimResource)resource, id, attributes, excludedAttributes);
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    public Response patch(@PathParam(value="id") String id, @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws IOException {
        StringWriter writer = new StringWriter();
        String charset = StringUtil.isDefined((String)this.httpRequest.getCharacterEncoding()) ? this.httpRequest.getCharacterEncoding() : Charsets.UTF_8.name();
        IOUtils.copy((InputStream)this.httpRequest.getInputStream(), (Writer)writer, (String)charset);
        String scimJson = writer.toString();
        String adaptedScimJson = scimJson.replaceAll("(?i)\"patchOperationList\":\\[", "\"adaptedPatchOperationList\":[").replaceAll("(?i)\"Operations\":\\[", "\"adaptedPatchOperationList\":[").replaceAll("(?i)\"path\":\"([^\"]+)\"", "\"adaptedPath\":\"$1\"").replaceAll("(?i)\"op\":\"Add\",", "\"op\":\"add\",").replaceAll("(?i)\"op\":\"Replace\",", "\"op\":\"replace\",").replaceAll("(?i)\"op\":\"Remove\",", "\"op\":\"remove\",");
        ScimLogger.logger().debug(() -> MessageFormat.format("patching data: {0}", scimJson));
        SilverpeasPatchRequest silverpeasPatchRequest = (SilverpeasPatchRequest)((Object)JSONCodec.decode((String)adaptedScimJson, SilverpeasPatchRequest.class));
        silverpeasPatchRequest.afterDecode();
        return super.patch((PatchRequest)silverpeasPatchRequest, id, attributes, excludedAttributes);
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response patch(PatchRequest patchRequest, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        throw new WebApplicationException(Response.Status.NOT_IMPLEMENTED);
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id) {
        return super.delete(id);
    }

    @Override
    public ScimRequestContext getSilverpeasContext() {
        return this.scimRequestContext;
    }
}

