/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellButton;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellCheckbox;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellIconPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellInputText;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellLink;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellRadio;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellSelect;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellText;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayEmptyCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPane;
import org.silverpeas.kernel.util.StringUtil;

public class ArrayLine
implements SimpleGraphicElement,
Comparable<ArrayLine> {
    private final List<SimpleGraphicElement> cells = new ArrayList<SimpleGraphicElement>();
    private final ArrayPane pane;
    private String css = null;
    private String id = null;
    private final List<ArrayLine> subLines = new ArrayList<ArrayLine>();

    public ArrayLine(ArrayPane pane) {
        this.pane = pane;
    }

    public void addSubline(ArrayLine subline) {
        this.subLines.add(subline);
    }

    public void setStyleSheet(String css) {
        this.css = css;
    }

    public String getStyleSheet() {
        return this.css;
    }

    private <T> ArrayCellText addArrayCellText(String text, T instance, Function<T, String> lazyText) {
        ArrayCellText cell = text == null && instance != null && lazyText != null ? new ArrayCellText(instance, lazyText, this) : new ArrayCellText(text, this);
        this.cells.add(cell);
        return cell;
    }

    public <T> ArrayCellText addArrayCellText(T instance, Function<T, String> lazyText) {
        return this.addArrayCellText(null, instance, lazyText);
    }

    public ArrayCellText addArrayCellText(String text) {
        return this.addArrayCellText(text, null, null);
    }

    public ArrayCellText addArrayCellText(int number) {
        return this.addArrayCellText(Integer.toString(number));
    }

    public ArrayCellText addArrayCellText(float number) {
        return this.addArrayCellText(Float.toString(number));
    }

    public ArrayCellLink addArrayCellLink(String text, String link2) {
        ArrayCellLink cell = new ArrayCellLink(text, link2, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellLink addArrayCellLink(String text, String link2, String target) {
        ArrayCellLink cell = new ArrayCellLink(text, link2, this);
        cell.setTarget(target);
        this.cells.add(cell);
        return cell;
    }

    public void addArrayEmptyCell() {
        ArrayEmptyCell cell = new ArrayEmptyCell();
        this.cells.add(cell);
    }

    public ArrayCellIconPane addArrayCellIconPane(IconPane iconPane) {
        ArrayCellIconPane cell = new ArrayCellIconPane(iconPane, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellInputText addArrayCellInputText(String name, String value) {
        ArrayCellInputText cell = new ArrayCellInputText(name, value, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellInputText addArrayCellInputText(ArrayCellInputText cell) {
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellSelect addArrayCellSelect(String name, String[] labels, String[] values) {
        ArrayCellSelect cell = new ArrayCellSelect(name, labels, values, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellSelect addArrayCellSelect(String name, List<String> values) {
        ArrayCellSelect cell = new ArrayCellSelect(name, values, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellButton addArrayCellButton(String name, String value, boolean activate) {
        ArrayCellButton cell = new ArrayCellButton(name, value, activate, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellRadio addArrayCellRadio(String name, String value, boolean checked) {
        ArrayCellRadio cell = new ArrayCellRadio(name, value, checked, this);
        this.cells.add(cell);
        return cell;
    }

    public ArrayCellCheckbox addArrayCellCheckbox(String name, String value, String onchange, boolean checked) {
        ArrayCellCheckbox cell = new ArrayCellCheckbox(name, value, checked, this);
        if (StringUtil.isDefined((String)onchange)) {
            cell.setAction(onchange);
        }
        this.cells.add(cell);
        return cell;
    }

    public SimpleGraphicElement getCellAt(int column) {
        try {
            return this.cells.get(column - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String printPseudoColumn() {
        return "<td><img src=\"" + GraphicElementFactory.getIconsPath() + "/1px.gif\" width=\"2\" height=\"2\" alt=\"\"/></td>";
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        if (StringUtil.isDefined((String)this.getId())) {
            result.append("<tr id=\"").append(this.getId()).append("\">");
        } else {
            result.append("<tr>");
        }
        for (SimpleGraphicElement element : this.cells) {
            result.append(element.print());
        }
        result.append("</tr>\n");
        for (ArrayLine line : this.subLines) {
            result.append(line.print());
        }
        return result.toString();
    }

    public String printWithPseudoColumns() {
        StringBuilder result = new StringBuilder();
        result.append("<tr>\n");
        result.append(ArrayLine.printPseudoColumn());
        for (SimpleGraphicElement element : this.cells) {
            result.append(element.print());
            result.append(ArrayLine.printPseudoColumn());
        }
        result.append("</tr>\n");
        for (ArrayLine line : this.subLines) {
            result.append(line.printWithPseudoColumns());
        }
        return result.toString();
    }

    @Override
    public int compareTo(@Nonnull ArrayLine other) {
        SimpleGraphicElement cell;
        Objects.requireNonNull(other);
        if (this.pane.getColumnToSort() == 0) {
            return 0;
        }
        int sort = this.pane.getColumnToSort();
        if (sort < 0) {
            sort = -sort;
        }
        if ((cell = this.getCellAt(sort)) == null) {
            return 0;
        }
        if (!(cell instanceof Comparable)) {
            return 0;
        }
        sort = ((Comparable)((Object)cell)).compareTo(other.getCellAt(sort));
        if (this.pane.getColumnToSort() < 0) {
            return -sort;
        }
        return sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayLine)) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (SimpleGraphicElement element : this.cells) {
            builder.append(element.hashCode());
        }
        return builder.toHashCode();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

