/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.ecs.ElementContainer;
import org.silverpeas.core.html.SupportedWebPlugin;
import org.silverpeas.core.html.WebPlugin;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.controller.SilverpeasWebUtil;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion;
import org.silverpeas.kernel.logging.SilverLogger;

public class IncludeJSPluginTag
extends SimpleTagSupport {
    private String plugin;

    public String getName() {
        return this.plugin;
    }

    public void setName(String plugin) {
        this.plugin = plugin.toUpperCase();
    }

    public void doTag() throws JspException, IOException {
        ElementContainer xhtml = new ElementContainer();
        try {
            xhtml = WebPlugin.get().getHtml(this.getName(), this.getLanguage());
            if (SupportedWebPlugin.Constants.LAYOUT.getName().equalsIgnoreCase(this.getName())) {
                JavascriptPluginInclusion.includeLayout(xhtml, this.getLookHelper());
            } else if (SupportedWebPlugin.Constants.USERSESSION.getName().equalsIgnoreCase(this.getName())) {
                JavascriptPluginInclusion.includeUserSession(xhtml, this.getLookHelper());
            }
        }
        catch (IllegalArgumentException ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)ex);
        }
        xhtml.output((Writer)this.getJspContext().getOut());
    }

    protected LookHelper getLookHelper() {
        return (LookHelper)this.getSessionAttribute("Silverpeas_LookHelper");
    }

    protected String getLanguage() {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return SilverpeasWebUtil.get().getUserLanguage(request);
    }

    protected <T> T getSessionAttribute(String name) {
        return (T)this.getJspContext().getAttribute(name, 3);
    }
}

