/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.session;

import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.domain.model.DomainProperties;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.cache.service.VolatileResourceCacheService;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.io.upload.UploadSession;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.sse.AbstractServerEvent;
import org.silverpeas.core.notification.sse.DefaultServerEventNotifier;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.server.channel.popup.PopupMessageService;
import org.silverpeas.core.notification.user.server.channel.server.ServerMessageService;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionValidationContext;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsManager;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.session.HTTPSessionInfo;
import org.silverpeas.core.web.session.OneShotSessionInfo;
import org.silverpeas.core.web.session.UserSessionEvent;
import org.silverpeas.core.web.session.UserSessionServerEvent;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class SessionManager
implements SessionManagement,
Initialization {
    private final Object mutex;
    private static final String NOTIFY_DATE_FORMAT = " HH:mm (dd/MM/yyyy) ";
    private static final String SESSION_MANAGER_JOB_NAME = "SessionManagerScheduler";
    private static final int DEFAULT_USER_SESSION_TIMEOUT = 600000;
    private static final int DEFAULT_ADMIN_SESSION_TIMEOUT = 1200000;
    private static final int DEFAULT_SCHEDULED_SESSION_MANAGEMENT_TIMESTAMP = 60000;
    private static final int DEFAULT_MAX_REFRESH_INTERVAL = 90000;
    private long userSessionTimeout = 600000L;
    private long adminSessionTimeout = 1200000L;
    private long scheduledSessionManagementTimeStamp = 60000L;
    private long maxRefreshInterval = 90000L;
    private final ConcurrentMap<String, SessionInfo> userDataSessions = new ConcurrentHashMap<String, SessionInfo>(100);
    private final ConcurrentMap<String, SessionInfo> anonymousSessions = new ConcurrentHashMap<String, SessionInfo>(1000);
    private final List<String> userNotificationSessions = Collections.synchronizedList(new ArrayList(100));
    @Inject
    private SilverStatisticsManager myStatisticsManager;
    @Inject
    private Scheduler scheduler;
    @Inject
    private DefaultServerEventNotifier defaultServerEventNotifier;
    @Inject
    private Event<UserSessionEvent> userSessionNotifier;

    protected SessionManager() {
        this.mutex = this;
    }

    public void init() {
        try {
            SettingBundle rl = ResourceLocator.getSettingBundle((String)"org.silverpeas.clipboard.settings.clipboardSettings");
            this.maxRefreshInterval = (60L + Long.parseLong(rl.getString("IntervalInSec"))) * 1000L;
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.peasCore.SessionManager");
            this.scheduledSessionManagementTimeStamp = this.convertMinuteInMilliseconds(settings.getLong("scheduledSessionManagementTimeStamp"));
            this.userSessionTimeout = this.convertMinuteInMilliseconds(settings.getLong("userSessionTimeout"));
            if (this.scheduledSessionManagementTimeStamp > this.userSessionTimeout) {
                this.scheduledSessionManagementTimeStamp = this.userSessionTimeout;
            }
            this.adminSessionTimeout = this.convertMinuteInMilliseconds(settings.getLong("adminSessionTimeout"));
            if (this.scheduledSessionManagementTimeStamp > this.adminSessionTimeout) {
                this.scheduledSessionManagementTimeStamp = this.adminSessionTimeout;
            }
            this.initSchedulerTimeStamp();
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void release() throws SchedulerException {
        this.scheduler.unscheduleJob(SESSION_MANAGER_JOB_NAME);
    }

    public SessionInfo validateSession(String sessionKey) {
        return this.validateSession(SessionValidationContext.withSessionKey((String)sessionKey));
    }

    public SessionInfo validateSession(SessionValidationContext context) {
        String sessionKey = context.getSessionKey();
        SessionInfo sessionInfo = this.getSessionInfo(sessionKey);
        if (!sessionInfo.isAnonymous() && !context.mustSkipLastUserAccessTimeRegistering()) {
            if (sessionInfo.isDefined()) {
                sessionInfo.updateLastAccess();
            }
            this.userNotificationSessions.remove(sessionKey);
        }
        return sessionInfo;
    }

    private void initSchedulerTimeStamp() throws SchedulerException {
        JobTrigger trigger;
        int minute = (int)this.convertMillisecondsToMinutes(this.scheduledSessionManagementTimeStamp);
        if (minute < 0 || minute > 59) {
            throw new SchedulerException("SchedulerMethodJob.setParameter: minute value is out of range");
        }
        this.scheduler.unscheduleJob(SESSION_MANAGER_JOB_NAME);
        try {
            trigger = this.computeJobTrigger(minute);
        }
        catch (ParseException ex) {
            throw new SchedulerException(ex.getMessage(), (Throwable)ex);
        }
        this.scheduler.scheduleJob(this.manageSession(), trigger);
    }

    public void closeSession(String sessionId) {
        SessionInfo si = this.getSessionInfo(sessionId);
        if (si.isDefined()) {
            if (si.isAnonymous()) {
                this.anonymousSessions.remove(sessionId);
            } else {
                this.removeUserSession(si);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUserSession(SessionInfo si) {
        try {
            Date now = new Date();
            long duration = now.getTime() - si.getOpeningTimestamp();
            Object object = this.mutex;
            synchronized (object) {
                this.myStatisticsManager.addStatConnection(si.getUserDetail().getId(), now, 1, duration);
                this.removeInQueueMessages(si.getUserDetail().getId(), si.getSessionId());
                VolatileResourceCacheService.clearFrom((SessionInfo)si);
                UploadSession.clearFrom((SessionInfo)si);
                this.userDataSessions.remove(si.getSessionId());
                this.userNotificationSessions.remove(si.getSessionId());
                si.onClosed();
            }
            this.defaultServerEventNotifier.notify((AbstractServerEvent)UserSessionServerEvent.aClosingOneFor(si));
            this.userSessionNotifier.fire((Object)new UserSessionEvent(si));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public SessionInfo getSessionInfo(String sessionId) {
        SessionInfo session = (SessionInfo)this.userDataSessions.get(sessionId);
        if (session == null) {
            session = User.getCurrentRequester() != null && User.getCurrentRequester().isAnonymous() ? this.anonymousSessions.getOrDefault(sessionId, SessionInfo.NoneSession) : SessionInfo.NoneSession;
        }
        return session;
    }

    private void removeInQueueMessages(String userId, String sessionId) {
        if (StringUtil.isDefined((String)sessionId)) {
            ServerMessageService.get().deleteAll(userId, sessionId);
        }
        PopupMessageService.get().deleteAll(userId);
    }

    public Collection<SessionInfo> getConnectedUsersList() {
        return this.userDataSessions.values();
    }

    public Collection<SessionInfo> getDistinctConnectedUsersList(User user) {
        HashMap<String, SessionInfo> distinctConnectedUsersList = new HashMap<String, SessionInfo>();
        Collection<SessionInfo> sessionsInfos = this.getConnectedUsersList();
        for (SessionInfo si : sessionsInfos) {
            UserDetail sessionUser = si.getUserDetail();
            String key = sessionUser.getLogin() + sessionUser.getDomainId();
            if (distinctConnectedUsersList.containsKey(key) || sessionUser.isAccessGuest()) continue;
            this.addInConnectedUsersList(user, distinctConnectedUsersList, si, (User)sessionUser, key);
        }
        return distinctConnectedUsersList.values();
    }

    private void addInConnectedUsersList(User user, Map<String, SessionInfo> distinctConnectedUsersList, SessionInfo si, User sessionUser, String key) {
        if (DomainProperties.areDomainsVisibleToAll()) {
            distinctConnectedUsersList.put(key, si);
        } else if (DomainProperties.areDomainsNonVisibleToOthers()) {
            if (user.getDomainId().equalsIgnoreCase(sessionUser.getDomainId())) {
                distinctConnectedUsersList.put(key, si);
            }
        } else if (DomainProperties.areDomainsVisibleOnlyToDefaultOne()) {
            if ("0".equals(user.getDomainId())) {
                distinctConnectedUsersList.put(key, si);
            } else if (user.getDomainId().equalsIgnoreCase(sessionUser.getDomainId())) {
                distinctConnectedUsersList.put(key, si);
            }
        }
    }

    public int getNbConnectedUsersList(User user) {
        return this.getDistinctConnectedUsersList(user).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSessionManagement(Date currentDate) {
        try {
            long currentTime = currentDate.getTime();
            Collection allSI = this.userDataSessions.values();
            ArrayList<SessionInfo> expiredSessions = new ArrayList<SessionInfo>(allSI.size());
            for (SessionInfo si : allSI) {
                long userSessionTimeoutMillis;
                UserDetail userDetail = si.getUserDetail();
                long l = userSessionTimeoutMillis = userDetail.isAccessAdmin() ? this.adminSessionTimeout : this.userSessionTimeout;
                if (currentTime - si.getLastAccessTimestamp() < userSessionTimeoutMillis) continue;
                if (si instanceof HTTPSessionInfo) {
                    Object object = this.mutex;
                    synchronized (object) {
                        this.performUserSessionExpiration(si, currentTime, expiredSessions);
                        continue;
                    }
                }
                expiredSessions.add(si);
            }
            for (SessionInfo expiredSession : expiredSessions) {
                this.removeUserSession(expiredSession);
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUserSessionExpiration(SessionInfo si, long currentTime, List<SessionInfo> expiredSessions) {
        long duration = si.getLastIdleDuration();
        if (duration < this.maxRefreshInterval && !this.userNotificationSessions.contains(si.getSessionId())) {
            try {
                this.notifyEndOfSession(si.getUserDetail().getId(), currentTime + this.scheduledSessionManagementTimeStamp, si.getSessionId());
            }
            catch (NotificationException ex) {
                SilverLogger.getLogger((Object)this).error("Unable to notify on the session expiration for user {0}", (Object[])new String[]{this.log(si)}, (Throwable)ex);
            }
            finally {
                this.userNotificationSessions.add(si.getSessionId());
            }
        } else {
            expiredSessions.add(si);
        }
    }

    private void notifyEndOfSession(String userId, long endOfSession, String sessionId) throws NotificationException {
        UserDetail user = UserDetail.getById((String)userId);
        String userLanguage = DisplayI18NHelper.getDefaultLanguage();
        if (user != null) {
            userLanguage = user.getUserPreferences().getLanguage();
        }
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.peasCore.multilang.peasCoreBundle", (String)userLanguage);
        String endOfSessionDate = DateUtil.formatDate((Date)new Date(endOfSession), (String)NOTIFY_DATE_FORMAT);
        Object msgTitle = bundle.getString("EndOfSessionNotificationMsgTitle");
        msgTitle = (String)msgTitle + endOfSessionDate;
        NotificationSender notifSender = new NotificationSender(null);
        NotificationMetaData notifMetaData = new NotificationMetaData(0, (String)msgTitle, bundle.getString("EndOfSessionNotificationMsgText"));
        notifMetaData.setSessionId(sessionId);
        notifMetaData.addUserRecipient(new UserRecipient(userId));
        notifMetaData.setSender(bundle.getString("administrator"));
        notifSender.notifyUser(BuiltInNotifAddress.BASIC_POPUP.getId(), notifMetaData);
    }

    public void shutdown() {
        try {
            this.scheduler.unscheduleJob(SESSION_MANAGER_JOB_NAME);
        }
        catch (SchedulerException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        ArrayList allSI = new ArrayList(this.userDataSessions.values());
        for (SessionInfo si : allSI) {
            this.removeUserSession(si);
        }
    }

    private JobTrigger computeJobTrigger(int minute) throws ParseException {
        StringBuilder cronBuilder = new StringBuilder();
        if (60 % minute == 0) {
            cronBuilder.append("0");
        }
        for (int i = minute; i < 60; i += minute) {
            cronBuilder.append(",").append(i);
        }
        cronBuilder.append(" * * * ?");
        JobTrigger trigger = cronBuilder.toString().startsWith(",") ? JobTrigger.triggerAt((String)cronBuilder.substring(1)) : JobTrigger.triggerAt((String)cronBuilder.toString());
        return trigger;
    }

    private Job manageSession() {
        return new Job(SESSION_MANAGER_JOB_NAME){

            public void execute(JobExecutionContext context) {
                Date date = context.getFireTime();
                SessionManager.this.doSessionManagement(date);
            }
        };
    }

    public SessionInfo openSession(User user, HttpServletRequest request) {
        SessionInfo si = this.createUserSessionInfo(user, request, false);
        try {
            this.registerSession(si);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return si;
    }

    public SessionInfo openOneShotSession(User user, HttpServletRequest request) {
        return this.createUserSessionInfo(user, request, true);
    }

    public SessionInfo openAnonymousSession(HttpServletRequest request) {
        SessionInfo sessionInfo = this.createAnonymousSession(request);
        if (!sessionInfo.isDefined()) {
            throw new SilverpeasRuntimeException("No Anonymous Session was configured!");
        }
        CacheAccessorProvider.getSessionCacheAccessor().setCurrentSessionCache(sessionInfo.getCache());
        this.anonymousSessions.put(sessionInfo.getId(), sessionInfo);
        return sessionInfo;
    }

    private void registerSession(SessionInfo sessionInfo) {
        if (!sessionInfo.isAnonymous()) {
            this.userDataSessions.put(sessionInfo.getSessionId(), sessionInfo);
            this.defaultServerEventNotifier.notify((AbstractServerEvent)UserSessionServerEvent.anOpeningOneFor(sessionInfo));
        }
    }

    @Nonnull
    private SessionInfo createUserSessionInfo(User user, HttpServletRequest request, boolean isOneShot) {
        String anIP;
        if (user.isAnonymous()) {
            throw new IllegalArgumentException("Connection with anonymous access is invoked here!");
        }
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        String requestRemoteHost = request.getRemoteHost();
        try {
            anIP = InetAddress.getByName(StringUtil.defaultStringIfNotDefined((String)xForwardedFor, (String)requestRemoteHost)).getHostAddress();
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).debug(ex.getMessage(), new Object[]{ex});
            anIP = requestRemoteHost;
        }
        if (isOneShot) {
            return new OneShotSessionInfo(anIP, user);
        }
        HttpSession session = request.getSession();
        return new HTTPSessionInfo(session, anIP, user);
    }

    @Nonnull
    private SessionInfo createAnonymousSession(HttpServletRequest request) {
        return Optional.ofNullable(UserDetail.getAnonymousUser()).map(a2 -> {
            HttpSession session = request.getSession();
            return new HTTPSessionInfo(session, request.getRemoteHost(), (User)a2);
        }).map(SessionInfo.class::cast).orElse(SessionInfo.NoneSession);
    }

    public boolean isUserConnected(User user) {
        String userId = user.getId();
        for (SessionInfo session : this.userDataSessions.values()) {
            if (!userId.equals(session.getUserDetail().getId())) continue;
            return true;
        }
        return false;
    }

    private long convertMinuteInMilliseconds(long minutes) {
        return minutes * 60000L;
    }

    private long convertMillisecondsToMinutes(long milliseconds) {
        return milliseconds / 60000L;
    }

    private String log(SessionInfo sessionInfo) {
        return sessionInfo.getUserDetail().getLogin() + " (" + sessionInfo.getUserDetail().getDomainId() + ")";
    }
}

