/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.web.http.RestFileResponse;
import org.silverpeas.core.web.http.ServletFileResponse;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class FileResponse {
    private static final int MAX_PATH_LENGTH_IN_LOGS = 100;
    private static final int BUFFER_LENGTH = 16384;
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(?<start>\\d*)-(?<end>\\d*)");
    private static final long EXPIRE_TIME = 86400000L;
    final HttpServletResponse response;
    private final HttpServletRequest request;
    String forcedMimeType;
    private String forcedCharacterEncoding;
    private String forcedFileName;
    private boolean noCache = false;
    private String forcedFileId;

    FileResponse(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        response.setHeader("Content-Security-Policy", "default-src 'none'; img-src 'self'; style-src 'none'; script-src 'none'");
    }

    public static String encodeInlineFilenameAsUtf8(String filename) {
        String normalized = StringUtil.normalize((String)filename);
        normalized = URLUtil.encodeURL((String)normalized).replace("+", "%20");
        return String.format("inline; filename*=UTF-8''%s", normalized);
    }

    public static String encodeAttachmentFilenameAsUtf8(String filename) {
        String normalized = StringUtil.normalize((String)filename);
        normalized = URLUtil.encodeURL((String)normalized).replace("+", "%20");
        return String.format("attachment; filename*=UTF-8''%s", normalized);
    }

    public static RestFileResponse fromRest(HttpServletRequest request, HttpServletResponse response) {
        return new RestFileResponse(request, response);
    }

    public static ServletFileResponse fromServlet(HttpServletRequest request, HttpServletResponse response) {
        return new ServletFileResponse(request, response);
    }

    String getMimeType(Path absoluteFilePath) {
        String mediaMimeType = this.request.getParameter("forceMimeType");
        if (StringUtil.isNotDefined((String)mediaMimeType)) {
            mediaMimeType = StringUtil.isDefined((String)this.forcedMimeType) ? this.forcedMimeType : FileUtil.getMimeType((String)absoluteFilePath.toString());
        }
        return mediaMimeType;
    }

    String getFileName(Path absoluteFilePath) {
        String fileName = this.request.getParameter("forceFileName");
        if (StringUtil.isNotDefined((String)fileName)) {
            fileName = StringUtil.isDefined((String)this.forcedFileName) ? this.forcedFileName : absoluteFilePath.getFileName().toString();
        }
        return fileName;
    }

    public FileResponse forceFileId(String fileId) {
        this.forcedFileId = fileId;
        return this;
    }

    public FileResponse forceFileName(String fileName) {
        this.forcedFileName = fileName;
        return this;
    }

    public FileResponse forceMimeType(String mimeType) {
        this.forcedMimeType = mimeType;
        return this;
    }

    public FileResponse forceCharacterEncoding(String forcedCharacterEncoding) {
        this.forcedCharacterEncoding = forcedCharacterEncoding;
        return this;
    }

    public FileResponse noCache() {
        this.noCache = true;
        return this;
    }

    void partialOutputStream(Path path, ContentRangeData partialData, OutputStream output) {
        SilverLogger.getLogger((Object)this).debug("{0} - start at {1} - end at {2} - partLength {3}", new Object[]{StringUtil.abbreviate((String)path.toString(), (int)path.toString().length(), (int)100), partialData.start, partialData.end, partialData.partContentLength});
        try (SeekableByteChannel input2 = Files.newByteChannel(path, StandardOpenOption.READ);){
            int bytesRead;
            input2.position(partialData.start);
            ByteBuffer buffer = ByteBuffer.allocate(16384);
            for (int bytesLeft = partialData.partContentLength; (bytesRead = input2.read(buffer)) != -1 && bytesLeft > 0; bytesLeft -= bytesRead) {
                buffer.clear();
                output.write(buffer.array(), 0, Math.min(bytesLeft, bytesRead));
            }
            SilverLogger.getLogger((Object)this).debug("{0} - all part content bytes sent", new Object[]{StringUtil.abbreviate((String)path.toString(), (int)path.toString().length(), (int)100)});
        }
        catch (IOException ioe) {
            SilverLogger.getLogger((Object)this).debug("client stopping the streaming HTTP Request of file content represented by ''{0}'' identifier (original message ''{1}'')", new Object[]{StringUtil.abbreviate((String)path.toString(), (int)path.toString().length(), (int)100), ioe.getMessage(), ioe});
        }
    }

    void fullOutputStream(Path path, OutputStream output) {
        if (this.noCache) {
            this.response.setHeader("Cache-Control", "no-store");
            this.response.setHeader("Pragma", "no-cache");
            this.response.setDateHeader("Expires", -1L);
        }
        if (StringUtil.isDefined((String)this.forcedCharacterEncoding)) {
            this.response.setCharacterEncoding(this.forcedCharacterEncoding);
        }
        try (FileInputStream stream = FileUtils.openInputStream((File)path.toFile());){
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    String getFileIdentifier(Path path) throws IOException {
        if (StringUtil.isDefined((String)this.forcedFileId)) {
            return this.forcedFileId;
        }
        File file = path.toFile();
        String sb = FileUtils.checksumCRC32((File)file) + "|" + file.getName() + "|" + file.length() + "|" + file.lastModified();
        return Base64.getEncoder().encodeToString(sb.getBytes());
    }

    Date getExpirationDate() {
        return Date.from(Instant.ofEpochMilli(System.currentTimeMillis() + 86400000L));
    }

    Date getLastModifiedDate(Path path) throws IOException {
        return Date.from(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
    }

    Matcher getPartialMatcher() {
        String range = StringUtil.defaultStringIfNotDefined((String)this.request.getHeader("Range"), (String)"");
        return RANGE_PATTERN.matcher(range);
    }

    ContentRangeData getContentRangeData(Matcher partialHeaders, int fullContentLength) {
        int endOfFullContent = fullContentLength - 1;
        this.response.setBufferSize(16384);
        String startGroup = partialHeaders.group("start");
        int start = startGroup.isEmpty() ? 0 : Integer.parseInt(startGroup);
        start = Math.max(start, 0);
        String endGroup = partialHeaders.group("end");
        int end = endGroup.isEmpty() ? endOfFullContent : Integer.parseInt(endGroup);
        end = Math.min(end, endOfFullContent);
        int partContentLength = end - start + 1;
        return new ContentRangeData(start, end, partContentLength, String.format("bytes %s-%s/%s", start, end, fullContentLength));
    }

    static class ContentRangeData {
        final int start;
        final int end;
        final int partContentLength;
        final String headerValue;

        ContentRangeData(int start, int end, int partContentLength, String headerValue) {
            this.start = start;
            this.end = end;
            this.partContentLength = partContentLength;
            this.headerValue = headerValue;
        }
    }
}

