/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.glossary;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.web.glossary.TermComparator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class HighlightGlossaryTerms {
    @Inject
    private PdcManager pdc;

    protected HighlightGlossaryTerms() {
    }

    public String searchReplace(String publicationContent, String className, String axisId, boolean onlyFirst, String language) {
        String replacedContent = publicationContent;
        List glossary = null;
        try {
            Axis axis = this.pdc.getAxisDetail(axisId);
            if (axis != null) {
                glossary = axis.getValues();
                Collections.sort(glossary, new TermComparator());
            }
        }
        catch (PdcException pdcEx) {
            SilverLogger.getLogger((Object)this).warn((Throwable)pdcEx);
        }
        if (CollectionUtil.isNotEmpty(glossary)) {
            for (Value node : glossary) {
                String desc = node.getDescription(language);
                if (!StringUtil.isDefined((String)desc)) continue;
                replacedContent = this.highlight(node.getName(language), replacedContent, desc, className, onlyFirst);
            }
        }
        return replacedContent;
    }

    private String highlight(String term, String content, String definition, String className, boolean onlyFirst) {
        String escapedTerm = WebEncodeHelper.convertHTMLEntities((String)term).replace("'", "&#39;");
        String groupName = "realTerm";
        Pattern pattern = Pattern.compile("(?i)(?<realTerm>\\b" + escapedTerm + "\\b)(?=[^>]*<(?!/a))");
        String template = "<span class=\"" + className + "\" title=\"" + definition.replace("\"", "&quot;").replace("'", "''") + "\">{0}</span>";
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(content);
        int lastBeginIndex = 0;
        while (matcher.find()) {
            sb.append(content.substring(lastBeginIndex, matcher.start(groupName)));
            String realTerm = matcher.group(groupName);
            sb.append(MessageFormat.format(template, realTerm));
            lastBeginIndex = matcher.end(groupName);
            if (!onlyFirst) continue;
            break;
        }
        sb.append(content.substring(lastBeginIndex));
        return sb.toString();
    }
}

