/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.encryption.cipher.CryptMD5;
import org.silverpeas.core.web.authentication.SilverpeasSessionOpener;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ValidationQuestionHandler
extends CredentialsFunctionHandler {
    @Inject
    private SilverpeasSessionOpener sessionOpenener;

    @Override
    public String getFunction() {
        return "ValidateQuestion";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String key = (String)session.getAttribute("svplogin_Key");
        boolean answerCrypted = this.getAuthenticationSettings().getBoolean("loginAnswerEncrypted", false);
        try {
            String userId = this.getAdminService().identify(key, session.getId(), false, false);
            UserDetail userDetail = this.getAdminService().getUserDetail(userId);
            String question = request.getParameter("question");
            String answer = request.getParameter("answer");
            userDetail.setLoginQuestion(question);
            if (answerCrypted) {
                answer = CryptMD5.encrypt((String)answer);
            }
            userDetail.setLoginAnswer(answer);
            this.getAdminService().updateUser(userDetail);
            if (this.getGeneral().getBoolean("userLoginForcePasswordChange", false)) {
                request.setAttribute("userLanguage", (Object)userDetail.getUserPreferences().getLanguage());
                return this.getGeneral().getString("userLoginForcePasswordChangePage");
            }
            return this.sessionOpenener.openSession((HttpRequest)request, key);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return "/Login?ErrorCode=2";
        }
    }
}

