/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class Consistency {
    private final DocumentNodeState root;
    private final NodeDocument document;

    public Consistency(@NotNull DocumentNodeState root, @NotNull NodeDocument document) {
        this.root = Objects.requireNonNull(root);
        this.document = Objects.requireNonNull(document);
    }

    public void check(@NotNull DocumentNodeStore ns, @NotNull Result collector) {
        Objects.requireNonNull(ns);
        Objects.requireNonNull(collector);
        DocumentNodeState traversedState = this.root;
        DocumentNodeState existingAncestorOrSelf = this.root;
        for (String name : this.document.getPath().elements()) {
            if (!((traversedState = traversedState.getChildNode(name)) instanceof DocumentNodeState)) continue;
            existingAncestorOrSelf = traversedState;
        }
        DocumentNodeState dns = this.document.getNodeAtRevision(ns, this.root.getRootRevision(), null);
        if (traversedState.exists()) {
            if (dns != null) {
                if (!Consistency.equalProperties((NodeState)dns, (NodeState)traversedState)) {
                    this.identifyChanges(ns, (NodeState)traversedState, collector);
                }
            } else {
                this.identifyChanges(ns, (NodeState)traversedState, collector);
            }
        } else if (dns != null) {
            this.identifyChanges(ns, (NodeState)existingAncestorOrSelf, collector);
        }
    }

    private static boolean equalProperties(NodeState a, NodeState b) {
        if (a.getPropertyCount() != b.getPropertyCount()) {
            return false;
        }
        for (PropertyState property : a.getProperties()) {
            if (property.equals(b.getProperty(property.getName()))) continue;
            return false;
        }
        return true;
    }

    private void identifyChanges(@NotNull RevisionContext context, @NotNull NodeState state, @NotNull Result result) {
        if (state instanceof DocumentNodeState) {
            DocumentNodeState traversedState = (DocumentNodeState)state;
            RevisionVector lastRevision = traversedState.getLastRevision();
            RevisionVector rootRevision = traversedState.getRootRevision();
            for (Revision r : this.document.getLocalCommitRoot().keySet()) {
                if (rootRevision.isRevisionNewer(r) || !lastRevision.isRevisionNewer(r) || !Utils.isCommitted(context.getCommitValue(r, this.document))) continue;
                result.inconsistent(r);
            }
        }
    }

    public static interface Result {
        public void inconsistent(Revision var1);
    }
}

