/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.silverpeas.kernel.SilverpeasResourcesLocation;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.bundle.ConfigurationClassLoader;
import org.silverpeas.kernel.bundle.ConfigurationControl;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.bundle.XmlSettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class ResourceLocator {
    private static final int INITIAL_CACHE_SIZE = 128;
    private static final ClassLoader l10nLoader = new ConfigurationClassLoader(SilverpeasResourcesLocation.getInstance().getL10nBundlesRootPath(), ResourceLocator.class.getClassLoader());
    private static final ClassLoader settingsLoader = new ConfigurationClassLoader(SilverpeasResourcesLocation.getInstance().getConfigurationFilesRootPath(), ResourceLocator.class.getClassLoader());
    private static final ConfigurationControl configurationControl = new ConfigurationControl();
    private static final ConcurrentMap<String, SilverpeasBundle> bundles = new ConcurrentHashMap<String, SilverpeasBundle>(128);

    private ResourceLocator() {
    }

    public static LocalizationBundle getLocalizationBundle(String name, String locale) {
        Locale localToUse = StringUtil.isNotDefined(locale) ? Locale.ROOT : new Locale(locale);
        return ResourceLocator.getLocalizationBundle(name, localToUse);
    }

    public static LocalizationBundle getLocalizationBundle(String name, Locale locale) {
        Locale localeToUse = locale == null ? Locale.ROOT : locale;
        String key = name + (String)(localeToUse.getLanguage().isEmpty() ? "" : "_" + localeToUse.getLanguage());
        LocalizationBundle bundle = (LocalizationBundle)bundles.computeIfAbsent(key, n -> new LocalizationBundle(name, localeToUse, (bundleName, locale1) -> ResourceLocator.loadResourceBundle(bundleName, locale1, true, l10nLoader), true));
        bundle.changeLocale(localeToUse);
        return bundle;
    }

    @Nullable
    private static ResourceBundle loadResourceBundle(String bundleName, Locale locale, boolean mandatory, ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, classLoader, configurationControl);
        }
        catch (MissingResourceException mex) {
            if (mandatory) {
                throw mex;
            }
            return null;
        }
    }

    public static SettingBundle getSettingBundle(String name) {
        return (SettingBundle)bundles.computeIfAbsent(name, n -> new SettingBundle(name, nm -> ResourceLocator.loadResourceBundle(nm, Locale.ROOT, true, settingsLoader)));
    }

    public static synchronized void saveSettingBundle(SettingBundle settings, Properties properties) {
        String bundleName = "/" + settings.getBaseBundleName().replace('.', '/') + ".properties";
        try (FileOutputStream output = new FileOutputStream(new File(Objects.requireNonNull(settingsLoader.getResource(bundleName)).toURI()));){
            properties.store(output, null);
            ResourceBundle.clearCache(settingsLoader);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException(e);
        }
    }

    public static XmlSettingBundle getXmlSettingBundle(String name) {
        return (XmlSettingBundle)bundles.computeIfAbsent(name, n -> new XmlSettingBundle(name, ResourceLocator::loadSettingsResourceAsStream));
    }

    public static LocalizationBundle getGeneralLocalizationBundle(String locale) {
        return ResourceLocator.getLocalizationBundle("org.silverpeas.multilang.generalMultilang", locale);
    }

    public static LocalizationBundle getGeneralLocalizationBundle(Locale locale) {
        return ResourceLocator.getLocalizationBundle("org.silverpeas.multilang.generalMultilang", locale);
    }

    public static SettingBundle getGeneralSettingBundle() {
        return ResourceLocator.getSettingBundle("org.silverpeas.general");
    }

    public static Properties getSettingsAsProperties(String name) {
        Properties properties = new Properties();
        try {
            String bundleName = "/" + name.replace('.', '/') + ".properties";
            properties.load(ResourceLocator.loadSettingsResourceAsStream(bundleName));
        }
        catch (IOException e) {
            throw new MissingResourceException(e.getMessage(), name, "");
        }
        return properties;
    }

    public static void resetCache() {
        bundles.clear();
        ResourceBundle.clearCache();
    }

    private static InputStream loadSettingsResourceAsStream(String path) {
        InputStream inputStream = settingsLoader.getResourceAsStream(path);
        if (inputStream == null) {
            throw new MissingResourceException("Can't find bundle for base name " + path, path, "");
        }
        return inputStream;
    }

    public static Optional<SettingBundle> getOptionalSettingBundle(String name) {
        SettingBundle bundle = (SettingBundle)bundles.computeIfAbsent(name, n -> new SettingBundle(name, b -> ResourceLocator.loadResourceBundle(b, Locale.ROOT, false, settingsLoader)));
        return Optional.of(bundle).filter(SettingBundle::exists);
    }

    public static Optional<LocalizationBundle> getOptionalLocalizationBundle(String name, String locale) {
        Locale localeToUse = locale == null || locale.trim().isEmpty() ? Locale.ROOT : new Locale(locale);
        String key = name + (String)(localeToUse.getLanguage().isEmpty() ? "" : "_" + localeToUse.getLanguage());
        LocalizationBundle bundle = (LocalizationBundle)bundles.computeIfAbsent(key, n -> new LocalizationBundle(name, localeToUse, (bundleName, locale1) -> ResourceLocator.loadResourceBundle(bundleName, locale1, false, l10nLoader), false));
        return Optional.of(bundle).filter(LocalizationBundle::exists).map(b -> {
            b.changeLocale(localeToUse);
            return b;
        });
    }

    public static LocalizationBundle getLocalizationBundle(String name) {
        return ResourceLocator.getLocalizationBundle(name, Locale.ROOT);
    }
}

