/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.impl;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.ChannelURLType;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.ContainerType;
import com.sun.portal.container.ContainerUtil;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.ExecuteEventRequest;
import com.sun.portal.container.ExecuteEventResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.PortletEvent;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.PortletWindowContextAbstractFactory;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.container.PortletWindowContextFactory;
import com.sun.portal.container.WindowRequestReader;
import com.sun.portal.container.impl.AbstractContainer;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.container.service.ServiceException;
import com.sun.portal.container.service.caching.CachingService;
import com.sun.portal.container.service.caching.ClientCachingService;
import com.sun.portal.container.service.caching.PortletCacheEntry;
import com.sun.portal.container.service.caching.ResourceCacheEntry;
import com.sun.portal.container.service.coordination.ContainerEventService;
import com.sun.portal.container.service.coordination.ContainerEventSubscriber;
import com.sun.portal.container.service.coordination.CoordinationService;
import com.sun.portal.container.service.coordination.CoordinationSubscriber;
import com.sun.portal.container.service.policy.ContainerEventPolicy;
import com.sun.portal.container.service.policy.EventPolicy;
import com.sun.portal.portletcontainer.common.PortletContainerActionRequest;
import com.sun.portal.portletcontainer.common.PortletContainerActionResponse;
import com.sun.portal.portletcontainer.common.PortletContainerConstants;
import com.sun.portal.portletcontainer.common.PortletContainerErrorCode;
import com.sun.portal.portletcontainer.common.PortletContainerEventRequest;
import com.sun.portal.portletcontainer.common.PortletContainerEventResponse;
import com.sun.portal.portletcontainer.common.PortletContainerRenderRequest;
import com.sun.portal.portletcontainer.common.PortletContainerRenderResponse;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResourceResponse;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.PortletContainerUtil;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainer.impl.DispatcherState;
import com.sun.portal.portletcontainer.impl.PAERequestWrapper;
import com.sun.portal.portletcontainer.impl.PAEResponseWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainer
extends AbstractContainer
implements CoordinationSubscriber,
ContainerEventSubscriber {
    private CachingService cacheManager;
    private CoordinationService coordinationService;
    private ClientCachingService clientCachingService;
    private ServletContext servletContext;
    private boolean serializeAll;
    private static List<String> actionList;
    private static List<String> renderList;
    private static List<String> eventList;
    private static List<String> resourceList;
    private static final String PAE_NAME = "/servlet/PortletAppEngineServlet";
    private static final String DISPATCHER_STATE = "javax.portlet.pc.dispatcher_state";
    private static final String FIRST_THREAD = "javax.portlet.pc.first_thread";
    private static Logger logger;

    void init(ServletContext servletContext) {
        this.coordinationService = (CoordinationService)this.getService("com.sun.portal.container.service.CoordinationService");
        this.coordinationService.registerSubscriber(ContainerType.PORTLET_CONTAINER, (CoordinationSubscriber)this);
        this.cacheManager = (CachingService)this.getService("com.sun.portal.container.service.CachingService");
        this.clientCachingService = (ClientCachingService)this.getService("com.sun.portal.container.service.ClientCachingService");
        ContainerEventService containerEventService = (ContainerEventService)this.getService("com.sun.portal.container.service.ContainerEventService");
        containerEventService.registerSubscriber((ContainerEventSubscriber)this);
        this.servletContext = servletContext;
    }

    public void getMarkup(GetMarkupRequest getMarkUpRequest, GetMarkupResponse getMarkUpResponse) throws ContainerException, ContentException {
        Map<String, String[]> renderURLParameters;
        EntityID entityID = getMarkUpRequest.getEntityID();
        Map<String, String[]> renderParameters = this.getRenderParameters((ContainerRequest)getMarkUpRequest, entityID);
        getMarkUpRequest.setRenderParameters(renderParameters);
        String scopeID = this.getActionScopeID(renderParameters);
        if (scopeID != null) {
            Map<String, Serializable> scopedAttributes = this.getScopedAttributes((ContainerRequest)getMarkUpRequest, entityID);
            getMarkUpRequest.setScopedAttributes(scopeID, scopedAttributes);
        }
        PortletContainerRenderResponse pcRenderResponse = null;
        boolean cachingEnabled = this.getCachingService().isCachingEnabled((ContainerRequest)getMarkUpRequest);
        boolean isInViewMode = getMarkUpRequest.getChannelMode().equals((Object)ChannelMode.VIEW);
        PortletCacheEntry portletCacheEntry = null;
        if (cachingEnabled && isInViewMode) {
            if (getMarkUpRequest.getIsTarget()) {
                this.getCachingService().removeCachedPortlet((ContainerRequest)getMarkUpRequest);
            } else {
                portletCacheEntry = this.getCachingService().getCachedPortlet((ContainerRequest)getMarkUpRequest);
            }
        }
        try {
            if (portletCacheEntry == null || portletCacheEntry != null && portletCacheEntry.needsValidation()) {
                HttpServletRequest request = getMarkUpRequest.getHttpServletRequest();
                PortletContainerErrorCode errorCode = null;
                String title = this.getTitle(getMarkUpRequest, entityID);
                if (title != null) {
                    request.setAttribute("com.sun.portal.portletcontainer.portlet.registry.title." + entityID, (Object)title);
                }
                if (portletCacheEntry != null) {
                    getMarkUpRequest.setETag(portletCacheEntry.getETag());
                }
                if ((errorCode = (pcRenderResponse = (PortletContainerRenderResponse)this.invokePAE("RENDER", (ContainerRequest)getMarkUpRequest, (ContainerResponse)getMarkUpResponse)).getErrorCode()).equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                    if (cachingEnabled && isInViewMode) {
                        boolean useCachedContent;
                        int expirationCache = pcRenderResponse.getCacheControl().getExpirationTime();
                        String eTag = pcRenderResponse.getCacheControl().getETag();
                        boolean readMarkup = true;
                        if (portletCacheEntry != null && portletCacheEntry.needsValidation() && (useCachedContent = pcRenderResponse.getCacheControl().useCachedContent())) {
                            portletCacheEntry.setExpirationTime(expirationCache);
                            if (eTag != null) {
                                portletCacheEntry.setETag(eTag);
                            }
                            this.getCachingService().putCachedPortlet((ContainerRequest)getMarkUpRequest, portletCacheEntry, pcRenderResponse.getCacheControl().isPublicScope());
                            readMarkup = false;
                        }
                        if (readMarkup) {
                            int cacheType;
                            int n = cacheType = eTag != null ? 2 : 1;
                            if (expirationCache > 0 || expirationCache == -1) {
                                portletCacheEntry = new PortletCacheEntry(cacheType, pcRenderResponse.getMarkup(), pcRenderResponse.getTitle(), pcRenderResponse.getElementProperties(), pcRenderResponse.getStringProperties(), expirationCache, eTag, getMarkUpRequest.getLocale().toString());
                                this.getCachingService().putCachedPortlet((ContainerRequest)getMarkUpRequest, portletCacheEntry, pcRenderResponse.getCacheControl().isPublicScope());
                            }
                        }
                    }
                } else {
                    this.logPortletAppEngineException(entityID, pcRenderResponse.getException());
                    throw new ContentException("PortletContainer.getMarkup(): Exception thrown from render() of " + entityID, (ErrorCode)errorCode, (Throwable)pcRenderResponse.getException());
                }
            }
            if (portletCacheEntry != null) {
                getMarkUpResponse.setMarkup(portletCacheEntry.getCachedContent());
                getMarkUpResponse.setTitle(portletCacheEntry.getTitleResource());
                getMarkUpResponse.setElementProperties(portletCacheEntry.getElementProperties());
                getMarkUpResponse.setStringProperties(portletCacheEntry.getStringProperties());
            }
        }
        catch (ContentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.getMarkup(): ", (Throwable)e);
        }
        if (this.renderURLParameterCacheDisabled(entityID) && (renderURLParameters = this.getRenderURLParameters((ContainerRequest)getMarkUpRequest, entityID)) != null && !renderURLParameters.isEmpty()) {
            Set<String> keys = renderURLParameters.keySet();
            for (String key : keys) {
                renderParameters.remove(key);
            }
            this.setRenderParameters((ContainerRequest)getMarkUpRequest, entityID, renderParameters);
        }
    }

    public void executeAction(ExecuteActionRequest executeActionRequest, ExecuteActionResponse executeActionResponse, ChannelURLType channelURLType) throws ContainerException, ContentException {
        EntityID entityID = executeActionRequest.getEntityID();
        PortletContainerActionResponse pcActionResponse = null;
        this.getCachingService().removeCachedPortlet((ContainerRequest)executeActionRequest);
        if (ChannelURLType.RENDER.equals((Object)channelURLType)) {
            Map urlParameters = null;
            WindowRequestReader windowRequestReader = executeActionRequest.getWindowRequestReader();
            if (windowRequestReader != null) {
                urlParameters = windowRequestReader.readParameterMap(executeActionRequest.getHttpServletRequest());
            }
            if (urlParameters != null) {
                if (this.renderURLParameterCacheDisabled(entityID)) {
                    this.setRenderURLParameters((ContainerRequest)executeActionRequest, entityID, urlParameters);
                }
                executeActionResponse.setDeletedRenderParameters(this.getDeletedParameters(urlParameters));
                Map<String, String[]> publicParametersMap = this.getPublicParameters(executeActionRequest, executeActionRequest.getEntityID());
                Map<String, String[]> renderParameters = PortletContainerUtil.getMergedParameterMap(urlParameters, publicParametersMap, false);
                this.getCoordinationService().setRenderParameters((ContainerRequest)executeActionRequest, (ContainerResponse)executeActionResponse, entityID, renderParameters);
            }
            this.setIsTarget((ContainerRequest)executeActionRequest, entityID, true);
        } else if (ChannelURLType.ACTION.equals((Object)channelURLType)) {
            WindowRequestReader windowRequestReader;
            Map actionParameters = executeActionRequest.getActionParameters();
            if (actionParameters == null && (windowRequestReader = executeActionRequest.getWindowRequestReader()) != null) {
                actionParameters = windowRequestReader.readParameterMap(executeActionRequest.getHttpServletRequest());
            }
            List<String> deletedRenderParameters = this.getDeletedParameters(actionParameters);
            executeActionResponse.setDeletedRenderParameters(deletedRenderParameters);
            Map<String, String[]> publicParameters = this.getPublicParameters(executeActionRequest, entityID);
            Map<String, String[]> mergedParameters = PortletContainerUtil.getMergedParameterMap(actionParameters, publicParameters, true);
            if (deletedRenderParameters != null) {
                for (String deletedRenderParameter : deletedRenderParameters) {
                    mergedParameters.remove(deletedRenderParameter);
                }
            }
            executeActionRequest.setActionParameters(mergedParameters);
            try {
                pcActionResponse = (PortletContainerActionResponse)this.invokePAE("ACTION", (ContainerRequest)executeActionRequest, (ContainerResponse)executeActionResponse);
                PortletContainerErrorCode errorCode = pcActionResponse.getErrorCode();
                if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                    this.logPortletAppEngineException(entityID, pcActionResponse.getException());
                    throw new ContentException("PortletContainer.executeAction(): Exception thrown from processAction() of " + entityID, (ErrorCode)errorCode, (Throwable)pcActionResponse.getException());
                }
                String scopeID = this.getActionScopeID(executeActionResponse.getRenderParameters());
                if (scopeID != null) {
                    this.setScopedAttributes((ContainerRequest)executeActionRequest, entityID, executeActionRequest.getScopedAttributes(scopeID));
                }
                Queue eventQueue = executeActionResponse.getEventQueue();
                List updatedPortlets = this.getCoordinationService().publishEvent((ContainerRequest)executeActionRequest, (ContainerResponse)executeActionResponse, eventQueue);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "PSPL_PCCSPCPCI0013", updatedPortlets);
                }
                executeActionResponse.setEventUpdatedPortlets(updatedPortlets);
                if (executeActionResponse.getRedirectURL() == null) {
                    Map renderParametersFromAction = executeActionResponse.getRenderParameters();
                    Map<String, Object> renderParameters = null;
                    if (eventQueue != null && updatedPortlets.contains(entityID)) {
                        Map<String, String[]> renderParametersFromEvent = this.getRenderParameters((ContainerRequest)executeActionRequest, executeActionRequest.getEntityID());
                        renderParameters = renderParametersFromEvent.isEmpty() ? null : renderParametersFromEvent;
                    } else {
                        Map<String, String[]> publicParametersMap = this.getPublicParameters(executeActionRequest, executeActionRequest.getEntityID());
                        renderParameters = PortletContainerUtil.getMergedParameterMap(renderParametersFromAction, publicParametersMap, false);
                    }
                    this.getCoordinationService().setRenderParameters((ContainerRequest)executeActionRequest, (ContainerResponse)executeActionResponse, entityID, renderParameters);
                }
            }
            catch (ContentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContainerException("PortletContainer.executeAction(): ", (Throwable)e);
            }
        }
    }

    public void getResources(GetResourceRequest getResourceRequest, GetResourceResponse getResourceResponse) throws ContainerException, ContentException {
        block15: {
            String cacheLevel;
            EntityID entityID = getResourceRequest.getEntityID();
            PortletContainerResourceResponse pcResourceResponse = null;
            boolean cachingEnabled = this.getCachingService().isCachingEnabled((ContainerRequest)getResourceRequest);
            boolean isInViewMode = getResourceRequest.getChannelMode().equals((Object)ChannelMode.VIEW);
            HttpServletRequest request = getResourceRequest.getHttpServletRequest();
            WindowRequestReader windowRequestReader = getResourceRequest.getWindowRequestReader();
            Map resourceParameters = getResourceRequest.getResourceParameters();
            if (resourceParameters == null && windowRequestReader != null) {
                resourceParameters = windowRequestReader.readParameterMap(request);
            }
            Map<String, String[]> publicParameters = this.getRenderParameters((ContainerRequest)getResourceRequest, entityID);
            Map<String, String[]> mergedParameters = PortletContainerUtil.getMergedParameterMap(resourceParameters, publicParameters, true);
            getResourceRequest.setResourceParameters(mergedParameters);
            String resourceID = getResourceRequest.getResourceID();
            if (resourceID == null && windowRequestReader != null) {
                getResourceRequest.setResourceID(windowRequestReader.getResourceID(request));
            }
            if ((cacheLevel = getResourceRequest.getCacheLevel()) == null && windowRequestReader != null) {
                getResourceRequest.setCacheLevel(windowRequestReader.getCacheLevel(request));
            }
            ResourceCacheEntry resourceCacheEntry = null;
            boolean needsValidation = false;
            if (cachingEnabled && isInViewMode) {
                boolean hasCacheExpired = this.getClientCachingService().hasResourceCacheExpired((ContainerRequest)getResourceRequest, (ContainerResponse)getResourceResponse);
                if (!hasCacheExpired) {
                    return;
                }
                resourceCacheEntry = this.getClientCachingService().getCachedResource((ContainerRequest)getResourceRequest);
                if (resourceCacheEntry != null) {
                    needsValidation = true;
                }
            }
            try {
                Map currentResourceParameters;
                String scopeID;
                if (resourceCacheEntry != null && !needsValidation) break block15;
                PortletContainerErrorCode errorCode = null;
                if (needsValidation) {
                    getResourceRequest.setETag(resourceCacheEntry.getETag());
                }
                if ((scopeID = this.getActionScopeID(currentResourceParameters = getResourceRequest.getResourceParameters())) != null) {
                    Map<String, Serializable> scopedAttributes = this.getScopedAttributes((ContainerRequest)getResourceRequest, entityID);
                    getResourceRequest.setScopedAttributes(scopeID, scopedAttributes);
                }
                if ((errorCode = (pcResourceResponse = (PortletContainerResourceResponse)this.invokePAE("RESOURCE", (ContainerRequest)getResourceRequest, (ContainerResponse)getResourceResponse)).getErrorCode()).equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                    if (cachingEnabled && isInViewMode) {
                        boolean useCachedContent;
                        int expirationTime = pcResourceResponse.getCacheControl().getExpirationTime();
                        String eTag = pcResourceResponse.getCacheControl().getETag();
                        boolean isPublic = pcResourceResponse.getCacheControl().isPublicScope();
                        if (needsValidation && (useCachedContent = pcResourceResponse.getCacheControl().useCachedContent())) {
                            resourceCacheEntry.setETag(eTag);
                            resourceCacheEntry.setExpirationTime(expirationTime);
                            this.getClientCachingService().updateAndReuseResourceCache((ContainerRequest)getResourceRequest, (ContainerResponse)getResourceResponse, resourceCacheEntry, isPublic);
                            return;
                        }
                        if (expirationTime > 0 || expirationTime == -1) {
                            resourceCacheEntry = new ResourceCacheEntry(expirationTime, eTag);
                            this.getClientCachingService().updateResourceCache((ContainerRequest)getResourceRequest, (ContainerResponse)getResourceResponse, resourceCacheEntry, isPublic);
                        }
                    }
                    break block15;
                }
                this.logPortletAppEngineException(entityID, pcResourceResponse.getException());
                throw new ContentException("PortletContainer.getResource(): Exception thrown from serveResource() of " + entityID, (ErrorCode)errorCode, (Throwable)pcResourceResponse.getException());
            }
            catch (ContentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContainerException("PortletContainer.getResource(): ", (Throwable)e);
            }
        }
    }

    public Queue<PortletEvent> processEvent(ContainerRequest containerRequest, ContainerResponse containerResponse, Map<EntityID, QName> portletsProcessingEventQNames, PortletEvent event) throws ContainerException, ContentException {
        EntityID publishingPortletEntityId = containerRequest.getEntityID();
        Map publishingRenderParameters = null;
        publishingRenderParameters = containerResponse instanceof ExecuteActionResponse ? ((ExecuteActionResponse)containerResponse).getRenderParameters() : (containerResponse instanceof ExecuteEventResponse ? ((ExecuteEventResponse)containerResponse).getRenderParameters() : Collections.emptyMap());
        Set<Map.Entry<EntityID, QName>> entrySet = portletsProcessingEventQNames.entrySet();
        ConcurrentLinkedQueue<PortletEvent> nextEventQueue = null;
        HashMap<EntityID, ChannelState> eventUpdatedPortletsState = null;
        if (containerResponse instanceof ExecuteActionResponse) {
            eventUpdatedPortletsState = ((ExecuteActionResponse)containerResponse).getEventUpdatedPortletsState();
        }
        if (eventUpdatedPortletsState == null) {
            eventUpdatedPortletsState = new HashMap<EntityID, ChannelState>();
        }
        for (Map.Entry<EntityID, QName> entry : entrySet) {
            Queue eventQueue;
            Map<String, String[]> currentRenderParameters;
            EntityID portletEntityId = entry.getKey();
            ExecuteEventRequest executeEventRequest = this.createExecuteEventRequest(containerRequest);
            ExecuteEventResponse executeEventResponse = this.createExecuteEventResponse(containerResponse);
            executeEventRequest.setEntityID(portletEntityId);
            executeEventRequest.setNamespace(this.getNamespace((ContainerRequest)executeEventRequest, portletEntityId));
            executeEventRequest.setWindowID(this.getWindowID((ContainerRequest)executeEventRequest, portletEntityId));
            executeEventRequest.setChannelMode(ChannelMode.VIEW);
            executeEventRequest.setWindowState(ChannelState.NORMAL);
            event.setQName(entry.getValue());
            executeEventResponse.setCurrentEvent(event);
            if (portletEntityId.getPortletID() == null) continue;
            if (portletEntityId.equals((Object)publishingPortletEntityId)) {
                currentRenderParameters = this.getRenderParameters(containerRequest, portletEntityId);
                currentRenderParameters.putAll(publishingRenderParameters);
                executeEventRequest.setEventParameters(currentRenderParameters);
            } else {
                currentRenderParameters = this.getRenderParameters(containerRequest, portletEntityId);
                this.removeActionScopeID(currentRenderParameters);
                executeEventRequest.setEventParameters(currentRenderParameters);
            }
            this.executeEvent(executeEventRequest, executeEventResponse);
            eventUpdatedPortletsState.put(portletEntityId, executeEventResponse.getNewWindowState());
            if (containerResponse instanceof ExecuteActionResponse) {
                ((ExecuteActionResponse)containerResponse).setEventUpdatedPortletsState(eventUpdatedPortletsState);
            }
            if (nextEventQueue == null) {
                nextEventQueue = new ConcurrentLinkedQueue<PortletEvent>();
            }
            if ((eventQueue = executeEventResponse.getEventQueue()) == null) continue;
            for (PortletEvent eventNext : eventQueue) {
                nextEventQueue.add(eventNext);
            }
        }
        return nextEventQueue;
    }

    public void processRenderParameters(ContainerRequest containerRequest, ContainerResponse containerResponse, EntityID portletEntityId, Map<String, String[]> currentRenderParameters, boolean publicRenderParameter) {
        if (currentRenderParameters != null) {
            Map<String, String[]> tempRenderParameters;
            if (publicRenderParameter) {
                Map<String, String[]> previousRenderParameters = this.getRenderParameters(containerRequest, portletEntityId);
                previousRenderParameters.putAll(currentRenderParameters);
                tempRenderParameters = previousRenderParameters;
            } else {
                tempRenderParameters = currentRenderParameters;
                List supportedPublicRenderParameterHolders = containerRequest.getPortletWindowContext().getSupportedPublicRenderParameterHolders(portletEntityId, currentRenderParameters);
                if (supportedPublicRenderParameterHolders != null) {
                    Map<String, String[]> previousRenderParameters = this.getRenderParameters(containerRequest, portletEntityId);
                    ArrayList<String> supportedPublicRenderParameters = new ArrayList<String>(supportedPublicRenderParameterHolders.size());
                    for (PublicRenderParameterHolder supportedPublicRenderParameterHolder : supportedPublicRenderParameterHolders) {
                        supportedPublicRenderParameters.add(supportedPublicRenderParameterHolder.getIdentifier());
                    }
                    Set<Map.Entry<String, String[]>> entrySet = previousRenderParameters.entrySet();
                    for (Map.Entry<String, String[]> entry : entrySet) {
                        String supportedPublicRenderParameter = entry.getKey();
                        if (!supportedPublicRenderParameters.contains(supportedPublicRenderParameter)) continue;
                        tempRenderParameters.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            ArrayList<String> deletedRenderParameters = null;
            if (containerResponse instanceof ExecuteActionResponse) {
                deletedRenderParameters = ((ExecuteActionResponse)containerResponse).getDeletedRenderParameters();
            } else if (containerResponse instanceof ExecuteEventResponse) {
                deletedRenderParameters = ((ExecuteEventResponse)containerResponse).getDeletedRenderParameters();
            }
            if (deletedRenderParameters == null) {
                deletedRenderParameters = new ArrayList<String>();
            }
            Set<Map.Entry<String, String[]>> entrySet = tempRenderParameters.entrySet();
            for (Map.Entry<String, String[]> entry : entrySet) {
                if (entry.getValue() != null || deletedRenderParameters.contains(entry.getKey())) continue;
                deletedRenderParameters.add(entry.getKey());
            }
            for (String deletedRenderParameter : deletedRenderParameters) {
                tempRenderParameters.remove(deletedRenderParameter);
            }
            this.setRenderParameters(containerRequest, portletEntityId, tempRenderParameters);
        }
    }

    public void executeEvent(ExecuteEventRequest executeEventRequest, ExecuteEventResponse executeEventResponse) throws ContainerException, ContentException {
        this.getCachingService().removeCachedPortlet((ContainerRequest)executeEventRequest);
        Map currentEventParameters = executeEventRequest.getEventParameters();
        String scopeID = this.getActionScopeID(currentEventParameters);
        if (scopeID != null) {
            Map<String, Serializable> scopedAttributes = this.getScopedAttributes((ContainerRequest)executeEventRequest, executeEventRequest.getEntityID());
            executeEventRequest.setScopedAttributes(scopeID, scopedAttributes);
        }
        PortletContainerResponse pcResponse = null;
        try {
            pcResponse = this.invokePAE("EVENT", (ContainerRequest)executeEventRequest, (ContainerResponse)executeEventResponse);
            PortletContainerErrorCode errorCode = pcResponse.getErrorCode();
            if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                logger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{executeEventRequest.getEntityID(), errorCode});
                executeEventResponse.setEventFailed(true);
                executeEventResponse.setEventFailedMessage(pcResponse.getException().getMessage());
            } else {
                Map renderParameters = executeEventResponse.getRenderParameters();
                if (scopeID == null) {
                    scopeID = this.getActionScopeID(renderParameters);
                }
                if (scopeID != null) {
                    this.setActionScopeID(scopeID, renderParameters);
                    this.setScopedAttributes((ContainerRequest)executeEventRequest, executeEventRequest.getEntityID(), executeEventRequest.getScopedAttributes(scopeID));
                }
                this.getCoordinationService().setRenderParameters((ContainerRequest)executeEventRequest, (ContainerResponse)executeEventResponse, executeEventRequest.getEntityID(), renderParameters);
            }
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.executeEvent(): ", (Throwable)e);
        }
    }

    private PortletContainerResponse invokePAE(String action, ContainerRequest containerRequest, ContainerResponse containerResponse) throws IOException, ServletException, ContentException {
        PortletContainerRequest pcRequest = null;
        PortletContainerResponse pcResponse = null;
        if (action.equals("RENDER")) {
            pcRequest = new PortletContainerRenderRequest((GetMarkupRequest)containerRequest);
            pcResponse = new PortletContainerRenderResponse((GetMarkupResponse)containerResponse);
            pcRequest.setActions(renderList);
        } else if (action.equals("ACTION")) {
            pcRequest = new PortletContainerActionRequest((ExecuteActionRequest)containerRequest);
            pcResponse = new PortletContainerActionResponse((ExecuteActionResponse)containerResponse);
            pcRequest.setActions(actionList);
        } else if (action.equals("EVENT")) {
            pcRequest = new PortletContainerEventRequest((ExecuteEventRequest)containerRequest);
            pcResponse = new PortletContainerEventResponse((ExecuteEventResponse)containerResponse);
            ((PortletContainerEventResponse)pcResponse).setCurrentEvent(((ExecuteEventResponse)containerResponse).getCurrentEvent());
            pcRequest.setActions(eventList);
        } else if (action.equals("RESOURCE")) {
            pcRequest = new PortletContainerResourceRequest((GetResourceRequest)containerRequest);
            pcResponse = new PortletContainerResourceResponse((GetResourceResponse)containerResponse);
            pcRequest.setActions(resourceList);
        }
        return this.invokePAE(action, containerRequest, containerResponse, pcRequest, pcResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletContainerResponse invokePAE(String action, ContainerRequest containerRequest, ContainerResponse containerResponse, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse) throws IOException, ServletException, ContentException {
        ServletContext portletAppContext;
        String appNameContext;
        PortletPreferences portletPreferences;
        String portletWindowName;
        String portletName;
        String appName;
        String namespace;
        HttpServletResponse response;
        HttpServletRequest request;
        block28: {
            request = containerRequest.getHttpServletRequest();
            response = containerResponse.getHttpServletResponse();
            EntityID entityID = containerRequest.getEntityID();
            namespace = this.getNamespace(containerRequest, entityID);
            appName = entityID.getPortletApplicationName();
            portletName = entityID.getPortletName();
            portletWindowName = entityID.getPortletWindowName();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSPL_PCCSPCPCI0002", new String[]{appName, portletName, portletWindowName, action});
            }
            portletPreferences = null;
            appNameContext = this.getAppNameContext(appName);
            portletAppContext = this.servletContext.getContext(appNameContext);
            if (portletAppContext == null) {
                logger.log(Level.SEVERE, "PSPL_PCCSPCPCI0014", appNameContext);
                throw new ContentException("Cannot get ServletContext object for" + appNameContext, (ErrorCode)PortletContainerErrorCode.PORTLET_UNAVAILABLE);
            }
            ResourceBundle bundle = this.getResourceBundle(portletAppContext, entityID, containerRequest.getLocale());
            try {
                portletPreferences = containerRequest.getPortletWindowContext().getPreferences(portletWindowName, bundle, containerRequest.getIsReadOnly());
            }
            catch (PortletWindowContextException pwce) {
                if (!logger.isLoggable(Level.SEVERE)) break block28;
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PCCSPCPCI0006");
                record.setParameters(new Object[]{entityID});
                record.setThrown(pwce);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        String responseType = containerRequest.getPortletWindowContext().getContentType();
        pcRequest.setResponseContentType(responseType);
        pcRequest.setPortletPreferences(portletPreferences);
        pcRequest.setPortletName(portletName);
        pcRequest.setPortletWindowName(portletWindowName);
        pcRequest.setSharedSessionAttributesProcess(this.getSharedSessionAttributes(containerRequest));
        pcRequest.setAttributes(containerRequest.getAttributes());
        PAERequestWrapper requestWrapper = new PAERequestWrapper(request, namespace);
        requestWrapper.setRequestSharedAttributes(containerRequest.getRequestSharedAttributes());
        requestWrapper.setAttribute("com.sun.portal.portletcontainer.portlet_container_request", pcRequest);
        requestWrapper.setAttribute("com.sun.portal.portletcontainer.portlet_container_response", pcResponse);
        DispatcherState ds = null;
        boolean portletRenderModeParallel = false;
        portletRenderModeParallel = ContainerUtil.getPolicyService() != null ? ContainerUtil.getPolicyService().renderPortletsInParallel(request) : false;
        this.serializeAll = !portletRenderModeParallel;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSPL_PCCSPCPCI0009", Boolean.toString(portletRenderModeParallel));
        }
        while (true) {
            HttpServletRequest httpServletRequest = request;
            synchronized (httpServletRequest) {
                ds = (DispatcherState)request.getAttribute(DISPATCHER_STATE);
                if (ds == null) {
                    ds = new DispatcherState();
                    request.setAttribute(DISPATCHER_STATE, (Object)ds);
                }
                if (ds.canEnter(appName, this.serializeAll)) {
                    block29: {
                        try {
                            this.handleSession(containerRequest);
                            requestWrapper.setAttribute(PortletContainerConstants.HTTP_SESSION_ID, this.getSessionId(containerRequest));
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.INFO)) break block29;
                            logger.log(Level.INFO, "PSPL_PCCSPCPCI0008", e.getMessage());
                        }
                    }
                    break;
                }
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    pcResponse.setErrorCode(PortletContainerErrorCode.PORTLET_UNAVAILABLE);
                    return pcResponse;
                }
            }
        }
        RequestDispatcher rd = portletAppContext.getRequestDispatcher(PAE_NAME);
        PAEResponseWrapper responseWrapper = new PAEResponseWrapper(response);
        try {
            if (rd == null) {
                throw new FileNotFoundException();
            }
            rd.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, "PSPL_PCCSPCPCI0010", appNameContext);
            throw new ContentException("Invalid webapplication:" + appNameContext, (ErrorCode)PortletContainerErrorCode.PORTLET_UNAVAILABLE);
        }
        finally {
            HttpServletRequest httpServletRequest = request;
            synchronized (httpServletRequest) {
                if (ds.exit()) {
                    request.notifyAll();
                }
            }
        }
        this.setSharedSessionAttributes(containerRequest);
        return pcResponse;
    }

    private Map<String, String[]> getPublicParameters(ExecuteActionRequest executeActionRequest, EntityID entityID) {
        Map<String, String[]> renderParameters = this.getRenderParameters((ContainerRequest)executeActionRequest, entityID);
        List publicRenderParameterHolders = executeActionRequest.getPortletWindowContext().getSupportedPublicRenderParameterHolders(entityID, renderParameters);
        HashMap<String, String[]> publicParameters = new HashMap<String, String[]>();
        if (publicRenderParameterHolders != null) {
            for (PublicRenderParameterHolder publicRenderParameterHolder : publicRenderParameterHolders) {
                String name = publicRenderParameterHolder.getIdentifier();
                publicParameters.put(name, renderParameters.get(name));
            }
        }
        return publicParameters;
    }

    private List<String> getDeletedParameters(Map<String, String[]> actionParameters) {
        ArrayList<String> deletedParameters = new ArrayList<String>();
        Set<Map.Entry<String, String[]>> entries = actionParameters.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entries) {
            String[] values = mapEntry.getValue();
            if (values != null && !values[0].equals("null")) continue;
            deletedParameters.add(mapEntry.getKey());
        }
        return deletedParameters;
    }

    private CachingService getCachingService() {
        return this.cacheManager;
    }

    private CoordinationService getCoordinationService() {
        return this.coordinationService;
    }

    private ClientCachingService getClientCachingService() {
        return this.clientCachingService;
    }

    private void handleSession(ContainerRequest containerRequest) {
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        HttpSession httpSession = null;
        if (!this.isSessionIdExist(containerRequest) && !request.isRequestedSessionIdValid() && (httpSession = request.getSession(false)) != null) {
            logger.log(Level.FINE, "PSPL_PCCSPCPCI0012");
            if (request.isRequestedSessionIdValid()) {
                httpSession.invalidate();
            }
            request.setAttribute("javax.portlet.session_invalid", (Object)Boolean.TRUE);
        }
        if (request.getAttribute(FIRST_THREAD) == null) {
            httpSession = request.getSession(true);
            this.setSessionId(containerRequest, httpSession.getId());
            request.setAttribute(FIRST_THREAD, (Object)Boolean.TRUE);
        }
    }

    private String getSessionId(ContainerRequest containerRequest) {
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        HttpSession httpSession = request.getSession();
        return (String)httpSession.getAttribute(PortletContainerConstants.HTTP_SESSION_ID);
    }

    private void logPortletAppEngineException(EntityID entityID, Exception exception) {
        logger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{entityID, exception});
    }

    private Map<String, String[]> getPublicParametersFromActionParameters(ContainerRequest containerRequest, EntityID portletEntityId, Map<String, String[]> actionParameters) {
        HashMap<String, String[]> publicRenderParameters = null;
        List supportedPublicRenderParameterHolders = containerRequest.getPortletWindowContext().getSupportedPublicRenderParameterHolders(portletEntityId, actionParameters);
        if (supportedPublicRenderParameterHolders != null) {
            ArrayList<String> supportedPublicRenderParameters = new ArrayList<String>(supportedPublicRenderParameterHolders.size());
            for (PublicRenderParameterHolder supportedPublicRenderParameterHolder : supportedPublicRenderParameterHolders) {
                supportedPublicRenderParameters.add(supportedPublicRenderParameterHolder.getIdentifier());
            }
            publicRenderParameters = new HashMap<String, String[]>(supportedPublicRenderParameters.size());
            Set<Map.Entry<String, String[]>> entrySet = actionParameters.entrySet();
            for (Map.Entry<String, String[]> entry : entrySet) {
                String supportedPublicRenderParameter = entry.getKey();
                if (!supportedPublicRenderParameters.contains(supportedPublicRenderParameter)) continue;
                publicRenderParameters.put(entry.getKey(), entry.getValue());
            }
        }
        return publicRenderParameters;
    }

    private void setSessionId(ContainerRequest containerRequest, String sessionId) {
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(PortletContainerConstants.HTTP_SESSION_ID, (Object)sessionId);
    }

    private boolean isSessionIdExist(ContainerRequest containerRequest) {
        HttpServletRequest request = containerRequest.getHttpServletRequest();
        HttpSession httpSession = request.getSession();
        boolean retValue = httpSession.getAttribute(PortletContainerConstants.HTTP_SESSION_ID) != null;
        return retValue;
    }

    private String getAppNameContext(String appName) {
        String appNameContext = "/" + appName;
        return appNameContext;
    }

    private boolean renderURLParameterCacheDisabled(EntityID entityID) {
        String appNameContext = this.getAppNameContext(entityID.getPortletApplicationName());
        DeploymentExtensionDescriptor sunPortletDescriptor = PortletContainerUtil.getSunPortletDescriptor(this.servletContext.getContext(appNameContext));
        if (sunPortletDescriptor != null) {
            return sunPortletDescriptor.renderURLParameterCacheDisabled(entityID.getPortletName());
        }
        return false;
    }

    private Map<String, String[]> getRenderParameters(ContainerRequest containerRequest, EntityID portletEntityId) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        HashMap<String, String[]> renderParameters = (HashMap<String, String[]>)portletWindowContext.getProperty("com.sun.portal.portletcontainer.renderParameters." + portletEntityId);
        if (renderParameters == null || renderParameters.size() == 0) {
            renderParameters = new HashMap<String, String[]>();
        }
        return renderParameters;
    }

    private void setRenderParameters(ContainerRequest containerRequest, EntityID portletEntityId, Map<String, String[]> renderParameters) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        portletWindowContext.setProperty("com.sun.portal.portletcontainer.renderParameters." + portletEntityId, renderParameters);
    }

    private Map<String, String[]> getRenderURLParameters(ContainerRequest containerRequest, EntityID portletEntityId) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        HashMap<String, String[]> renderURLParameters = (HashMap<String, String[]>)portletWindowContext.getProperty("com.sun.portal.portletcontainer.renderURLParameters." + portletEntityId);
        if (renderURLParameters == null || renderURLParameters.size() == 0) {
            renderURLParameters = new HashMap<String, String[]>();
        }
        return renderURLParameters;
    }

    private void setRenderURLParameters(ContainerRequest containerRequest, EntityID portletEntityId, Map<String, String[]> renderURLParameters) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        portletWindowContext.setProperty("com.sun.portal.portletcontainer.renderURLParameters." + portletEntityId, renderURLParameters);
    }

    private Map<String, Serializable> getScopedAttributes(ContainerRequest containerRequest, EntityID portletEntityId) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        HashMap<String, Serializable> scopedAttributes = (HashMap<String, Serializable>)portletWindowContext.getProperty("com.sun.portal.portletcontainer.scopedAttributes." + portletEntityId);
        if (scopedAttributes == null || scopedAttributes.size() == 0) {
            scopedAttributes = new HashMap<String, Serializable>();
        }
        return scopedAttributes;
    }

    private void setScopedAttributes(ContainerRequest containerRequest, EntityID portletEntityId, Map scopedAttributes) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        portletWindowContext.setProperty("com.sun.portal.portletcontainer.scopedAttributes." + portletEntityId, (Object)scopedAttributes);
    }

    private String getActionScopeID(Map<String, String[]> renderParameters) {
        String[] scopeID = renderParameters.get("javax.portlet.as");
        if (scopeID != null) {
            return scopeID[0];
        }
        return null;
    }

    private void setActionScopeID(String scopeID, Map<String, String[]> renderParameters) {
        if (this.getActionScopeID(renderParameters) == null) {
            renderParameters.put("javax.portlet.as", new String[]{scopeID});
        }
    }

    private void removeActionScopeID(Map<String, String[]> renderParameters) {
        if (this.getActionScopeID(renderParameters) != null) {
            renderParameters.remove("javax.portlet.as");
        }
    }

    private String getTitle(GetMarkupRequest getMarkUpRequest, EntityID entityID) {
        String title;
        block3: {
            PortletWindowContext portletWindowContext = getMarkUpRequest.getPortletWindowContext();
            String portletWindowName = entityID.getPortletWindowName();
            Locale locale = getMarkUpRequest.getLocale();
            if (locale == null) {
                locale = getMarkUpRequest.getHttpServletRequest().getLocale();
            }
            title = null;
            try {
                title = portletWindowContext.getPortletWindowTitle(portletWindowName, locale.toString());
            }
            catch (PortletWindowContextException pwce) {
                if (!logger.isLoggable(Level.INFO)) break block3;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSPL_PCCSPCPCI0007");
                logRecord.setParameters(new Object[]{portletWindowName});
                logRecord.setThrown(pwce);
                logger.log(logRecord);
            }
        }
        return title;
    }

    private String getNamespace(ContainerRequest containerRequest, EntityID portletEntityId) {
        String namespace = containerRequest.getNamespace(portletEntityId.getPortletID());
        if (namespace == null) {
            return ContainerUtil.getJavascriptSafeName((String)portletEntityId.toString());
        }
        return namespace;
    }

    private String getWindowID(ContainerRequest containerRequest, EntityID portletEntityId) {
        String windowID = containerRequest.getWindowID(portletEntityId.getPortletID());
        if (windowID == null) {
            return portletEntityId.toString();
        }
        return windowID;
    }

    protected ResourceBundle getResourceBundle(ServletContext portletAppContext, EntityID entityID, Locale locale) {
        String portletName = entityID.getPortletName();
        Map portletResourceMap = (Map)portletAppContext.getAttribute("com.sun.portal.portletcontainer.portlet_resources");
        ResourceBundle bundle = PortletContainerUtil.getResourceBundle(portletResourceMap, portletName, locale);
        return bundle;
    }

    public List<EntityID> processContainerEvent(PortletEvent event, EntityID portletEntityID, HttpServletRequest request, HttpServletResponse response) throws ContainerException {
        List updatedPortlets = null;
        try {
            ContainerEventPolicy containerEventPolicy = ContainerUtil.getPolicyService().getContainerEventPolicy();
            boolean isEnabled = containerEventPolicy.isEnabled(event.getName());
            if (isEnabled) {
                PortletWindowContextAbstractFactory afactory = new PortletWindowContextAbstractFactory();
                PortletWindowContextFactory factory = afactory.getPortletWindowContextFactory();
                PortletWindowContext portletWindowContext = factory.getPortletWindowContext(request);
                ChannelURLFactory channelURLFactory = null;
                ExecuteEventRequest executeEventRequest = this.createExecuteEventRequest(request, portletEntityID, ChannelState.NORMAL, ChannelMode.VIEW, portletWindowContext, channelURLFactory);
                ExecuteEventResponse executeEventResponse = this.createExecuteEventResponse(response);
                ConcurrentLinkedQueue<PortletEvent> eventQueue = new ConcurrentLinkedQueue<PortletEvent>();
                eventQueue.add(event);
                executeEventRequest.getPolicyManager().setEventPolicy((EventPolicy)containerEventPolicy);
                updatedPortlets = this.getCoordinationService().publishEvent((ContainerRequest)executeEventRequest, (ContainerResponse)executeEventResponse, eventQueue);
            }
        }
        catch (ServiceException ex) {
            throw new ContainerException("Exception while processing Container Event", (Throwable)ex);
        }
        catch (PortletWindowContextException ex) {
            throw new ContainerException("Exception while processing Container Event", (Throwable)ex);
        }
        if (updatedPortlets == null) {
            updatedPortlets = Collections.emptyList();
        }
        return updatedPortlets;
    }

    public List<EntityID> processContainerEvent(PortletEvent event, EntityID portletEntityID) throws ContainerException {
        return Collections.emptyList();
    }

    private void setSharedSessionAttributes(ContainerRequest containerRequest) {
        Map sharedSessionAttributes = containerRequest.getSharedSessionAttributesPublish();
        if (sharedSessionAttributes != null && !sharedSessionAttributes.isEmpty()) {
            PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
            portletWindowContext.setProperty("com.sun.portal.portletcontainer.sharedSessionAttributes.", (Object)sharedSessionAttributes);
        }
    }

    private Map<String, Object> getSharedSessionAttributes(ContainerRequest containerRequest) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        HashMap<String, Object> sharedSessionAttributes = (HashMap<String, Object>)portletWindowContext.getProperty("com.sun.portal.portletcontainer.sharedSessionAttributes.");
        if (sharedSessionAttributes == null || sharedSessionAttributes.isEmpty()) {
            sharedSessionAttributes = new HashMap<String, Object>();
        }
        return sharedSessionAttributes;
    }

    static {
        logger = ContainerLogger.getLogger(PortletContainer.class, (String)"PCLogMessages");
        actionList = new ArrayList<String>();
        renderList = new ArrayList<String>();
        eventList = new ArrayList<String>();
        resourceList = new ArrayList<String>();
        actionList.add("ACTION");
        renderList.add("RENDER");
        eventList.add("EVENT");
        resourceList.add("RESOURCE");
    }
}

