/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.report.ExportReport;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.ZipUtil;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;

public abstract class AbstractExportProcess {
    protected AbstractExportProcess() {
    }

    protected File createExportDir(UserDetail userDetail) throws ImportExportException {
        String thisExportDir = this.generateExportDirName(userDetail, "export");
        String tempDir = FileRepositoryManager.getTemporaryPath();
        File fileExportDir = new File(tempDir + thisExportDir);
        if (!fileExportDir.exists()) {
            try {
                FileFolderManager.createFolder((File)fileExportDir);
            }
            catch (UtilException ex) {
                throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
            }
        }
        return fileExportDir;
    }

    protected void createZipFile(File fileExportDir, ExportReport exportReport) throws ImportExportException {
        try {
            String zipFileName = fileExportDir.getName() + ".zip";
            String tempDir = FileRepositoryManager.getTemporaryPath();
            long zipFileSize = ZipUtil.compressPathToZip((String)fileExportDir.getPath(), (String)(tempDir + zipFileName));
            exportReport.setZipFileName(zipFileName);
            exportReport.setZipFileSize(zipFileSize);
            exportReport.setZipFilePath(FileServerUtils.getUrlToTempDir((String)zipFileName));
            exportReport.setDateFin(new Date());
        }
        catch (IOException ex) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
        }
    }

    protected String generateExportDirName(UserDetail userDetail, String prefixName) {
        StringBuilder sb = new StringBuilder(prefixName);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH'H'mm'm'ss's'");
        String dateFormatee = dateFormat.format(date);
        sb.append(dateFormatee);
        sb.append('_').append(userDetail.getId());
        return sb.toString();
    }
}

