/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.FilterParseException;
import java.beans.ConstructorProperties;

public class ValuePathExpression
implements FilterExpression {
    AttributeReference attributePath;
    FilterExpression attributeExpression;

    public ValuePathExpression(AttributeReference attributePath) {
        this.attributePath = attributePath;
    }

    public static ValuePathExpression fromFilterExpression(AttributeReference attrRef, FilterExpression attributeExpression) throws FilterParseException {
        ValuePathExpression vpe = new ValuePathExpression(attrRef, attributeExpression);
        return vpe;
    }

    public static ValuePathExpression fromFilterExpression(String attribute, FilterExpression expression) throws FilterParseException {
        AttributeReference attributeReference = new AttributeReference(attribute);
        return ValuePathExpression.fromFilterExpression(attributeReference, expression);
    }

    @Override
    public String toFilter() {
        String filter;
        if (this.attributeExpression != null) {
            String subAttributeName = this.attributePath.getSubAttributeName();
            String attributeExpressionFilter = this.attributeExpression.toUnqualifiedFilter();
            if (subAttributeName != null) {
                String base = this.attributePath.getAttributeBase();
                filter = base + "[" + attributeExpressionFilter + "]." + subAttributeName;
            } else {
                String attribute = this.attributePath.getFullyQualifiedAttributeName();
                filter = attribute + "[" + attributeExpressionFilter + "]";
            }
        } else {
            filter = this.attributePath.getFullyQualifiedAttributeName();
        }
        return filter;
    }

    @Override
    public void setAttributePath(String urn, String parentAttributeName) {
        this.attributePath.setUrn(urn);
        String subAttributeName = this.attributePath.getAttributeName();
        this.attributePath.setAttributeName(parentAttributeName);
        this.attributePath.setSubAttributeName(subAttributeName);
        this.attributeExpression.setAttributePath(urn, parentAttributeName);
    }

    @Override
    public String toUnqualifiedFilter() {
        String filter;
        if (this.attributeExpression != null) {
            String attributeName = this.attributePath.getAttributeName();
            String subAttributeName = this.attributePath.getSubAttributeName();
            String attributeExpressionFilter = this.attributeExpression.toUnqualifiedFilter();
            filter = subAttributeName != null ? attributeName + "[" + attributeExpressionFilter + "]." + subAttributeName : attributeName + "[" + attributeExpressionFilter + "]";
        } else {
            String subAttributeName = this.attributePath.getSubAttributeName();
            filter = this.attributePath.getAttributeName() + (subAttributeName != null ? "." + subAttributeName : "");
        }
        return filter;
    }

    public AttributeReference getAttributePath() {
        return this.attributePath;
    }

    public FilterExpression getAttributeExpression() {
        return this.attributeExpression;
    }

    public void setAttributePath(AttributeReference attributePath) {
        this.attributePath = attributePath;
    }

    public void setAttributeExpression(FilterExpression attributeExpression) {
        this.attributeExpression = attributeExpression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValuePathExpression)) {
            return false;
        }
        ValuePathExpression other = (ValuePathExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AttributeReference this$attributePath = this.getAttributePath();
        AttributeReference other$attributePath = other.getAttributePath();
        if (this$attributePath == null ? other$attributePath != null : !((Object)this$attributePath).equals(other$attributePath)) {
            return false;
        }
        FilterExpression this$attributeExpression = this.getAttributeExpression();
        FilterExpression other$attributeExpression = other.getAttributeExpression();
        return !(this$attributeExpression == null ? other$attributeExpression != null : !this$attributeExpression.equals(other$attributeExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValuePathExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributePath = this.getAttributePath();
        result = result * 59 + ($attributePath == null ? 43 : ((Object)$attributePath).hashCode());
        FilterExpression $attributeExpression = this.getAttributeExpression();
        result = result * 59 + ($attributeExpression == null ? 43 : $attributeExpression.hashCode());
        return result;
    }

    public String toString() {
        return "ValuePathExpression(attributePath=" + this.getAttributePath() + ", attributeExpression=" + this.getAttributeExpression() + ")";
    }

    @ConstructorProperties(value={"attributePath", "attributeExpression"})
    public ValuePathExpression(AttributeReference attributePath, FilterExpression attributeExpression) {
        this.attributePath = attributePath;
        this.attributeExpression = attributeExpression;
    }

    public ValuePathExpression() {
    }
}

