/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.impl;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.ExecuteEventRequest;
import com.sun.portal.container.ExecuteEventResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.WindowRequestReader;
import com.sun.portal.container.impl.ContainerRequestImpl;
import com.sun.portal.container.impl.ContainerResponseImpl;
import com.sun.portal.container.impl.ExecuteActionRequestImpl;
import com.sun.portal.container.impl.ExecuteActionResponseImpl;
import com.sun.portal.container.impl.ExecuteEventRequestImpl;
import com.sun.portal.container.impl.ExecuteEventResponseImpl;
import com.sun.portal.container.impl.GetMarkupRequestImpl;
import com.sun.portal.container.impl.GetMarkupResponseImpl;
import com.sun.portal.container.impl.GetResourceRequestImpl;
import com.sun.portal.container.impl.GetResourceResponseImpl;
import com.sun.portal.container.service.ServiceManager;
import com.sun.portal.container.service.policy.impl.PolicyManagerImpl;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractContainer
implements Container {
    public GetMarkupRequest createGetMarkUpRequest(HttpServletRequest request, EntityID portletEntityId, ChannelState channelState, ChannelMode channelMode, PortletWindowContext portletWindowContext, ChannelURLFactory channelURLFactory) {
        ContainerRequestImpl containerRequest = this.assembleContainerRequest(request, portletEntityId, channelState, channelMode, portletWindowContext, channelURLFactory, RequestType.RENDER);
        GetMarkupRequest getMarkupRequestImpl = (GetMarkupRequest)((Object)containerRequest);
        getMarkupRequestImpl.setCharacterEncoding(request.getCharacterEncoding());
        boolean isTarget = this.getIsTarget(getMarkupRequestImpl, portletEntityId);
        if (isTarget) {
            getMarkupRequestImpl.setIsTarget(isTarget);
            this.setIsTarget(getMarkupRequestImpl, portletEntityId, false);
        }
        return getMarkupRequestImpl;
    }

    public GetMarkupResponse createGetMarkUpResponse(HttpServletResponse response) {
        ContainerResponseImpl containerResponse = this.assembleContainerResponse(response, RequestType.RENDER);
        return (GetMarkupResponse)((Object)containerResponse);
    }

    public ExecuteActionRequest createExecuteActionRequest(HttpServletRequest request, EntityID portletEntityId, ChannelState channelState, ChannelMode channelMode, PortletWindowContext portletWindowContext, ChannelURLFactory channelURLFactory, WindowRequestReader windowRequestReader) {
        ContainerRequestImpl containerRequest = this.assembleContainerRequest(request, portletEntityId, channelState, channelMode, portletWindowContext, channelURLFactory, RequestType.ACTION);
        ExecuteActionRequest executeActionRequestImpl = (ExecuteActionRequest)((Object)containerRequest);
        executeActionRequestImpl.setWindowRequestReader(windowRequestReader);
        executeActionRequestImpl.setCharacterEncoding(request.getCharacterEncoding());
        return executeActionRequestImpl;
    }

    public ExecuteActionResponse createExecuteActionResponse(HttpServletResponse response) {
        ContainerResponseImpl containerResponse = this.assembleContainerResponse(response, RequestType.ACTION);
        return (ExecuteActionResponse)((Object)containerResponse);
    }

    public ExecuteEventRequest createExecuteEventRequest(HttpServletRequest request, EntityID portletEntityId, ChannelState channelState, ChannelMode channelMode, PortletWindowContext portletWindowContext, ChannelURLFactory channelURLFactory) {
        ContainerRequestImpl containerRequest = this.assembleContainerRequest(request, portletEntityId, channelState, channelMode, portletWindowContext, channelURLFactory, RequestType.EVENT);
        ExecuteEventRequest executeEventRequestImpl = (ExecuteEventRequest)((Object)containerRequest);
        executeEventRequestImpl.setCharacterEncoding(request.getCharacterEncoding());
        return executeEventRequestImpl;
    }

    public ExecuteEventResponse createExecuteEventResponse(HttpServletResponse response) {
        ContainerResponseImpl containerResponse = this.assembleContainerResponse(response, RequestType.EVENT);
        return (ExecuteEventResponse)((Object)containerResponse);
    }

    public ExecuteEventRequest createExecuteEventRequest(ContainerRequest containerRequest) {
        ExecuteEventRequestImpl executeEventRequestImpl = new ExecuteEventRequestImpl();
        executeEventRequestImpl.setAllowableChannelModes(containerRequest.getAllowableChannelModes());
        executeEventRequestImpl.setAllowableContentTypes(containerRequest.getAllowableContentTypes());
        executeEventRequestImpl.setAllowableWindowStates(containerRequest.getAllowableWindowStates());
        executeEventRequestImpl.setAttributes(containerRequest.getAttributes());
        executeEventRequestImpl.setChannelMode(containerRequest.getChannelMode());
        executeEventRequestImpl.setChannelURLFactory(containerRequest.getChannelURLFactory());
        executeEventRequestImpl.setCharacterEncoding(containerRequest.getCharacterEncoding());
        executeEventRequestImpl.setHttpServletRequest(containerRequest.getHttpServletRequest());
        executeEventRequestImpl.setHttpSession(containerRequest.getHttpSession());
        executeEventRequestImpl.setLocale(containerRequest.getLocale());
        executeEventRequestImpl.setNamespace(containerRequest.getNamespace());
        executeEventRequestImpl.setPolicyManager(containerRequest.getPolicyManager());
        executeEventRequestImpl.setPortalInfo(containerRequest.getPortalInfo());
        executeEventRequestImpl.setPortletWindowContext(containerRequest.getPortletWindowContext());
        executeEventRequestImpl.setPortletNamespaces(containerRequest.getPortletNamespaces());
        executeEventRequestImpl.setPortletWindowIDs(containerRequest.getPortletWindowIDs());
        executeEventRequestImpl.setRoles(containerRequest.getRoles());
        executeEventRequestImpl.setUserID(containerRequest.getUserID());
        executeEventRequestImpl.setUserInfo(containerRequest.getUserInfo());
        executeEventRequestImpl.setUserPrincipal(containerRequest.getUserPrincipal());
        executeEventRequestImpl.setWindowID(containerRequest.getWindowID());
        executeEventRequestImpl.setWindowState(containerRequest.getWindowState());
        return executeEventRequestImpl;
    }

    public ExecuteEventResponse createExecuteEventResponse(ContainerResponse containerResponse) {
        ExecuteEventResponseImpl executeEventResponseImpl = new ExecuteEventResponseImpl();
        executeEventResponseImpl.setHttpServletResponse(containerResponse.getHttpServletResponse());
        return executeEventResponseImpl;
    }

    public GetResourceRequest createGetResourceRequest(HttpServletRequest request, EntityID portletEntityId, ChannelState channelState, ChannelMode channelMode, PortletWindowContext portletWindowContext, ChannelURLFactory channelURLFactory, WindowRequestReader windowRequestReader) {
        ContainerRequestImpl containerRequest = this.assembleContainerRequest(request, portletEntityId, channelState, channelMode, portletWindowContext, channelURLFactory, RequestType.RESOURCE);
        GetResourceRequest GetResourceRequestImpl2 = (GetResourceRequest)((Object)containerRequest);
        GetResourceRequestImpl2.setWindowRequestReader(windowRequestReader);
        GetResourceRequestImpl2.setCharacterEncoding(request.getCharacterEncoding());
        return (GetResourceRequest)((Object)containerRequest);
    }

    public GetResourceResponse createGetResourceResponse(HttpServletResponse response) {
        ContainerResponseImpl containerResponse = this.assembleContainerResponse(response, RequestType.RESOURCE);
        return (GetResourceResponse)((Object)containerResponse);
    }

    protected Object getService(String serviceName) {
        return ServiceManager.getServiceManager().getService(serviceName);
    }

    private ContainerRequestImpl assembleContainerRequest(HttpServletRequest request, EntityID entityId, ChannelState channelState, ChannelMode channelMode, PortletWindowContext portletWindowContext, ChannelURLFactory channelURLFactory, RequestType requestType) {
        ContainerRequestImpl containerRequest = null;
        if (requestType.equals((Object)RequestType.ACTION)) {
            containerRequest = new ExecuteActionRequestImpl();
        } else if (requestType.equals((Object)RequestType.EVENT)) {
            containerRequest = new ExecuteEventRequestImpl();
        } else if (requestType.equals((Object)RequestType.RENDER)) {
            containerRequest = new GetMarkupRequestImpl();
        } else if (requestType.equals((Object)RequestType.RESOURCE)) {
            containerRequest = new GetResourceRequestImpl();
        }
        if (containerRequest != null) {
            containerRequest.setHttpServletRequest(request);
            containerRequest.setEntityID(entityId);
            containerRequest.setWindowState(channelState);
            containerRequest.setChannelMode(channelMode);
            containerRequest.setPortletWindowContext(portletWindowContext);
            containerRequest.setChannelURLFactory(channelURLFactory);
            ArrayList<ChannelState> allowableWindowStates = new ArrayList<ChannelState>();
            allowableWindowStates.add(ChannelState.MAXIMIZED);
            allowableWindowStates.add(ChannelState.MINIMIZED);
            allowableWindowStates.add(ChannelState.NORMAL);
            containerRequest.setAllowableWindowStates(allowableWindowStates);
            ArrayList<ChannelMode> allowablePortletWindowModes = new ArrayList<ChannelMode>();
            allowablePortletWindowModes.add(ChannelMode.VIEW);
            allowablePortletWindowModes.add(ChannelMode.EDIT);
            allowablePortletWindowModes.add(ChannelMode.HELP);
            containerRequest.setAllowableChannelModes(allowablePortletWindowModes);
            String contentType = portletWindowContext.getContentType();
            ArrayList<String> allowableContentTypes = new ArrayList<String>();
            allowableContentTypes.add(contentType);
            containerRequest.setAllowableContentTypes(allowableContentTypes);
            containerRequest.setPolicyManager(new PolicyManagerImpl());
        }
        return containerRequest;
    }

    private ContainerResponseImpl assembleContainerResponse(HttpServletResponse response, RequestType requestType) {
        ContainerResponseImpl containerResponse = null;
        if (requestType.equals((Object)RequestType.ACTION)) {
            containerResponse = new ExecuteActionResponseImpl();
        } else if (requestType.equals((Object)RequestType.EVENT)) {
            containerResponse = new ExecuteEventResponseImpl();
        } else if (requestType.equals((Object)RequestType.RENDER)) {
            containerResponse = new GetMarkupResponseImpl();
        } else if (requestType.equals((Object)RequestType.RESOURCE)) {
            containerResponse = new GetResourceResponseImpl();
        }
        if (containerResponse != null) {
            containerResponse.setHttpServletResponse(response);
        }
        return containerResponse;
    }

    protected boolean getIsTarget(ContainerRequest containerRequest, EntityID entityId) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        String targetValue = (String)portletWindowContext.getProperty("com.sun.portal.container.isTarget." + entityId);
        if (targetValue != null) {
            Boolean target = Boolean.valueOf(targetValue);
            return target;
        }
        return false;
    }

    protected void setIsTarget(ContainerRequest containerRequest, EntityID entityId, boolean isTarget) {
        PortletWindowContext portletWindowContext = containerRequest.getPortletWindowContext();
        portletWindowContext.setProperty("com.sun.portal.container.isTarget." + entityId, String.valueOf(isTarget));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        ACTION,
        EVENT,
        RENDER,
        RESOURCE;

    }
}

