/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserReference;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.jcr.security.JCRUserCredentialsProvider;
import org.silverpeas.core.jcr.webdav.WebDavContext;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.security.token.exception.TokenException;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;

@Provider
public class WebDavCredentialsProvider
implements CredentialsProvider {
    protected WebDavCredentialsProvider() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Credentials getCredentials(HttpServletRequest request) throws LoginException {
        String authToken;
        WebDavContext webdavContext = WebDavContext.getWebDavContext(request.getPathInfo());
        String accessToken = webdavContext.getToken();
        if (accessToken.isEmpty()) throw new LoginException("Bad credentials!");
        User user = (User)CacheAccessorProvider.getApplicationCacheAccessor().getCache().get((Object)accessToken, User.class);
        if (user == null) throw new LoginException("No user matching the credentials!");
        try {
            UserReference ref = UserReference.fromUser((User)user);
            authToken = PersistentResourceToken.getOrCreateToken((EntityReference)ref).getValue();
        }
        catch (TokenException e) {
            throw new LoginException("Failure to get the API token of user " + user.getId(), (Throwable)e);
        }
        TokenCredentials credentials = (TokenCredentials)JCRUserCredentialsProvider.getUserCredentials(authToken);
        String documentURL = webdavContext.getDocumentURL().replaceFirst("^/[^/]+", "");
        credentials.setAttribute("AuthorizedDocumentPath", documentURL);
        return credentials;
    }
}

