/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.webdav;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.webdav.util.EncodeUtil;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.kernel.cache.model.Cache;

public class WebDavContext {
    static final String WEBDAV_JCR_URL_SUFFIX = "webdav-jcr-url-suffix-";
    private static final Pattern TOKEN_PATTERN = Pattern.compile(".*/webdav/([a-zA-Z0-9]{16}+).*");
    private static final String WEBDAV = "/webdav/";
    private final String documentUrl;
    private final String webDavUrl;
    private final String token;

    public static void clearWebDavContext(String token) {
        WebDavContext.getCache().remove((Object)(WEBDAV_JCR_URL_SUFFIX + token));
    }

    public static WebDavContext createWebDavContext(String token, String documentUrl) {
        String fileName = EncodeUtil.escape((String)documentUrl.replaceFirst("^.*/", ""));
        String webdavUrlSuffix = documentUrl.replaceFirst("^.*/webdav/", "").replaceFirst("[^/]*$", "") + fileName;
        WebDavContext.getCache().put((Object)(WEBDAV_JCR_URL_SUFFIX + token), (Object)webdavUrlSuffix);
        String webdavUrl = documentUrl.replaceFirst("/webdav/.*", WEBDAV + token + "/" + fileName);
        return new WebDavContext(token, documentUrl, webdavUrl);
    }

    public static WebDavContext getWebDavContext(String webDavUrl) {
        String token = "";
        Object clearedWebdavUrl = webDavUrl;
        Matcher tokenMatcher = TOKEN_PATTERN.matcher(webDavUrl);
        if (tokenMatcher.matches()) {
            token = tokenMatcher.group(1);
        }
        if (!token.isEmpty()) {
            clearedWebdavUrl = ((String)clearedWebdavUrl).replace(WEBDAV + token, "/webdav");
            boolean webdavUrlContainsFileName = ((String)clearedWebdavUrl).matches(".*/webdav/.+");
            clearedWebdavUrl = ((String)clearedWebdavUrl).replaceFirst("/webdav.*$", WEBDAV) + (String)WebDavContext.getCache().get((Object)(WEBDAV_JCR_URL_SUFFIX + token), String.class);
            if (!webdavUrlContainsFileName) {
                clearedWebdavUrl = ((String)clearedWebdavUrl).replaceFirst("/[^/]*$", "");
                if (webDavUrl.endsWith("/")) {
                    clearedWebdavUrl = (String)clearedWebdavUrl + "/";
                }
            }
        }
        return new WebDavContext(token, (String)clearedWebdavUrl, webDavUrl);
    }

    private WebDavContext(String token, String documentUrl, String webDavUrl) {
        this.documentUrl = documentUrl;
        this.webDavUrl = webDavUrl;
        this.token = token;
    }

    public String getDocumentURL() {
        return this.documentUrl;
    }

    public String getWebDavUrl() {
        return this.webDavUrl;
    }

    public String getToken() {
        return this.token;
    }

    private static Cache getCache() {
        return CacheAccessorProvider.getApplicationCacheAccessor().getCache();
    }
}

