/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class LDIFReader
implements LDAPReader {
    private boolean requestFile = true;
    private String version;
    private int reqType;
    private int lNumber;
    private int dnlNumber;
    private int fNumber = 0;
    private byte[] bytes = new byte[0];
    private boolean control = false;
    private String entryDN;
    private String[] modInfo;
    private ArrayList rFields = new ArrayList();
    private ArrayList cList = new ArrayList();
    private BufferedReader bufReader;
    private LDAPControl[] controls = null;
    private LDAPEntry currentEntry = null;
    private LDAPModification[] mods;
    private LDAPMessage currentRequest = null;

    public LDIFReader(InputStream in) throws IOException, LDAPLocalException {
        this(in, 1, 8192);
    }

    public LDIFReader(InputStream in, int version) throws IOException, LDAPLocalException {
        this(in, version, 8192);
    }

    public LDIFReader(InputStream in, int version, int bufSize) throws IOException, LDAPLocalException {
        String line = null;
        if (version != 1) {
            throw new RuntimeException("com.novell.ldap.ldif_dsml.LDIFReader:found: " + version + ", Should be: 1");
        }
        this.setVersion(version);
        InputStreamReader isr = new InputStreamReader(in, "US-ASCII");
        this.bufReader = new BufferedReader(isr);
        while ((line = this.bufReader.readLine()) != null && (line.length() == 0 || line.startsWith("#"))) {
            ++this.lNumber;
        }
        if (line == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: The file contains no LDIF info", 82);
        }
        ++this.lNumber;
        if (line.startsWith("version:")) {
            this.version = line.substring("version:".length()).trim();
            if (!this.version.equals("1")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: version: found '" + version + "' (on line " + this.lNumber + " of the file), should be '1'", 82);
            }
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Version line must be the first meaningful line(on line " + this.lNumber + " of the file)", 82);
        }
        do {
            this.bufReader.mark(bufSize);
            line = this.bufReader.readLine();
            if (line == null) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the LDIF file only contains version line.", 82);
            }
            ++this.lNumber;
        } while (line.length() == 0 || line.startsWith("#"));
        while ((line = this.bufReader.readLine()) != null) {
            if (line.startsWith(" ") || line.startsWith("#")) continue;
            if (line.length() != 0) break;
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (line == null) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: the first record only has dn field(line " + this.lNumber + " of the file)", 82);
        }
        if (line.startsWith("changetype") || line.startsWith("control")) {
            this.setRequest(true);
        } else {
            this.setRequest(false);
        }
        this.bufReader.reset();
        --this.lNumber;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(int value) {
        this.version = String.valueOf(value);
    }

    public boolean isRequest() {
        return this.requestFile;
    }

    private void setRequest(boolean type) {
        this.requestFile = type;
    }

    public LDAPMessage readMessage() throws IOException, LDAPException {
        this.readRecordFields();
        if (this.rFields == null) {
            return null;
        }
        this.toRecordProperties();
        if (!this.isRequest()) {
            return new LDAPSearchResult(this.currentEntry, null);
        }
        switch (this.reqType) {
            case 4: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 8: {
                this.currentRequest = new LDAPAddRequest(this.currentEntry, this.controls);
                break;
            }
            case 10: {
                this.currentRequest = new LDAPDeleteRequest(this.entryDN, this.controls);
                break;
            }
            case 12: {
                boolean delOldRdn = Integer.parseInt(this.modInfo[1]) == 1;
                if (this.modInfo[2].length() == 0) {
                    this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], null, delOldRdn, this.controls);
                    break;
                }
                this.currentRequest = new LDAPModifyDNRequest(this.entryDN, this.modInfo[0], this.modInfo[2], delOldRdn, this.controls);
                break;
            }
            case 6: {
                this.currentRequest = new LDAPModifyRequest(this.entryDN, this.mods, this.controls);
                break;
            }
        }
        return this.currentRequest;
    }

    private void readRecordFields() throws IOException, LDAPException {
        String line;
        StringBuffer bLine = new StringBuffer(80);
        this.rFields.clear();
        while ((line = this.bufReader.readLine()) != null && (line.length() == 0 || line.startsWith("#"))) {
            ++this.lNumber;
        }
        ++this.lNumber;
        this.dnlNumber = this.lNumber;
        if (line == null) {
            this.rFields = null;
        } else {
            if (!line.startsWith("dn:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReacer: Any record should start with 'dn:'(on line " + this.lNumber + " of the file).", 82);
            }
            bLine.append(line);
            while ((line = this.bufReader.readLine()) != null && line.length() != 0) {
                if (!line.startsWith("#")) {
                    if (line.startsWith(" ")) {
                        bLine.append(line.substring(1, line.length()));
                    } else {
                        bLine = this.trimField(bLine);
                        if (!this.control) {
                            this.rFields.add(bLine);
                        }
                        bLine = new StringBuffer(80);
                        bLine.append(line);
                    }
                }
                ++this.lNumber;
            }
            bLine = this.trimField(bLine);
            this.rFields.add(bLine);
            ++this.lNumber;
            this.fNumber = this.rFields.size();
        }
    }

    private void toRecordProperties() throws IOException, LDAPException {
        StringBuffer dnField = (StringBuffer)this.rFields.get(0);
        if (dnField.charAt(3) != ':') {
            this.entryDN = dnField.substring(3, dnField.length());
        } else {
            this.bytes = Base64.decode(dnField, 4, dnField.length());
            try {
                this.entryDN = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        if (!this.isRequest()) {
            this.toLDAPEntry();
        } else {
            int index = 10;
            StringBuffer ctField = (StringBuffer)this.rFields.get(1);
            if (!ctField.substring(0, index).equalsIgnoreCase("changetype")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed changetype field in record starting on line " + this.dnlNumber + " of the file).", 82);
            }
            String req = ctField.substring(index + 1);
            if (req.equalsIgnoreCase("add")) {
                this.reqType = 8;
                this.toLDAPEntry();
            } else if (req.equalsIgnoreCase("delete")) {
                this.reqType = 10;
            } else if (req.equalsIgnoreCase("modrdn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (req.equalsIgnoreCase("moddn")) {
                this.reqType = 12;
                this.toModInfo();
            } else if (req.equalsIgnoreCase("modify")) {
                this.reqType = 6;
                this.toLDAPModifications();
            } else {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: unsupported request type '" + req + "' specified in changetype filed of the record starting " + "on line " + this.dnlNumber + " of the file.", 82);
            }
            if (this.cList.size() > 0) {
                this.controls = new LDAPControl[this.cList.size()];
            }
        }
    }

    private void toLDAPEntry() throws LDAPLocalException {
        String attrName = null;
        LDAPAttributeSet attrSet = new LDAPAttributeSet();
        int fieldIndex = !this.isRequest() ? 1 : 2;
        for (int i = fieldIndex; i < this.fNumber; ++i) {
            String vals;
            StringBuffer currentField = (StringBuffer)this.rFields.get(i);
            int index = this.IndexOf(currentField, 58);
            if (index == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: missing ':' after attribute name in record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            attrName = currentField.substring(0, index);
            if (attrSet.getAttribute(attrName) == null) {
                attrSet.add(new LDAPAttribute(attrName));
            }
            if (currentField.length() > index + 1) {
                if (currentField.charAt(index + 1) == ':') {
                    attrSet.getAttribute(attrName).addBase64Value(currentField.substring(index + 2));
                    continue;
                }
                if (currentField.charAt(index + 1) == '<') {
                    attrSet.getAttribute(attrName).addBase64Value(currentField.substring(index + 2));
                    continue;
                }
                vals = currentField.substring(index + 1).trim();
                attrSet.getAttribute(attrName).addValue(vals);
                continue;
            }
            if (currentField.length() != index + 1) continue;
            vals = new String("");
            attrSet.getAttribute(attrName).addValue(vals);
        }
        this.currentEntry = new LDAPEntry(this.entryDN, attrSet);
    }

    private void toModInfo() throws LDAPLocalException {
        int index = 6;
        int fieldIndex = 2;
        this.modInfo = new String[3];
        StringBuffer currentField = (StringBuffer)this.rFields.get(fieldIndex);
        if (!currentField.substring(0, index + 1).equalsIgnoreCase("newrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (currentField.charAt(index + 1) != ':') {
            this.modInfo[0] = currentField.substring(index + 1);
        } else {
            this.bytes = Base64.decode(currentField, index + 2, currentField.length());
            try {
                this.modInfo[0] = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException("UTF-8 String encoding not supported by JVM");
            }
        }
        index = 13;
        currentField = (StringBuffer)this.rFields.get(++fieldIndex);
        if (!currentField.substring(0, index).equalsIgnoreCase("deleteoldrdn:")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed deleteoldrdn field in record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        char c = currentField.charAt(index);
        if (c == '1') {
            this.modInfo[1] = new String("1");
        } else if (c == '0') {
            this.modInfo[1] = new String("0");
        } else {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: value for deleteoldrdn field should '0' or '1', found '" + c + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (++fieldIndex == this.fNumber) {
            this.modInfo[2] = new String("");
        } else {
            currentField = (StringBuffer)this.rFields.get(fieldIndex);
            if (!currentField.substring(0, index = 12).equalsIgnoreCase("newsuperior:")) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed newsuperior field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            if (currentField.charAt(index) != ':') {
                this.modInfo[2] = currentField.substring(index);
            } else {
                this.bytes = Base64.decode(currentField, index + 1, currentField.length());
                this.modInfo[2] = new String(this.bytes);
            }
        }
    }

    private void toLDAPModifications() throws LDAPLocalException {
        int fieldIndex = 2;
        LDAPAttribute attr = null;
        ArrayList<LDAPModification> modList = new ArrayList<LDAPModification>();
        if (!this.rFields.get(this.fNumber - 1).toString().equalsIgnoreCase("-")) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: modify record not ends with '-' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        for (int i = fieldIndex; i < this.fNumber; ++i) {
            int index = this.IndexOf((StringBuffer)this.rFields.get(i), 58);
            if (index == -1) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: malformed opName:attrName field in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
            StringBuffer nextField = (StringBuffer)this.rFields.get(i);
            String opName = nextField.substring(0, index);
            String attrName = nextField.substring(index + 1);
            if ((nextField = (StringBuffer)this.rFields.get(++i)).charAt(0) != '-') {
                while (nextField.charAt(0) != '-') {
                    index = this.IndexOf(nextField, 58);
                    if (index == -1) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : no ':' found in attrName:attrValue field in the record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    String aName = nextField.substring(0, index);
                    if (!aName.equalsIgnoreCase(attrName)) {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : found attribute name '" + aName + "', should be '" + attrName + "' in attrName:attrValue field in the record " + "starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    attr = new LDAPAttribute(attrName);
                    if (nextField.charAt(index + 1) == ':') {
                        attr.addBase64Value(nextField.substring(index + 2));
                    } else if (nextField.charAt(index + 1) == '<') {
                        attr.addBase64Value(nextField.substring(index + 2));
                    } else {
                        attr.addValue(nextField.substring(index + 1));
                    }
                    if (opName.equalsIgnoreCase("add")) {
                        modList.add(new LDAPModification(0, attr));
                    } else if (opName.equalsIgnoreCase("delete")) {
                        modList.add(new LDAPModification(1, attr));
                    } else if (opName.equalsIgnoreCase("replace")) {
                        modList.add(new LDAPModification(2, attr));
                    } else {
                        throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader : Not supported modify  request (" + opName + ") specified in " + "record starting on line " + this.dnlNumber + " of the file.", 82);
                    }
                    nextField = (StringBuffer)this.rFields.get(++i);
                }
                continue;
            }
            attr = new LDAPAttribute(attrName);
            if (opName.equalsIgnoreCase("delete")) {
                modList.add(new LDAPModification(1, attr));
                continue;
            }
            if (opName.equalsIgnoreCase("replace")) {
                modList.add(new LDAPModification(2, attr));
                continue;
            }
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: For '" + opName + "', no value " + "specified for atribute '" + attrName + "' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        this.mods = new LDAPModification[modList.size()];
        this.mods = modList.toArray(this.mods);
    }

    private int IndexOf(StringBuffer bl, int ch) {
        if (bl != null) {
            for (int i = 0; i < bl.length(); ++i) {
                if (bl.charAt(i) != ch) continue;
                return i;
            }
        }
        return -1;
    }

    private StringBuffer trimField(StringBuffer line) throws LDAPLocalException {
        LDAPControl ctrl;
        char t;
        int c;
        int lastChar = 0;
        int charIndex = 0;
        boolean isEncoded = false;
        boolean isURL = false;
        boolean criticality = false;
        String oid = null;
        if (line == null || (c = this.IndexOf(line, 58)) == -1) {
            return line;
        }
        lastChar = line.length() - 1;
        while (line.charAt(lastChar) == ' ') {
            --lastChar;
        }
        char[] newChars = new char[lastChar + 1];
        if (c > 6 && line.substring(0, c).equals("control")) {
            this.control = true;
            ++c;
            while (c <= lastChar && line.charAt(c) == ' ') {
                ++c;
            }
        } else {
            this.control = false;
            line.getChars(0, c + 1, newChars, 0);
            charIndex += c + 1;
            ++c;
        }
        if (!this.control) {
            StringBuffer newBuf;
            String cstr;
            if (c <= lastChar) {
                char t2 = line.charAt(c);
                if (t2 == ':') {
                    newChars[charIndex++] = 58;
                    ++c;
                } else if (t2 == '<') {
                    newChars[charIndex++] = 60;
                    ++c;
                }
            }
            boolean nonfile = false;
            String fredir = line.substring(c);
            if (fredir.length() > 0 && fredir.charAt(0) != '<' && (cstr = fredir.trim()).length() > 0 && cstr.charAt(0) == '<') {
                nonfile = true;
            }
            while (c <= lastChar && line.charAt(c) == ' ') {
                ++c;
            }
            if (nonfile) {
                --c;
            }
            if (c <= lastChar) {
                line.getChars(c, lastChar + 1, newChars, charIndex);
                newBuf = new StringBuffer(lastChar);
                newBuf.append(newChars, 0, charIndex += lastChar - c + 1);
                return newBuf;
            }
            if (line.length() == c) {
                newBuf = new StringBuffer();
                line.getChars(c, lastChar + 1, newChars, charIndex);
                newBuf.append(newChars, 0, charIndex += lastChar - c + 1);
                return newBuf;
            }
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: a field contains no value after ':'. the field is in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        int b = c;
        while (c <= lastChar && ((t = line.charAt(c)) == '.' || Character.isDigit(t))) {
            ++c;
        }
        if (b == c) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Control with no oid in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        char[] chars = new char[c - b];
        line.getChars(b, c, chars, 0);
        oid = new String(chars);
        if (c > lastChar) {
            ctrl = new LDAPControl(oid, false, new byte[0]);
            this.cList.add(ctrl);
            return null;
        }
        t = line.charAt(c);
        if (t == ' ') {
            while (c <= lastChar && line.charAt(c) == ' ') {
                ++c;
            }
        }
        if (c + 3 <= lastChar && line.substring(c, c + 4).equals("true")) {
            c += 4;
            criticality = true;
        } else if (c + 4 <= lastChar && line.substring(c, c + 5).equals("false")) {
            c += 5;
            criticality = false;
        }
        if (c > lastChar) {
            ctrl = new LDAPControl(oid, criticality, new byte[0]);
            this.cList.add(ctrl);
            return null;
        }
        t = line.charAt(c);
        if (t != ':') {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: Unexcepted char '" + t + "'. Expecting " + "to see ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        if (++c > lastChar) {
            throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':' in the record starting on line " + this.dnlNumber + " of the file.", 82);
        }
        t = line.charAt(c);
        if (t == ':') {
            isEncoded = true;
            if (++c > lastChar) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after '::' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
        } else if (t == '<') {
            isURL = true;
            if (++c > lastChar) {
                throw new LDAPLocalException("com.novell.ldap.ldif_dsml.LDIFReader: No control value after ':<' in the record starting on line " + this.dnlNumber + " of the file.", 82);
            }
        }
        while (c <= lastChar && line.charAt(c) == ' ') {
            ++c;
        }
        if (c <= lastChar) {
            chars = new char[lastChar + 1 - c];
            line.getChars(c, lastChar + 1, chars, 0);
            this.bytes = isEncoded ? Base64.decode(chars) : (isURL ? new String(chars).getBytes() : new String(chars).getBytes());
        }
        ctrl = new LDAPControl(oid, criticality, this.bytes);
        this.cList.add(ctrl);
        return null;
    }
}

