/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.silverpeas.spnego.Base64;
import org.silverpeas.spnego.SpnegoAuthScheme;
import org.silverpeas.spnego.SpnegoProvider;

public final class SpnegoHttpURLConnection {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private static final Lock LOCK = new ReentrantLock();
    private static final byte[] EMPTY_BYTE = new byte[0];
    private transient boolean connected = false;
    private transient String requestMethod = "GET";
    private final transient Map<String, List<String>> requestProperties = new LinkedHashMap<String, List<String>>();
    private final transient LoginContext loginContext;
    private transient GSSCredential credential;
    private transient boolean cntxtEstablished = false;
    private transient HttpURLConnection conn = null;
    private transient boolean reqCredDeleg = false;
    private transient boolean autoDisposeCreds = true;

    public SpnegoHttpURLConnection(String loginModuleName) throws LoginException {
        this.loginContext = new LoginContext(loginModuleName);
        this.loginContext.login();
        this.credential = null;
    }

    public SpnegoHttpURLConnection(GSSCredential creds) {
        this(creds, true);
    }

    public SpnegoHttpURLConnection(GSSCredential creds, boolean dispose) {
        this.loginContext = null;
        this.credential = creds;
        this.autoDisposeCreds = dispose;
    }

    public SpnegoHttpURLConnection(String loginModuleName, String username, String password) throws LoginException {
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        this.loginContext = new LoginContext(loginModuleName, handler);
        this.loginContext.login();
        this.credential = null;
    }

    private void assertConnected() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
    }

    private void assertNotConnected() {
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
    }

    public HttpURLConnection connect(URL url) throws GSSException, PrivilegedActionException, IOException {
        return this.connect(url, null, null);
    }

    public HttpURLConnection connect(URL url, Proxy proxy) throws GSSException, PrivilegedActionException, IOException {
        return this.connect(url, proxy, null);
    }

    public HttpURLConnection connect(URL url, ByteArrayOutputStream dooutput) throws GSSException, PrivilegedActionException, IOException {
        return this.connect(url, null, dooutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection connect(URL url, Proxy proxy, ByteArrayOutputStream dooutput) throws GSSException, PrivilegedActionException, IOException {
        this.assertNotConnected();
        GSSContext context = null;
        try {
            byte[] data = null;
            LOCK.lock();
            try {
                try {
                    Thread.sleep(31L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                context = this.getGSSContext(url);
                context.requestMutualAuth(true);
                context.requestConf(true);
                context.requestInteg(true);
                context.requestReplayDet(true);
                context.requestSequenceDet(true);
                context.requestCredDeleg(this.reqCredDeleg);
                data = context.initSecContext(EMPTY_BYTE, 0, 0);
            }
            finally {
                LOCK.unlock();
            }
            this.conn = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            this.connected = true;
            Set<String> keys = this.requestProperties.keySet();
            for (String key : keys) {
                for (String value : this.requestProperties.get(key)) {
                    this.conn.addRequestProperty(key, value);
                }
            }
            this.conn.setInstanceFollowRedirects(false);
            this.conn.setRequestMethod(this.requestMethod);
            this.conn.setRequestProperty("Authorization", "Negotiate " + Base64.encode(data));
            if (null != dooutput && dooutput.size() > 0) {
                this.conn.setDoOutput(true);
                dooutput.writeTo(this.conn.getOutputStream());
            }
            this.conn.connect();
            SpnegoAuthScheme scheme = SpnegoProvider.getAuthScheme(this.conn.getHeaderField("WWW-Authenticate"));
            if (null == scheme) {
                LOGGER.fine("SpnegoProvider.getAuthScheme(...) returned null.");
            } else {
                data = scheme.getToken();
                if ("Negotiate".equalsIgnoreCase(scheme.getScheme())) {
                    LOCK.lock();
                    try {
                        data = context.initSecContext(data, 0, data.length);
                    }
                    finally {
                        LOCK.unlock();
                    }
                    if (null != data) {
                        LOGGER.warning("Server requested context loop: " + data.length);
                    }
                } else {
                    throw new UnsupportedOperationException("Scheme NOT Supported: " + scheme.getScheme());
                }
                this.cntxtEstablished = context.isEstablished();
            }
            this.dispose(context);
        }
        catch (Throwable throwable) {
            this.dispose(context);
            throw throwable;
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(GSSContext context) {
        if (null != context) {
            try {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
            catch (GSSException gsse) {
                LOGGER.log(Level.WARNING, "call to dispose context failed.", gsse);
            }
        }
        if (null != this.credential && this.autoDisposeCreds) {
            try {
                this.credential.dispose();
            }
            catch (GSSException gsse) {
                LOGGER.log(Level.WARNING, "call to dispose credential failed.", gsse);
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException le) {
                LOGGER.log(Level.WARNING, "call to logout context failed.", le);
            }
        }
    }

    public void disconnect() {
        this.dispose(null);
        this.requestProperties.clear();
        this.connected = false;
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    public boolean isContextEstablished() {
        return this.cntxtEstablished;
    }

    private void assertKeyValue(String key, String value) {
        if (null == key || key.isEmpty()) {
            throw new IllegalArgumentException("key parameter is null or empty");
        }
        if (null == value) {
            throw new IllegalArgumentException("value parameter is null");
        }
    }

    public void addRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        if (this.requestProperties.containsKey(key)) {
            List<String> val = this.requestProperties.get(key);
            val.add(value);
            this.requestProperties.put(key, val);
        } else {
            this.setRequestProperty(key, value);
        }
    }

    public void setRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        this.requestProperties.put(key, Arrays.asList(value));
    }

    private GSSContext getGSSContext(URL url) throws GSSException, PrivilegedActionException {
        if (null == this.credential) {
            if (null == this.loginContext) {
                throw new IllegalStateException("GSSCredential AND LoginContext NOT initialized");
            }
            this.credential = SpnegoProvider.getClientCredential(this.loginContext.getSubject());
        }
        return SpnegoProvider.getGSSContext(this.credential, url);
    }

    public InputStream getErrorStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public String getHeaderField(int index) {
        this.assertConnected();
        return this.conn.getHeaderField(index);
    }

    public String getHeaderField(String name) {
        this.assertConnected();
        return this.conn.getHeaderField(name);
    }

    public String getHeaderFieldKey(int index) {
        this.assertConnected();
        return this.conn.getHeaderFieldKey(index);
    }

    public InputStream getInputStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.assertConnected();
        return this.conn.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        this.assertConnected();
        return this.conn.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        this.assertConnected();
        return this.conn.getResponseMessage();
    }

    public void requestCredDeleg(boolean requestDelegation) {
        this.assertNotConnected();
        this.reqCredDeleg = requestDelegation;
    }

    public void setRequestMethod(String method) {
        this.assertNotConnected();
        this.requestMethod = method;
    }
}

