/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.documenttemplate;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.documenttemplate.DocumentTemplateRepository;
import org.silverpeas.core.documenttemplate.DocumentTemplateRuntimeException;
import org.silverpeas.core.documenttemplate.JsonDocumentTemplate;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.DeletingPathVisitor;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class DefaultDocumentTemplateRepository
implements DocumentTemplateRepository {
    @Override
    public Optional<DocumentTemplate> getById(String id) {
        DocumentTemplateVisitor visitor = (DocumentTemplateVisitor)new DocumentTemplateVisitor().fileNameFilter(n -> FilenameUtils.getBaseName((String)n).equalsIgnoreCase(id)).walk();
        return visitor.contentPaths.stream().map(this::fetchJsonData).findFirst();
    }

    @Override
    public Stream<DocumentTemplate> streamAll() {
        DocumentTemplateVisitor visitor = (DocumentTemplateVisitor)new DocumentTemplateVisitor().walk();
        return visitor.contentPaths.stream().map(this::fetchJsonData);
    }

    @Override
    public synchronized DocumentTemplate create(DocumentTemplate documentTemplate, InputStream content) {
        this.requireIdIsSet(documentTemplate);
        this.requireFileExtensionIsSet(documentTemplate);
        this.requireContent(documentTemplate, content);
        DocumentTemplateCheckIntegrityVisitor integrityVisitor = (DocumentTemplateCheckIntegrityVisitor)new DocumentTemplateCheckIntegrityVisitor(documentTemplate).walk();
        integrityVisitor.requireNoFileExists();
        DocumentTemplate toCreate = new DocumentTemplate(documentTemplate);
        toCreate.getJson().setCreatorId(User.getCurrentUser().getId());
        toCreate.getJson().setCreationInstant(Instant.now());
        Path jsonPath = toCreate.getDescriptorFilePath();
        Path contentPath = toCreate.getContentFilePath();
        try {
            Files.createDirectories(jsonPath.getParent(), new FileAttribute[0]);
            Files.write(jsonPath, toCreate.getJson().toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            Files.copy(content, contentPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DocumentTemplateRuntimeException(e);
        }
        return toCreate;
    }

    @Override
    public synchronized DocumentTemplate update(DocumentTemplate documentTemplate, InputStream content) {
        this.requireIdIsSet(documentTemplate);
        this.requireFileExtensionIsSet(documentTemplate);
        DocumentTemplateCheckIntegrityVisitor integrityVisitor = (DocumentTemplateCheckIntegrityVisitor)new DocumentTemplateCheckIntegrityVisitor(documentTemplate).walk();
        integrityVisitor.requireFileExists();
        DocumentTemplate toUpdate = new DocumentTemplate(documentTemplate);
        toUpdate.getJson().setLastUpdaterId(User.getCurrentUser().getId());
        toUpdate.getJson().setLastUpdateInstant(Instant.now());
        if (content != null) {
            try {
                DocumentTemplate current = new DocumentTemplate(documentTemplate);
                current.setExtension(integrityVisitor.getContentFileExtension());
                DeletingPathVisitor.deleteQuietly((Path)current.getContentFilePath());
                Path contentPath = toUpdate.getContentFilePath();
                Files.copy(content, contentPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new DocumentTemplateRuntimeException(e);
            }
        } else {
            toUpdate.setExtension(integrityVisitor.getContentFileExtension());
        }
        Path jsonPath = toUpdate.getDescriptorFilePath();
        try {
            Files.createDirectories(jsonPath.getParent(), new FileAttribute[0]);
            Files.write(jsonPath, toUpdate.getJson().toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DocumentTemplateRuntimeException(e);
        }
        return toUpdate;
    }

    @Override
    public synchronized void delete(DocumentTemplate documentTemplate) {
        this.requireIdIsSet(documentTemplate);
        this.requireFileExtensionIsSet(documentTemplate);
        DocumentTemplateCheckIntegrityVisitor integrityVisitor = (DocumentTemplateCheckIntegrityVisitor)new DocumentTemplateCheckIntegrityVisitor(documentTemplate).walk();
        integrityVisitor.requireFullIntegrity();
        Stream.of(documentTemplate.getDescriptorFilePath(), documentTemplate.getContentFilePath()).forEach(DeletingPathVisitor::deleteQuietly);
    }

    private void requireIdIsSet(DocumentTemplate documentTemplate) {
        if (StringUtil.isNotDefined((String)documentTemplate.getId())) {
            throw new DocumentTemplateRuntimeException("Document template has no id set");
        }
    }

    private void requireFileExtensionIsSet(DocumentTemplate documentTemplate) {
        if (StringUtil.isNotDefined((String)documentTemplate.getExtension())) {
            throw new DocumentTemplateRuntimeException(MessageFormat.format("File extension MUST exists for document template with id {0}", documentTemplate.getId()));
        }
    }

    private void requireContent(DocumentTemplate documentTemplate, InputStream content) {
        if (content == null) {
            throw new DocumentTemplateRuntimeException(MessageFormat.format("Content MUST exists for document template with id {0}", documentTemplate.getId()));
        }
    }

    private DocumentTemplate fetchJsonData(Path content) {
        String contentPathAsString = content.toString();
        String fileBaseName = FilenameUtils.getBaseName((String)contentPathAsString);
        String fileExtension = FilenameUtils.getExtension((String)contentPathAsString);
        Path jsonDescriptor = Paths.get(content.getParent().toString(), fileBaseName + ".json");
        return new DocumentTemplate(JsonDocumentTemplate.decode(jsonDescriptor), fileExtension);
    }

    static Path getDocumentTemplateRepositoryPath() {
        return Paths.get(ResourceLocator.getGeneralSettingBundle().getString("dataHomePath"), "documentTemplateRepository");
    }

    private static abstract class AbstractDocumentTemplateVisitor
    extends SimpleFileVisitor<Path> {
        private AbstractDocumentTemplateVisitor() {
        }

        <T extends AbstractDocumentTemplateVisitor> T walk() {
            try {
                Path rootPath = DefaultDocumentTemplateRepository.getDocumentTemplateRepositoryPath();
                if (Files.exists(rootPath, new LinkOption[0])) {
                    Files.walkFileTree(rootPath, this);
                }
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            return (T)this;
        }
    }

    private static class DocumentTemplateCheckIntegrityVisitor
    extends AbstractDocumentTemplateVisitor {
        private final DocumentTemplate template;
        private boolean jsonFileExists = false;
        private boolean contentFileExists = false;
        private String contentFileExtension = "";

        private DocumentTemplateCheckIntegrityVisitor(DocumentTemplate template) {
            this.template = template;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            super.visitFile(file, attrs);
            String fileBaseName = FilenameUtils.getBaseName((String)file.toString());
            String fileExtension = FilenameUtils.getExtension((String)file.toString());
            if (fileBaseName.equalsIgnoreCase(this.template.getId())) {
                if (!fileExtension.equalsIgnoreCase("json")) {
                    this.contentFileExists = true;
                    this.contentFileExtension = fileExtension;
                } else {
                    this.jsonFileExists = true;
                }
            }
            return this.jsonFileExists && this.contentFileExists && StringUtil.isDefined((String)this.contentFileExtension) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
        }

        String getContentFileExtension() {
            return this.contentFileExtension;
        }

        void requireNoFileExists() {
            if (this.jsonFileExists || this.contentFileExists) {
                throw new DocumentTemplateRuntimeException(MessageFormat.format("JSON or content or both files already exist for document template with id {0}", this.template.getId()));
            }
        }

        void requireFileExists() {
            if (!this.jsonFileExists || !this.contentFileExists) {
                throw new DocumentTemplateRuntimeException(MessageFormat.format("JSON or content or both files are missing for document template with id {0}", this.template.getId()));
            }
        }

        void requireFullIntegrity() {
            this.requireFileExists();
            if (!this.contentFileExtension.equalsIgnoreCase(this.template.getExtension())) {
                throw new DocumentTemplateRuntimeException(MessageFormat.format("Extension of content file ''{0}'' is not the one expected ''{1}'' for document template with id {2}", this.contentFileExtension, this.template.getExtension(), this.template.getId()));
            }
        }
    }

    private static class DocumentTemplateVisitor
    extends AbstractDocumentTemplateVisitor {
        private final List<Path> contentPaths = new ArrayList<Path>();
        private Predicate<String> contentFileNameFilter;

        private DocumentTemplateVisitor() {
        }

        DocumentTemplateVisitor fileNameFilter(Predicate<String> filter) {
            this.contentFileNameFilter = filter;
            return this;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            super.visitFile(file, attrs);
            String fileName = file.toString();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            if (!fileExtension.equalsIgnoreCase("json") && (this.contentFileNameFilter == null || this.contentFileNameFilter.test(fileName))) {
                this.contentPaths.add(file);
                if (this.contentFileNameFilter != null) {
                    return FileVisitResult.TERMINATE;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

