/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.ToPDFConverter;
import org.silverpeas.core.contribution.converter.option.FilterOption;
import org.silverpeas.core.contribution.converter.option.SinglePageSelection;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.option.AbstractImageToolOption;
import org.silverpeas.core.io.media.image.option.DimensionOption;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.io.temp.TemporaryWorkspaceTranslation;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.PdfUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.viewer.model.Preview;
import org.silverpeas.core.viewer.model.TemporaryPreview;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.core.viewer.service.AbstractViewerService;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.core.viewer.service.ViewerException;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class DefaultPreviewService
extends AbstractViewerService
implements PreviewService {
    private static final String PROCESS_NAME = "PREVIEW";
    private static final Set<String> imageMimeTypePreviewable = new HashSet<String>();
    @Inject
    private ToPDFConverter toPDFConverter;
    @Inject
    private ImageTool imageTool;

    @Override
    public boolean isPreviewable(File file) {
        String filePath = file.getPath();
        if (this.imageTool.isActivated() && file.exists()) {
            String mimeType = FileUtil.getMimeType((String)filePath);
            return imageMimeTypePreviewable.contains(mimeType) || FileUtil.isPdf((String)filePath) || this.toPDFConverter.isDocumentSupported(filePath) || "text/plain".equals(mimeType);
        }
        return false;
    }

    @Override
    public Preview getPreview(final ViewerContext viewerContext) {
        return this.process(PROCESS_NAME, new AbstractViewerService.ViewerTreatment<Preview>(){

            @Override
            public Preview execute() {
                File resultFile;
                if (!DefaultPreviewService.this.isPreviewable(viewerContext.getOriginalSourceFile())) {
                    throw new ViewerException("IT IS NOT POSSIBLE GETTING DOCUMENT PREVIEW");
                }
                if (DefaultPreviewService.this.toPDFConverter.isDocumentSupported(viewerContext.getOriginalSourceFile().getPath())) {
                    File pdfFile = DefaultPreviewService.this.convertToPdf(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, "pdf"));
                    resultFile = DefaultPreviewService.this.convertToImage(pdfFile, DefaultPreviewService.this.changeFileExtension(pdfFile, "png"));
                    FileUtils.deleteQuietly((File)pdfFile);
                } else {
                    resultFile = FileUtil.isPdf((String)viewerContext.getOriginalFileName()) || "text/plain".equals(FileUtil.getMimeType((String)viewerContext.getOriginalSourceFile().getPath())) ? DefaultPreviewService.this.convertToImage(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, "png")) : DefaultPreviewService.this.convertToImage(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, StringUtil.defaultStringIfNotDefined((String)FilenameUtils.getExtension((String)viewerContext.getOriginalSourceFile().getName()), (String)"jpg")));
                }
                return new TemporaryPreview(viewerContext, resultFile);
            }

            @Override
            public Preview performAfterSuccess(Preview result) {
                if (ViewerSettings.isSilentConversionEnabled() && viewerContext.isProcessingCache() && ViewService.get().isViewable(viewerContext.getOriginalSourceFile())) {
                    ManagedThreadPool.getPool().invoke(new Runnable[]{() -> ViewService.get().getDocumentView(viewerContext.copy())});
                }
                return AbstractViewerService.ViewerTreatment.super.performAfterSuccess(result);
            }
        }).execute(viewerContext);
    }

    @Override
    public void removePreview(ViewerContext viewerContext) {
        Optional.of(viewerContext.fromInitializerProcessName(PROCESS_NAME).getWorkspace()).filter(TemporaryWorkspaceTranslation::exists).ifPresent(TemporaryWorkspaceTranslation::remove);
    }

    private File convertToPdf(File source, File destination) {
        this.toPDFConverter.convert(source, destination, DocumentFormat.pdf, new FilterOption[]{new SinglePageSelection(1)});
        return destination;
    }

    private File convertToImage(File source, File destination) {
        boolean deleteSource = false;
        if (FileUtil.isPdf((String)source.getPath())) {
            PdfUtil.firstPageAsImage((File)source, (File)destination);
            source = destination;
            destination = this.changeFileExtension(destination, "jpg");
            deleteSource = !source.equals(destination);
        }
        this.imageTool.convert(source, destination, CollectionUtil.asSet((Object[])new AbstractImageToolOption[]{DimensionOption.widthAndHeight((Integer)ViewerSettings.getPreviewMaxWidth(), (Integer)ViewerSettings.getPreviewMaxHeight()), OrientationOption.auto()}), new ImageToolDirective[]{ImageToolDirective.PREVIEW_WORK, ImageToolDirective.GEOMETRY_SHRINK, ImageToolDirective.FIRST_PAGE_ONLY});
        if (deleteSource) {
            FileUtils.deleteQuietly((File)source);
        }
        return destination;
    }

    static {
        for (String imageExtension : new String[]{"bmp", "gif", "jpg", "pcd", "png", "tga", "tif", "webp"}) {
            imageMimeTypePreviewable.add(FileUtil.getMimeType((String)("file." + imageExtension)));
        }
        imageMimeTypePreviewable.remove("application/octet-stream");
    }
}

