/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.instance;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.DataRecordUtil;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.MultipleUserField;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.contribution.content.form.field.UserField;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.workflow.api.ProcessModelManager;
import org.silverpeas.core.workflow.api.UserManager;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.Participant;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.Question;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.Input;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Presentation;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.api.model.RelatedGroup;
import org.silverpeas.core.workflow.api.model.RelatedUser;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.TimeOutAction;
import org.silverpeas.core.workflow.api.model.UserInRole;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.datarecord.LazyProcessInstanceDataRecord;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceDataRecord;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceRowRecord;
import org.silverpeas.core.workflow.engine.instance.ActionAndState;
import org.silverpeas.core.workflow.engine.instance.ActiveState;
import org.silverpeas.core.workflow.engine.instance.ActorImpl;
import org.silverpeas.core.workflow.engine.instance.HistoryStepImpl;
import org.silverpeas.core.workflow.engine.instance.InterestedUser;
import org.silverpeas.core.workflow.engine.instance.LockingUser;
import org.silverpeas.core.workflow.engine.instance.ParticipantImpl;
import org.silverpeas.core.workflow.engine.instance.QuestionImpl;
import org.silverpeas.core.workflow.engine.instance.RolePlayer;
import org.silverpeas.core.workflow.engine.instance.UndoHistoryStep;
import org.silverpeas.core.workflow.engine.instance.WorkingUser;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sb_workflow_processinstance")
@AttributeOverride(name="id", column=@Column(name="instanceid"))
public class ProcessInstanceImpl
extends BasicJpaEntity<ProcessInstanceImpl, UniqueIntegerIdentifier>
implements UpdatableProcessInstance {
    private static final String QUESTION_ACTION = "#question#";
    private static final String ADD_ACTIVE_STATE = "addActiveState";
    private static final String ADD_WORKING_USER = "addWorkingUser";
    private static final String REMOVE_WORKING_USER = "removeWorkingUser";
    private static final String ADD_INTERESTED_USER = "addInterestedUser";
    private static final String REMOVE_INTERESTED_USER = "removeInterestedUser";
    private static final String INSTANCEID_PARAM = "instanceid=";
    private static final String PROCESS_INSTANCE_IMPL = "ProcessInstanceImpl";
    private static final String DUMMY = "dummy";
    private static final String FOLDER_PARAM = "folder=";
    private static final String WORKFLOW_ENGINE_EX_ERR_ILLEGAL_PARAMETERS = "workflowEngine.EX_ERR_ILLEGAL_PARAMETERS";
    private static final String INSTEAD_OF_2_OR_3 = " instead of 2 or 3";
    @Transient
    private transient ProcessModel model = null;
    @Transient
    private boolean valid = false;
    @Column
    private int locked = 0;
    @Column
    private int errorStatus = 0;
    @Column
    private int timeoutStatus = 0;
    @Column
    private String modelId = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<HistoryStepImpl> historySteps = new HashSet<HistoryStepImpl>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<UndoHistoryStep> undoSteps = new HashSet<UndoHistoryStep>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<QuestionImpl> questions = new HashSet<QuestionImpl>();
    @Transient
    private transient HistoryStep currentStep = null;
    @Transient
    private boolean inUndoProcess = false;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<InterestedUser> interestedUsers = new HashSet<InterestedUser>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<WorkingUser> workingUsers = new HashSet<WorkingUser>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<LockingUser> lockingUsers = new HashSet<LockingUser>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<ActiveState> activeStates = new HashSet<ActiveState>();
    @Transient
    private DataRecord folder = null;
    @Transient
    private Map<String, DataRecord> actionData = null;

    @Override
    public String getInstanceId() {
        return this.getId();
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.setId(instanceId);
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public void addHistoryStep(HistoryStep step) {
        ((HistoryStepImpl)step).setProcessInstance(this);
        this.historySteps.add((HistoryStepImpl)step);
        this.currentStep = step;
    }

    @Override
    public void updateHistoryStep(HistoryStep step) {
        this.currentStep = step;
    }

    @Override
    public void addActiveState(State state) {
        Date timeOutDate = this.computeTimeOutDate(state, 1);
        this.addActiveState(state.getName(), timeOutDate);
    }

    private Date computeTimeOutDate(State state, int order) {
        TimeOutAction[] timeOutActions = state.getTimeOutActions();
        Date timeOutDate = null;
        if (timeOutActions != null) {
            for (TimeOutAction timeOutAction : timeOutActions) {
                if (timeOutAction.getOrder() != order) continue;
                Item dateItem = timeOutAction.getDateItem();
                if (dateItem != null) {
                    timeOutDate = this.parseTimeOutFromDateField(dateItem);
                    break;
                }
                timeOutDate = this.computeNextTimeOutByDelay(timeOutAction);
                break;
            }
        }
        return timeOutDate;
    }

    private Date parseTimeOutFromDateField(Item dateItem) {
        Date timeOutDate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            Field dateItemField = this.getField(dateItem.getName());
            timeOutDate = formatter.parse(dateItemField.getValue());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        return timeOutDate;
    }

    private Date computeNextTimeOutByDelay(TimeOutAction timeOutAction) {
        Calendar now = Calendar.getInstance();
        Date timeOutDate = null;
        String delay = timeOutAction.getDelay();
        if (StringUtil.isDefined((String)delay) && !StringUtils.isNumeric((CharSequence)delay)) {
            char unit = delay.charAt(delay.length() - 1);
            int delayAsInt = Integer.parseInt(delay.substring(0, delay.length() - 1));
            switch (unit) {
                case 'm': {
                    now.add(2, delayAsInt);
                    break;
                }
                case 'd': {
                    now.add(6, delayAsInt);
                    break;
                }
                case 'h': {
                    now.add(10, delayAsInt);
                    break;
                }
                default: {
                    now.add(12, delayAsInt);
                }
            }
            timeOutDate = now.getTime();
        } else if (StringUtil.isDefined((String)delay) && StringUtils.isNumeric((CharSequence)delay)) {
            now.add(12, Integer.parseInt(delay));
            timeOutDate = now.getTime();
        } else {
            SilverLogger.getLogger((Object)this).warn("Bad delay format {0} in the computation of the timout date for instance id {1}", new Object[]{delay, this.getId()});
        }
        return timeOutDate;
    }

    private void addActiveState(String state, Date timeOutDate) {
        ActiveState activeState = new ActiveState(state);
        activeState.setProcessInstance(this);
        activeState.setTimeoutDate(timeOutDate);
        if (this.currentStep != null && this.currentStep.getAction().equals(QUESTION_ACTION)) {
            activeState.setBackStatus(true);
        }
        this.activeStates.add(activeState);
        if (!this.inUndoProcess) {
            this.addUndoHistoryStep(ADD_ACTIVE_STATE, state);
        }
    }

    @Override
    public void removeActiveState(State state) {
        this.removeActiveState(state.getName());
    }

    private void removeActiveState(String state) {
        ActiveState activeState = new ActiveState(state);
        this.activeStates.remove((Object)activeState);
        if (!this.inUndoProcess) {
            this.addUndoHistoryStep("removeActiveState", state);
        }
        this.computeTimeOutStatus();
    }

    private void computeTimeOutStatus() {
        if (CollectionUtil.isEmpty(this.activeStates)) {
            this.setTimeoutStatus(false);
        } else {
            boolean oneTimeOutExists = false;
            for (ActiveState state : this.activeStates) {
                if (state.getTimeoutStatus() <= 0) continue;
                oneTimeOutExists = true;
                break;
            }
            this.setTimeoutStatus(oneTimeOutExists);
        }
    }

    @Override
    public void addTimeout(State state) {
        if (CollectionUtil.isEmpty(this.activeStates)) {
            return;
        }
        for (ActiveState activeState : this.activeStates) {
            if (!activeState.getState().equals(state.getName())) continue;
            activeState.setTimeoutStatus(activeState.getTimeoutStatus() + 1);
            Date nextTimeOutDate = this.computeTimeOutDate(state, activeState.getTimeoutStatus() + 1);
            activeState.setTimeoutDate(nextTimeOutDate);
            this.setTimeoutStatus(true);
            return;
        }
    }

    @Override
    public void removeTimeout(State state) {
        boolean found = false;
        if (this.activeStates == null || this.activeStates.isEmpty()) {
            return;
        }
        for (ActiveState activeState : this.activeStates) {
            if (activeState.getState().equals(state.getName())) {
                activeState.setTimeoutStatus(0);
                continue;
            }
            if (activeState.getTimeoutStatus() <= 0) continue;
            found = true;
        }
        if (!found) {
            this.setTimeoutStatus(false);
        }
    }

    @Override
    public void addWorkingUser(User user, State state, String role) {
        this.addWorkingUser(user, this.getStateName(state), role, null);
    }

    @Override
    public void addWorkingUser(Actor actor, State state) {
        this.addWorkingUser(actor.getUser(), this.getStateName(state), actor.getUserRoleName(), actor.getGroupId());
    }

    private void addWorkingUser(User user, String state, String role, String groupId) {
        this.addRolePlayer(ADD_WORKING_USER, user, state, role, groupId, WorkingUser::new, this.workingUsers);
    }

    private <T extends RolePlayer> void addRolePlayer(String actionName, User user, String state, String role, String groupId, Supplier<T> playerSupplier, Set<T> players) {
        RolePlayer player = (RolePlayer)playerSupplier.get();
        if (user != null) {
            player.setUserId(user.getUserId());
        } else if (StringUtil.isDefined((String)groupId)) {
            player.setGroupId(groupId);
        } else {
            player.setUsersRole(role);
        }
        player.setState(state);
        player.setRole(role);
        player.setProcessInstance(this);
        players.add(player);
        if (!this.inUndoProcess) {
            if (user != null) {
                this.addUndoHistoryStep(actionName, user.getUserId() + "##" + state + "##" + role);
            } else {
                this.addUndoHistoryStep(actionName, state + "##" + role);
            }
        }
    }

    @Override
    public void removeWorkingUser(User user, State state, String role) {
        this.removeWorkingUser(user, state.getName(), role);
    }

    private void removeWorkingUser(User user, String state, String role) {
        this.removeRolePlayer(REMOVE_WORKING_USER, user, state, role, WorkingUser::new, this.workingUsers);
    }

    private <T extends RolePlayer> void removeRolePlayer(String actionName, User user, String state, String role, Supplier<T> playerSupplier, Set<T> players) {
        RolePlayer player = (RolePlayer)playerSupplier.get();
        if (user != null) {
            player.setUserId(user.getUserId());
        } else {
            player.setUsersRole(role);
        }
        player.setState(state);
        player.setRole(role);
        players.remove(player);
        if (!this.inUndoProcess) {
            if (user != null) {
                this.addUndoHistoryStep(actionName, user.getUserId() + "##" + state + "##" + role);
            } else {
                this.addUndoHistoryStep(actionName, state + "##" + role);
            }
        }
    }

    @Override
    public void addInterestedUser(User user, State state, String role) {
        this.addInterestedUser(user, state.getName(), role, null);
    }

    @Override
    public void addInterestedUser(Actor actor, State state) {
        this.addInterestedUser(actor.getUser(), state.getName(), actor.getUserRoleName(), actor.getGroupId());
    }

    private void addInterestedUser(User user, String state, String role, String groupId) {
        this.addRolePlayer(ADD_INTERESTED_USER, user, state, role, groupId, InterestedUser::new, this.interestedUsers);
    }

    @Override
    public void removeInterestedUser(User user, State state, String role) {
        this.removeInterestedUser(user, state.getName(), role);
    }

    private void removeInterestedUser(User user, String state, String role) {
        this.removeRolePlayer(REMOVE_INTERESTED_USER, user, state, role, InterestedUser::new, this.interestedUsers);
    }

    public void addQuestion(Question question) {
        this.questions.add((QuestionImpl)question);
    }

    @Override
    public void computeValid() {
        this.valid = !this.workingUsers.isEmpty();
    }

    @Override
    public ProcessModel getProcessModel() throws WorkflowException {
        if (this.model == null) {
            ProcessModelManager modelManager = Workflow.getProcessModelManager();
            this.model = modelManager.getProcessModel(this.modelId);
        }
        return this.model;
    }

    @Override
    public HistoryStep[] getHistorySteps() {
        if (this.historySteps != null) {
            ArrayList<HistoryStepImpl> steps = new ArrayList<HistoryStepImpl>(this.historySteps);
            Collections.sort(steps);
            return steps.toArray(new HistoryStep[0]);
        }
        return new HistoryStep[0];
    }

    @Override
    public HistoryStep getHistoryStep(String stepId) throws WorkflowException {
        for (HistoryStep historyStep : this.historySteps) {
            if (!historyStep.getId().equals(stepId)) continue;
            return historyStep;
        }
        throw new WorkflowException("ProcessInstanceImpl.getHistoryStep", "workflowEngine.EX_ERR_HISTORYSTEP_NOT_FOUND", INSTANCEID_PARAM + this.getId());
    }

    @Override
    public List<Participant> getParticipants() throws WorkflowException {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (HistoryStep historyStep : this.historySteps) {
            User user = historyStep.getUser();
            State state = historyStep.getResolvedState() == null ? null : this.getProcessModel().getState(historyStep.getResolvedState());
            ParticipantImpl participant = new ParticipantImpl(user, historyStep.getUserRoleName(), state, historyStep.getAction());
            participants.add(participant);
        }
        return participants;
    }

    @Override
    public Participant getParticipant(String resolvedState) throws WorkflowException {
        User user;
        HistoryStep step = this.getMostRecentStepOnState(resolvedState);
        try {
            user = step.getUser();
        }
        catch (WorkflowException we) {
            user = null;
        }
        State state = step.getResolvedState() == null ? null : this.getProcessModel().getState(step.getResolvedState());
        return new ParticipantImpl(user, step.getUserRoleName(), state, step.getAction());
    }

    @Override
    public DataRecord getFolder() throws WorkflowException {
        if (this.folder == null) {
            String folderId = this.getId();
            try {
                RecordSet folderSet = this.getProcessModel().getFolderRecordSet();
                this.folder = folderSet.getRecord(folderId);
                if (this.folder == null) {
                    this.createFolder();
                }
            }
            catch (FormException e) {
                throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_UNKNOWN_FOLDER", FOLDER_PARAM + folderId, (Exception)((Object)e));
            }
        }
        return this.folder;
    }

    @Override
    public DataRecord getAllDataRecord(String role, String lang) throws WorkflowException {
        return new ProcessInstanceDataRecord(this, role, lang);
    }

    @Override
    public DataRecord getRowDataRecord(String role, String lang) throws WorkflowException {
        return new ProcessInstanceRowRecord(this, role, lang);
    }

    private void createFolder() throws WorkflowException {
        try {
            RecordSet folderSet = this.getProcessModel().getFolderRecordSet();
            this.folder = folderSet.getEmptyRecord();
            this.folder.setId(this.getId());
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_FOLDER_CREATE_FAILED", FOLDER_PARAM + this.getId(), (Exception)((Object)e));
        }
    }

    @Override
    public void updateFolder(DataRecord actionData) throws WorkflowException {
        try {
            RecordSet folderSet = this.getProcessModel().getFolderRecordSet();
            String[] fieldNames = folderSet.getRecordTemplate().getFieldNames();
            this.setUpdatedFields(actionData, fieldNames);
            folderSet.save(this.getFolder());
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_FOLDER_UPDATE_FAILED", FOLDER_PARAM + this.getId(), (Exception)((Object)e));
        }
    }

    private void setUpdatedFields(DataRecord actionData, String[] fieldNames) throws WorkflowException {
        for (String fieldName : fieldNames) {
            try {
                Field updatedField = actionData.getField(fieldName);
                if (updatedField == null) continue;
                this.setField(fieldName, updatedField);
            }
            catch (FormException formException) {
                // empty catch block
            }
        }
    }

    @Override
    public Field getField(String fieldName) throws WorkflowException {
        DataRecord theFolder = this.getFolder();
        if (theFolder == null) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EX_ERR_GET_FOLDER", INSTANCEID_PARAM + this.getId());
        }
        try {
            Field returnedField = theFolder.getField(fieldName);
            if (returnedField == null) {
                throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_UNKNOWN_ITEM", INSTANCEID_PARAM + this.getId() + ", folder." + fieldName);
            }
            return returnedField;
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_UNKNOWN_ITEM", INSTANCEID_PARAM + this.getId() + "folder." + fieldName, (Exception)((Object)e));
        }
    }

    @Override
    public void setField(String fieldName, Field copiedField) throws WorkflowException {
        Field updatedField = this.getField(fieldName);
        try {
            if (updatedField.getTypeName().equals(copiedField.getTypeName())) {
                updatedField.setObjectValue(copiedField.getObjectValue());
            } else {
                updatedField.setValue(copiedField.getValue(""), "");
            }
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_ITEM_UPDATE_FAILED", INSTANCEID_PARAM + this.getId() + "folder." + fieldName, (Exception)((Object)e));
        }
    }

    @Override
    public DataRecord getActionRecord(String actionName) throws WorkflowException {
        HistoryStep step;
        DataRecord data;
        if (this.actionData == null) {
            this.actionData = new HashMap<String, DataRecord>(0);
        }
        if ((data = this.actionData.get(actionName)) == null && (step = this.getMostRecentStep(actionName)) != null) {
            data = step.getActionRecord();
            if (data == null) {
                return null;
            }
            this.actionData.put(actionName, data);
        }
        return data;
    }

    @Override
    public DataRecord getFormRecord(String formName, String role, String lang) throws WorkflowException {
        try {
            Form form = this.getProcessModel().getForm(formName, role);
            if (form == null) {
                return null;
            }
            String[] fieldNames = form.toRecordTemplate(role, lang).getFieldNames();
            DataRecord data = form.getDefaultRecord(role, lang, this.getAllDataRecord(role, lang));
            DataRecordUtil.updateFields((String[])fieldNames, (DataRecord)data, (DataRecord)this.getFolder(), (String)lang);
            return data;
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_FORM_READ_FAILED", INSTANCEID_PARAM + this.getId() + ",formname =" + formName, (Exception)((Object)e));
        }
    }

    @Override
    public DataRecord getNewActionRecord(String actionName, String language) throws WorkflowException {
        try {
            List<String> fNames;
            Form form = this.getProcessModel().getActionForm(actionName);
            if (form == null) {
                return null;
            }
            DataRecord data = this.getProcessModel().getNewActionRecord(actionName, "", "", this.getAllDataRecord("", ""));
            Input[] inputs = form.getInputs();
            if (inputs != null) {
                fNames = new ArrayList(inputs.length);
                for (Input input : inputs) {
                    if (input == null || input.getItem() == null) continue;
                    fNames.add(input.getItem().getName());
                }
            } else {
                fNames = Collections.emptyList();
            }
            DataRecordUtil.updateFields((String[])fNames.toArray(new String[0]), (DataRecord)data, (DataRecord)this.getFolder(), (String)language);
            return data;
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_FORM_CREATE_FAILED", INSTANCEID_PARAM + this.getId() + ", action=" + actionName, (Exception)((Object)e));
        }
    }

    @Override
    public void saveActionRecord(HistoryStep step, DataRecord actionData) throws WorkflowException {
        try {
            this.checkWysiwygData(step, actionData);
            this.updateFolder(actionData);
            this.updateWysiwygDataWithStepId(step, actionData);
            step.setActionRecord(actionData);
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_FORM_CREATE_FAILED", INSTANCEID_PARAM + this.getId(), (Exception)((Object)e));
        }
    }

    private void checkWysiwygData(HistoryStep step, DataRecord actionData) throws WorkflowException, FormException {
        String[] fieldNames;
        String actionName = step.getAction();
        Form form = this.getProcessModel().getActionForm(actionName);
        RecordTemplate template = form.toRecordTemplate(step.getUserRoleName(), "");
        for (String fieldName : fieldNames = actionData.getFieldNames()) {
            FieldTemplate tmpl;
            Field updatedField = actionData.getField(fieldName);
            if (updatedField == null) {
                SilverLogger.getLogger((Object)this).error("Cannot retrieve field {0} for instance id {1}", new Object[]{fieldName, this.getId()});
            }
            if (!"wysiwyg".equals((tmpl = template.getFieldTemplate(fieldName)).getDisplayerName()) || updatedField == null || updatedField.isNull() || updatedField.getStringValue().startsWith("xmlWysiwygField_")) continue;
            WysiwygFCKFieldDisplayer displayer = new WysiwygFCKFieldDisplayer();
            PagesContext context = new PagesContext(DUMMY, "0", actionData.getLanguage(), false, this.getModelId(), DUMMY);
            context.setObjectId(this.getId());
            displayer.update(updatedField.getStringValue(), (TextField)updatedField, tmpl, context);
        }
    }

    private void updateWysiwygDataWithStepId(HistoryStep step, DataRecord actionData) throws WorkflowException, FormException {
        String[] fieldNames;
        String actionName = step.getAction();
        Form form = this.getProcessModel().getActionForm(actionName);
        RecordTemplate template = form.toRecordTemplate(step.getUserRoleName(), "");
        for (String fieldName : fieldNames = actionData.getFieldNames()) {
            String attachmentId;
            Field updatedField = actionData.getField(fieldName);
            FieldTemplate tmpl = template.getFieldTemplate(fieldName);
            if ("wysiwyg".equals(tmpl.getDisplayerName())) {
                WysiwygFCKFieldDisplayer displayer = new WysiwygFCKFieldDisplayer();
                PagesContext context = new PagesContext(DUMMY, "0", actionData.getLanguage(), false, this.getModelId(), DUMMY);
                context.setObjectId(this.getId());
                displayer.duplicateContent(updatedField, tmpl, context, "Step" + step.getId());
            }
            if (!"file".equals(tmpl.getTypeName()) || !StringUtil.isDefined((String)(attachmentId = updatedField.getValue()))) continue;
            ResourceReference fromPK = new ResourceReference(this.getId(), this.modelId);
            ResourceReference toPK = new ResourceReference("Step" + step.getId(), this.modelId);
            this.updateFileField(updatedField, attachmentId, fromPK, toPK);
        }
    }

    private void updateFileField(Field updatedField, String attachmentId, ResourceReference fromPK, ResourceReference toPK) throws FormException {
        SimpleDocumentList attachments = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(fromPK, null);
        for (SimpleDocument attachment : attachments) {
            if (!attachmentId.equals(attachment.getId())) continue;
            SimpleDocumentPK pk = AttachmentServiceProvider.getAttachmentService().copyDocument(attachment, toPK);
            updatedField.setStringValue(pk.getId());
            break;
        }
    }

    @Override
    public HistoryStep getMostRecentStep(String actionName) {
        Date actionDate = null;
        HistoryStep mostRecentStep = null;
        for (HistoryStep historyStep : this.historySteps) {
            if (!historyStep.getAction().equals(actionName) || mostRecentStep != null && !historyStep.getActionDate().after(actionDate)) continue;
            mostRecentStep = historyStep;
            actionDate = historyStep.getActionDate();
        }
        return mostRecentStep;
    }

    @Override
    public HistoryStep getSavedStep(String userId) throws WorkflowException {
        HistoryStep savedStep = null;
        for (HistoryStep historyStep : this.historySteps) {
            if (historyStep.getActionStatus() != ActionStatus.SAVED || !historyStep.getUser().getUserId().equals(userId)) continue;
            savedStep = historyStep;
            break;
        }
        return savedStep;
    }

    private HistoryStep getMostRecentStepOnState(String stateName) {
        HistoryStep mostRecentStep = null;
        Date actionDate = null;
        for (HistoryStep historyStep : this.historySteps) {
            boolean stepMatch = false;
            if (stateName == null || stateName.isEmpty()) {
                if (historyStep.getResolvedState() == null || historyStep.getResolvedState().isEmpty()) {
                    stepMatch = true;
                }
            } else if (historyStep.getResolvedState() != null && historyStep.getResolvedState().equals(stateName)) {
                stepMatch = true;
            }
            if (!stepMatch || mostRecentStep != null && !historyStep.getActionDate().after(actionDate)) continue;
            mostRecentStep = historyStep;
            actionDate = historyStep.getActionDate();
        }
        Objects.requireNonNull(mostRecentStep);
        return mostRecentStep;
    }

    @Override
    public String[] getActiveStates() {
        if (CollectionUtil.isEmpty(this.activeStates)) {
            return ArrayUtil.emptyStringArray();
        }
        ArrayList<String> stateNames = new ArrayList<String>();
        for (ActiveState state : this.activeStates) {
            stateNames.add(state.getState());
        }
        return stateNames.toArray(new String[this.activeStates.size()]);
    }

    @Override
    public boolean isStateInBackStatus(String stateName) {
        for (ActiveState activeState : this.activeStates) {
            if (!activeState.getState().equals(stateName) || !activeState.getBackStatus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Actor[] getWorkingUsers() throws WorkflowException {
        ArrayList<Actor> actors = new ArrayList<Actor>(this.workingUsers.size());
        for (WorkingUser wkUser : this.workingUsers) {
            actors.addAll(wkUser.toActors());
        }
        return actors.toArray(new Actor[0]);
    }

    @Override
    public Actor[] getWorkingUsers(String state) throws WorkflowException {
        ArrayList<Actor> actors = new ArrayList<Actor>(this.workingUsers.size());
        for (WorkingUser wkUser : this.workingUsers) {
            if (!wkUser.getState().equals(state)) continue;
            actors.addAll(wkUser.toActors());
        }
        return actors.toArray(new Actor[0]);
    }

    @Override
    public void removeWorkingUsers(State state) {
        this.removeUsersInStateFromHistory(REMOVE_WORKING_USER, this.workingUsers, state);
    }

    @Override
    public void removeInterestedUsers(State state) {
        this.removeUsersInStateFromHistory(REMOVE_INTERESTED_USER, this.interestedUsers, state);
    }

    private void removeUsersInStateFromHistory(String actionName, Set<? extends RolePlayer> users, State state) {
        Iterator<? extends RolePlayer> iterator = users.iterator();
        while (iterator.hasNext()) {
            RolePlayer user = iterator.next();
            if (!user.getState().equals(state.getName())) continue;
            if (!this.inUndoProcess) {
                if (user.getUserId() != null) {
                    this.addUndoHistoryStep(actionName, user.getUserId() + "##" + state.getName() + "##" + user.getRole());
                } else {
                    this.addUndoHistoryStep(actionName, state.getName() + "##" + user.getRole());
                }
            }
            iterator.remove();
        }
    }

    @Override
    public Actor[] getWorkingUsers(String state, String role) throws WorkflowException {
        ArrayList<Actor> actors = new ArrayList<Actor>(this.workingUsers.size());
        for (WorkingUser wkUser : this.workingUsers) {
            if (!wkUser.getState().equals(state) || !wkUser.getRoles().contains(role)) continue;
            actors.addAll(wkUser.toActors());
        }
        return actors.toArray(new Actor[0]);
    }

    @Override
    public String[] getAssignedStates(User user, String roleName) {
        ArrayList stateNames = new ArrayList();
        String userId = user.getUserId();
        for (WorkingUser wkUser : this.workingUsers) {
            boolean userMatch = wkUser.getUserId() != null && wkUser.getUserId().equals(userId);
            boolean usersRoleMatch = wkUser.getUsersRole() != null && wkUser.getUsersRole().equals(roleName);
            boolean userGroupsMatch = false;
            if (StringUtil.isDefined((String)wkUser.getGroupId())) {
                userGroupsMatch = user.getGroupIds().contains(wkUser.getGroupId());
            }
            if (!userMatch && !usersRoleMatch && !userGroupsMatch) continue;
            Stream.of(wkUser.getRole().split(",")).forEach(role -> {
                if (role.equals(roleName)) {
                    stateNames.add(wkUser.getState());
                }
            });
        }
        return stateNames.toArray(new String[0]);
    }

    @Override
    public String[] getAllAssignedStates(User user) {
        List<String> groupIds = user.getGroupIds();
        Predicate<WorkingUser> isUser = u -> StringUtil.isDefined((String)u.getUserId()) && u.getUserId().equals(user.getUserId());
        Predicate<WorkingUser> sameGroup = u -> StringUtil.isDefined((String)u.getGroupId()) && groupIds.contains(u.getGroupId());
        return (String[])this.workingUsers.stream().filter(Objects::nonNull).filter(isUser.or(sameGroup)).map(WorkingUser::getState).distinct().toArray(String[]::new);
    }

    @Override
    public LockingUser getLockingUser(String state) {
        for (LockingUser lockingUser : this.lockingUsers) {
            if (!state.equals(lockingUser.getState())) continue;
            return lockingUser;
        }
        return null;
    }

    @Override
    public void lock(State state, User user) throws WorkflowException {
        this.lock(state.getName(), user);
    }

    private void lock(String state, User user) throws WorkflowException {
        LockingUser foundUser = null;
        for (LockingUser lockingUser : this.lockingUsers) {
            if (!lockingUser.getState().equals(state)) continue;
            foundUser = lockingUser;
            break;
        }
        if (foundUser != null) {
            if (!foundUser.getUserId().equals(user.getUserId())) {
                throw new WorkflowException("ProcessInstanceImpl.lock", "workflowEngine.EX_ERR_INSTANCE_LOCKED_BY_ANOTHER_PERSON", INSTANCEID_PARAM + this.getId());
            }
            return;
        }
        LockingUser searchedUser = new LockingUser();
        searchedUser.setState(state);
        searchedUser.setUserId(user.getUserId());
        searchedUser.setProcessInstance(this);
        this.lockingUsers.add(searchedUser);
    }

    @Override
    public void unLock(State state, User user) throws WorkflowException {
        if (state == null) {
            this.unLock("", user);
        } else {
            this.unLock(state.getName(), user);
        }
        this.setLockedByAdmin(false);
    }

    private void unLock(String state, User user) throws WorkflowException {
        LockingUser foundUser = null;
        for (LockingUser lockingUser : this.lockingUsers) {
            if (!lockingUser.getState().equals(state)) continue;
            foundUser = lockingUser;
            break;
        }
        if (foundUser == null) {
            return;
        }
        if (!foundUser.getUserId().equals(user.getUserId())) {
            throw new WorkflowException("ProcessInstanceImpl.unlock", "workflowEngine.EX_ERR_INSTANCE_LOCKED_BY_ANOTHER_PERSON", INSTANCEID_PARAM + this.getId());
        }
        LockingUser searchedUser = new LockingUser();
        searchedUser.setState(state);
        searchedUser.setUserId(user.getUserId());
        searchedUser.setProcessInstance(this);
        this.lockingUsers.remove((Object)searchedUser);
    }

    @Override
    public void lock() throws WorkflowException {
        if (this.isLockedByAdmin()) {
            throw new WorkflowException("ProcessInstanceImpl.lock()", "workflowEngine.EX_ERR_INSTANCE_ALREADY_LOCKED", INSTANCEID_PARAM + this.getId());
        }
        this.setLockedByAdmin(true);
    }

    @Override
    public void unLock() {
        if (this.isLockedByAdmin()) {
            this.setLockedByAdmin(false);
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isLockedByAdmin() {
        return this.locked == 1;
    }

    public void setLockedByAdmin(boolean locked) {
        this.locked = locked ? 1 : 0;
    }

    @Override
    public boolean getErrorStatus() {
        return this.errorStatus != 0;
    }

    @Override
    public void setErrorStatus(boolean errorStatus) {
        this.errorStatus = errorStatus ? 1 : 0;
    }

    @Override
    public boolean getTimeoutStatus() {
        return this.timeoutStatus == 1;
    }

    @Override
    public void setTimeoutStatus(boolean timeoutStatus) {
        this.timeoutStatus = timeoutStatus ? 1 : 0;
    }

    @Override
    public List<User> getUsersInRole(String role) {
        UserManager userManager = WorkflowHub.getUserManager();
        User[] usersInRole = userManager.getUsersInRole(role, this.modelId);
        return Arrays.asList(usersInRole);
    }

    @Override
    public List<User> getUsersInGroup(String groupId) {
        UserManager userManager = WorkflowHub.getUserManager();
        User[] usersInGroup = userManager.getUsersInGroup(groupId, this.modelId);
        return Arrays.asList(usersInGroup);
    }

    @Override
    public Actor[] getActors(QualifiedUsers qualifiedUsers, State state) throws WorkflowException {
        UserInRole[] userInRoles = qualifiedUsers.getUserInRoles();
        RelatedUser[] relatedUsers = qualifiedUsers.getRelatedUsers();
        RelatedGroup[] relatedGroups = qualifiedUsers.getRelatedGroups();
        List actors = Stream.of(userInRoles).map(u -> new ActorImpl(null, u.getRoleName(), state)).collect(Collectors.toCollection(ArrayList::new));
        this.setActorsFromRelatedUsers(qualifiedUsers, state, relatedUsers, actors);
        if (relatedGroups != null) {
            this.setActorsFromRelatedGroups(qualifiedUsers, state, relatedGroups, actors);
        }
        return actors.toArray(new Actor[0]);
    }

    private void setActorsFromRelatedGroups(QualifiedUsers qualifiedUsers, State state, RelatedGroup[] relatedGroups, List<Actor> actors) throws WorkflowException {
        for (RelatedGroup relatedGroup : relatedGroups) {
            String fieldName;
            Field field;
            String groupId;
            if (relatedGroup == null || relatedGroup.getFolderItem() == null || !StringUtil.isDefined((String)(groupId = (field = this.getField(fieldName = relatedGroup.getFolderItem().getName())).getStringValue()))) continue;
            String role = relatedGroup.getRole();
            if (role == null) {
                role = qualifiedUsers.getRole();
            }
            actors.add(new ActorImpl(null, role, state, groupId));
        }
    }

    private void setActorsFromRelatedUsers(QualifiedUsers qualifiedUsers, State state, RelatedUser[] relatedUsers, List<Actor> actors) throws WorkflowException {
        UserManager userManager = WorkflowHub.getUserManager();
        for (RelatedUser relatedUser : relatedUsers) {
            List<User> users = this.findUsersInRelation(userManager, relatedUser);
            String relation = relatedUser.getRelation();
            for (User user : users) {
                String role;
                if (relation != null && !relation.isEmpty() && !relation.equals("itself")) {
                    user = userManager.getRelatedUser(user, relation, this.modelId);
                }
                if ((role = relatedUser.getRole()) == null) {
                    role = qualifiedUsers.getRole();
                }
                if (user == null) continue;
                actors.add(new ActorImpl(user, role, state));
            }
        }
    }

    private List<User> findUsersInRelation(UserManager userManager, RelatedUser relatedUser) throws WorkflowException {
        ArrayList<User> users = new ArrayList<User>();
        if (relatedUser.getParticipant() != null) {
            String resolvedState = relatedUser.getParticipant().getResolvedState();
            Participant participant = this.getParticipant(resolvedState);
            if (participant != null) {
                users.add(participant.getUser());
            }
        } else if (relatedUser.getFolderItem() != null) {
            String fieldName = relatedUser.getFolderItem().getName();
            Field field = this.getField(fieldName);
            if (field instanceof UserField) {
                String userId = field.getStringValue();
                if (StringUtil.isDefined((String)userId)) {
                    users.add(userManager.getUser(userId));
                }
            } else if (field instanceof MultipleUserField) {
                MultipleUserField multipleUserField = (MultipleUserField)field;
                String[] userIds = multipleUserField.getUserIds();
                users.addAll(Arrays.asList(userManager.getUsers(userIds)));
            }
        }
        return users;
    }

    private void addUndoHistoryStep(String action, String params) {
        UndoHistoryStep undoStep = new UndoHistoryStep();
        undoStep.setStepId(this.currentStep.getId());
        undoStep.setInstance(this);
        undoStep.setAction(action);
        undoStep.setParameters(params);
        this.undoSteps.add(undoStep);
    }

    private List<UndoHistoryStep> getByStepId(String id) {
        ArrayList<UndoHistoryStep> undoStepsOfStep = new ArrayList<UndoHistoryStep>();
        for (UndoHistoryStep undoStep : this.undoSteps) {
            if (!undoStep.getId().equals(id)) continue;
            undoStepsOfStep.add(undoStep);
        }
        return undoStepsOfStep;
    }

    private void undoStep(HistoryStep historyStep) throws WorkflowException {
        try {
            this.inUndoProcess = true;
            List<UndoHistoryStep> someUndoSteps = this.getByStepId(historyStep.getId());
            for (UndoHistoryStep undoStep : someUndoSteps) {
                String state;
                String action = undoStep.getAction();
                StringTokenizer st = new StringTokenizer(undoStep.getParameters(), "##");
                if (ADD_ACTIVE_STATE.equals(action)) {
                    state = undoStep.getParameters();
                    this.removeActiveState(state);
                } else if ("removeActiveState".equals(action)) {
                    state = undoStep.getParameters();
                    this.addActiveState(state, null);
                } else if (ADD_WORKING_USER.equals(action)) {
                    this.undoAddWorkingUser(st);
                } else if (REMOVE_WORKING_USER.equals(action)) {
                    this.undoRemoveWorkingUser(st);
                } else if (ADD_INTERESTED_USER.equals(action)) {
                    this.undoAddInterestedUser(st);
                } else if (REMOVE_INTERESTED_USER.equals(action)) {
                    this.undoRemoveInterestedUser(st);
                } else {
                    throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EXP_UNKNOWN_ACTION", INSTANCEID_PARAM + this.getId());
                }
                this.undoSteps.remove((Object)undoStep);
            }
        }
        catch (WorkflowException we) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, "workflowEngine.EX_ERR_UNDO_STEP", INSTANCEID_PARAM + this.getId(), (Exception)((Object)we));
        }
        finally {
            this.inUndoProcess = false;
        }
    }

    private void undoRemoveInterestedUser(StringTokenizer st) throws WorkflowException {
        if (st.countTokens() != 3 && st.countTokens() != 2) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, WORKFLOW_ENGINE_EX_ERR_ILLEGAL_PARAMETERS, INSTANCEID_PARAM + this.getId() + ", method removeInterestedUser - found:" + st.countTokens() + INSTEAD_OF_2_OR_3);
        }
        String userId = st.countTokens() == 3 ? st.nextToken() : null;
        String state = st.nextToken();
        String role = st.nextToken();
        User user = WorkflowHub.getUserManager().getUser(userId);
        this.addInterestedUser(user, state, role, null);
    }

    private void undoAddInterestedUser(StringTokenizer st) throws WorkflowException {
        if (st.countTokens() != 3 && st.countTokens() != 2) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, WORKFLOW_ENGINE_EX_ERR_ILLEGAL_PARAMETERS, INSTANCEID_PARAM + this.getId() + ", method addInterestedUser - found:" + st.countTokens() + INSTEAD_OF_2_OR_3);
        }
        String userId = st.countTokens() == 3 ? st.nextToken() : null;
        String state = st.nextToken();
        String role = st.nextToken();
        User user = WorkflowHub.getUserManager().getUser(userId);
        this.removeInterestedUser(user, state, role);
    }

    private void undoRemoveWorkingUser(StringTokenizer st) throws WorkflowException {
        int maxParametersCount = 3;
        int minParametersCount = 2;
        if (st.countTokens() != 3 && st.countTokens() != 2) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, WORKFLOW_ENGINE_EX_ERR_ILLEGAL_PARAMETERS, INSTANCEID_PARAM + this.getId() + ", method removeWorkingUser - found:" + st.countTokens() + INSTEAD_OF_2_OR_3);
        }
        String userId = st.countTokens() == 3 ? st.nextToken() : null;
        String state = st.nextToken();
        String role = st.nextToken();
        User user = WorkflowHub.getUserManager().getUser(userId);
        this.addWorkingUser(user, state, role, null);
    }

    private void undoAddWorkingUser(StringTokenizer st) throws WorkflowException {
        int maxParametersCount = 3;
        int minParametersCount = 2;
        if (st.countTokens() != 3 && st.countTokens() != 2) {
            throw new WorkflowException(PROCESS_INSTANCE_IMPL, WORKFLOW_ENGINE_EX_ERR_ILLEGAL_PARAMETERS, INSTANCEID_PARAM + this.getId() + ", method addWorkingUser - found:" + st.countTokens() + INSTEAD_OF_2_OR_3);
        }
        String userId = st.countTokens() == 3 ? st.nextToken() : null;
        String state = st.nextToken();
        String role = st.nextToken();
        User user = WorkflowHub.getUserManager().getUser(userId);
        this.removeWorkingUser(user, state, role);
        this.unLock(state, user);
    }

    @Override
    public void reDoState(String state, Date actionDate) throws WorkflowException {
        HistoryStep step = this.getMostRecentStepOnState(state);
        HistoryStep[] steps = this.getHistorySteps();
        boolean started = false;
        boolean stop = false;
        for (int i = steps.length - 1; !stop && i >= 0; --i) {
            if (steps[i].getId().equals(step.getId())) {
                started = true;
                continue;
            }
            if (!started) continue;
            this.undoStep(steps[i]);
            if (!steps[i].getResolvedState().equals(state) || steps[i].getAction().equals(QUESTION_ACTION) || steps[i].getAction().equals("#response#")) continue;
            stop = true;
        }
    }

    @Override
    public HistoryStep[] getBackSteps(User user, String roleName, String stateName) throws WorkflowException {
        ArrayList<String> stepIds = new ArrayList<String>();
        ArrayList<HistoryStep> steps = new ArrayList<HistoryStep>();
        HistoryStep[] allSteps = this.getHistorySteps();
        try {
            WorkingUser wkUser = new WorkingUser();
            wkUser.setUserId(user.getUserId());
            wkUser.setState(stateName);
            wkUser.setRole(roleName);
            if (this.workingUsers.contains(wkUser)) {
                JdbcSqlQuery query = JdbcSqlQuery.select((String)"stepid from sb_workflow_undo_step").where("instanceid = ? ", new Object[]{Integer.parseInt(this.getId())}).and("action = ? ", new Object[]{ADD_ACTIVE_STATE}).and("parameters = ? ", new Object[]{stateName});
                ListSlice results = query.execute(row -> row.getInt(1));
                for (Integer result : results) {
                    String stepId = String.valueOf(result);
                    if (stepIds.contains(stepId)) continue;
                    stepIds.add(stepId);
                }
            }
            for (HistoryStep allStep : allSteps) {
                ActiveState state = new ActiveState(allStep.getResolvedState());
                if (!stepIds.contains(allStep.getId()) || allStep.getAction().equals(QUESTION_ACTION) || allStep.getAction().equals("#response#") || allStep.getResolvedState() == null || this.activeStates.contains((Object)state)) continue;
                steps.add(allStep);
            }
            return steps.toArray(new HistoryStep[0]);
        }
        catch (SQLException e) {
            throw new WorkflowException("ProcessInstanceImpl.getBackSteps", "workflowEngine.EX_ERR_GET_BACKSTEPS", INSTANCEID_PARAM + this.getId(), (Exception)e);
        }
    }

    private HistoryStep getStep(String stepId) throws WorkflowException {
        HistoryStep[] steps = this.getHistorySteps();
        HistoryStep foundStep = null;
        for (int i = 0; i < steps.length && foundStep == null; ++i) {
            if (!steps[i].getId().equals(stepId)) continue;
            foundStep = steps[i];
        }
        if (foundStep == null) {
            throw new WorkflowException("ProcessInstanceImpl.getStep", "workflowEngine.EX_ERR_HISTORYSTEP_NOT_FOUND", INSTANCEID_PARAM + this.getId() + ", stepid : " + stepId);
        }
        return foundStep;
    }

    @Override
    public State addQuestion(String content, String stepId, State fromState, User fromUser) throws WorkflowException {
        HistoryStep step = this.getStep(stepId);
        State targetState = this.getProcessModel().getState(step.getResolvedState());
        Participant participant = this.getParticipant(targetState.getName());
        QuestionImpl question = new QuestionImpl(this, content, fromState.getName(), step.getResolvedState(), fromUser, participant.getUser());
        this.addQuestion(question);
        return this.getProcessModel().getState(step.getResolvedState());
    }

    @Override
    public State answerQuestion(String content, String questionId) throws WorkflowException {
        Question question = null;
        for (Question question2 : this.questions) {
            if (!question2.getId().equals(questionId)) continue;
            question = question2;
        }
        if (question == null) {
            throw new WorkflowException("ProcessInstanceImpl.answerQuestion", "workflowEngine.ERR_QUESTION_NOT_FOUND", INSTANCEID_PARAM + this.getId() + ", questionid : " + questionId);
        }
        question.answer(content);
        return question.getTargetState();
    }

    @Override
    public Question[] getPendingQuestions(String stateName) {
        ArrayList<Question> questionsAsked = new ArrayList<Question>();
        for (Question question : this.questions) {
            if (!question.getTargetState().getName().equals(stateName) || question.getResponseDate() != null) continue;
            questionsAsked.add(question);
        }
        return questionsAsked.toArray(new Question[0]);
    }

    @Override
    public Question[] getSentQuestions(String stateName) {
        ArrayList<Question> questionsAsked = new ArrayList<Question>();
        for (Question question : this.questions) {
            if (!question.getFromState().getName().equals(stateName) || question.getResponseDate() != null) continue;
            questionsAsked.add(question);
        }
        return questionsAsked.toArray(new Question[0]);
    }

    @Override
    public Question[] getRelevantQuestions(String stateName) {
        ArrayList<Question> questionsAsked = new ArrayList<Question>();
        for (Question question : this.questions) {
            if (!question.getFromState().getName().equals(stateName) || question.getResponseDate() == null || !question.isRelevant()) continue;
            questionsAsked.add(question);
        }
        return questionsAsked.toArray(new Question[0]);
    }

    @Override
    public void cancelQuestion(Question question) throws WorkflowException {
        Question[] theQuestions = this.getSentQuestions(question.getTargetState().getName());
        for (int i = 0; theQuestions != null && i < theQuestions.length; ++i) {
            this.cancelQuestion(theQuestions[i]);
        }
        State state = this.answerQuestion("", question.getId());
        this.removeActiveState(state);
        HistoryStep step = this.getMostRecentStepOnState(state.getName());
        Objects.requireNonNull(step);
        this.removeWorkingUser(step.getUser(), state, step.getUserRoleName());
    }

    @Override
    public Question[] getQuestions() {
        return this.questions.toArray(new Question[0]);
    }

    public void addActiveState(ActiveState activeState) {
        activeState.setProcessInstance(this);
        this.activeStates.add(activeState);
    }

    @Override
    public String getTitle(String role, String lang) {
        String title = null;
        Presentation template = null;
        try {
            template = this.getProcessModel().getPresentation();
        }
        catch (WorkflowException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
        }
        if (template != null) {
            title = template.getTitle(role, lang);
            try {
                LazyProcessInstanceDataRecord dataRecord = new LazyProcessInstanceDataRecord(this, role, lang);
                title = DataRecordUtil.applySubstitution((String)title, (DataRecord)dataRecord, (String)lang);
            }
            catch (WorkflowException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
            }
        }
        if (title == null) {
            title = this.getId();
        }
        return title;
    }

    @Override
    public ActionAndState getTimeOutAction(Date dateRef) {
        if (this.activeStates != null && !this.activeStates.isEmpty()) {
            for (ActiveState activeState : this.activeStates) {
                Optional<ActionAndState> actionAndState = this.computeActionAndState(activeState, dateRef);
                if (!actionAndState.isPresent()) continue;
                return actionAndState.get();
            }
        }
        return null;
    }

    private Optional<ActionAndState> computeActionAndState(ActiveState activeState, Date dateRef) {
        try {
            if (activeState.getTimeoutDate() != null && activeState.getTimeoutDate().before(dateRef)) {
                int theTimeoutStatus = activeState.getTimeoutStatus();
                State state = this.getProcessModel().getState(activeState.getState());
                SilverLogger.getLogger((Object)this).debug(() -> activeState.getProcessInstance() != null ? "getTimeOutAction - State = " + activeState.getState() + " - instanceId " + activeState.getProcessInstance().getInstanceId() : "No process instance in active state");
                TimeOutAction[] actions = state.getTimeOutActions();
                Mutable foundActionAndState = Mutable.empty();
                Stream.of(actions).filter(a -> a.getOrder() == theTimeoutStatus + 1).findFirst().ifPresent(a -> foundActionAndState.set((Object)new ActionAndState(a.getAction(), state)));
                return Optional.ofNullable((ActionAndState)foundActionAndState.get());
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Unable to getTimeoutAction for this state {0} id={1}", new Object[]{activeState.getState(), activeState.getId()});
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProcessInstanceImpl)) {
            return false;
        }
        ProcessInstance instance = (ProcessInstance)obj;
        return instance.getInstanceId().equals(this.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    private String getStateName(State state) {
        return state != null ? state.getName() : "";
    }

    ProcessInstanceImpl fetchAll() {
        this.historySteps.size();
        this.undoSteps.size();
        this.questions.size();
        this.interestedUsers.size();
        this.workingUsers.size();
        this.lockingUsers.size();
        this.activeStates.size();
        return this;
    }
}

