/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.lang.annotation.Annotation;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.TaskSavedEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.kernel.logging.SilverLogger;

class TaskSavedRequest
extends AbstractRequest {
    protected TaskSavedRequest() {
    }

    public static TaskSavedRequest get(TaskSavedEvent event) {
        TaskSavedRequest request = (TaskSavedRequest)ServiceProvider.getService(TaskSavedRequest.class, (Annotation[])new Annotation[0]);
        request.setEvent(event);
        return request;
    }

    public void process(AbstractRequestTask.ProcessContext context) throws InterruptedException {
        TaskSavedEvent event = (TaskSavedEvent)this.getEvent();
        UpdatableProcessInstance instance = (UpdatableProcessInstance)event.getProcessInstance();
        String id = instance.getInstanceId();
        UpdatableHistoryStep step = this.fetchHistoryStep(id, !event.isFirstTimeSaved());
        this.processProcessInstance(id, event, step);
    }

    @Override
    protected boolean processEvent(UpdatableProcessInstance instance, String stepId) throws WorkflowException {
        SilverLogger.getLogger((Object)this).info("processEvent() - instanceId = {0} stepId = {1}", new Object[]{instance.getInstanceId(), stepId});
        TaskSavedEvent event = (TaskSavedEvent)this.getEvent();
        UpdatableHistoryStep step = (UpdatableHistoryStep)instance.getHistoryStep(stepId);
        instance.updateHistoryStep(step);
        if (event.getDataRecord() != null) {
            instance.saveActionRecord(step, event.getDataRecord());
        }
        instance.addWorkingUser(step.getUser(), event.getResolvedState(), step.getUserRoleName());
        instance.unLock();
        step.setActionStatus(ActionStatus.SAVED);
        return false;
    }
}

