/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.filter;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class FilterMatcher<T, U, V> {
    private final U value;
    private final T criterion;
    private V result;

    FilterMatcher(T criterion, U value) {
        this.criterion = criterion;
        this.value = value;
    }

    public FilterMatcher<T, U, V> matchFirst(Predicate<T> predicate, Function<U, V> function) {
        if (this.result == null && predicate.test(this.criterion)) {
            this.result = function.apply(this.value);
            assert (this.result != null);
        }
        return this;
    }

    public Optional<V> result() {
        return Optional.ofNullable(this.result);
    }
}

