/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixedNotationExpressionEngine<R> {
    private final Function<String, R> converter;
    private final Map<String, OperatorFunction<R>> operatorFunctions = new HashMap<String, OperatorFunction<R>>();
    private final Pattern operandPattern;

    private PrefixedNotationExpressionEngine(Function<String, R> converter, OperatorFunction<R> ... operationFunctions) {
        this.converter = converter;
        StringBuilder operators = new StringBuilder();
        for (OperatorFunction<R> operationFunction : operationFunctions) {
            this.operatorFunctions.put(operationFunction.getOperator(), operationFunction);
            if (operators.length() > 0) {
                operators.append("|");
            }
            String operator = operationFunction.getOperator();
            for (int i = 0; i < operator.length(); ++i) {
                operators.append("[").append(operator.charAt(i)).append("]");
            }
        }
        this.operandPattern = Pattern.compile("(?i)^\\s*(" + operators.toString() + ")?\\s*(.+)\\s*$");
    }

    public static <R> PrefixedNotationExpressionEngine<R> from(Function<String, R> converter, OperatorFunction<R> ... operationFunctions) {
        return new PrefixedNotationExpressionEngine<R>(converter, operationFunctions);
    }

    public R evaluate(String expression) {
        return this.parse(expression);
    }

    private R parse(String expression) {
        R computed = this.converter.apply(null);
        Matcher matcher = this.operandPattern.matcher(expression);
        if (matcher.find()) {
            OperatorFunction<R> operator = this.operatorFunctions.get(matcher.group(1));
            String operands = matcher.group(2);
            List<String> operandsAsList = this.readOperands(operands);
            if (operandsAsList.isEmpty()) {
                operator = null;
            }
            if (operator != null) {
                for (String element : operandsAsList) {
                    computed = operator.getFunction().apply(computed, this.parse(element));
                }
            } else {
                if (operandsAsList.size() > 1) {
                    throw new IllegalArgumentException("expression.operation.operator.none");
                }
                computed = operandsAsList.size() == 1 ? this.parse(operandsAsList.get(0)) : this.converter.apply(this.escapeExpression(expression).trim());
            }
        }
        return computed;
    }

    public boolean detectOperator(String expression) {
        OperatorFunction<R> operator;
        Matcher matcher = this.operandPattern.matcher(expression != null ? expression : "");
        return matcher.find() && (operator = this.operatorFunctions.get(matcher.group(1))) != null;
    }

    private List<String> readOperands(String operation) {
        ArrayList<String> operands = new ArrayList<String>();
        StringBuilder operand = new StringBuilder();
        int nbOpening = 0;
        int i = 0;
        while (i < operation.length()) {
            char currentChar = operation.charAt(i);
            if (this.subexpression(operation, operand, nbOpening, i, currentChar)) {
                i += 2;
                continue;
            }
            switch (currentChar) {
                case '(': {
                    this.processStartExpression(operand, ++nbOpening, currentChar);
                    break;
                }
                case ')': {
                    this.processEndExpression(operands, operand, nbOpening, currentChar);
                    --nbOpening;
                    break;
                }
                default: {
                    this.processOperand(operands, operand, nbOpening, currentChar);
                }
            }
            ++i;
        }
        if (nbOpening > 0) {
            throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.close");
        }
        return operands;
    }

    private boolean subexpression(String operation, StringBuilder operand, int nbOpening, int index, char currentChar) {
        char nextChar;
        if (currentChar == '\\' && index + 1 < operation.length() && ('(' == (nextChar = operation.charAt(index + 1)) || ')' == nextChar)) {
            if (nbOpening > 0) {
                operand.append('\\');
            }
            operand.append(nextChar);
            return true;
        }
        return false;
    }

    private void processOperand(List<String> operands, StringBuilder operand, int nbOpening, char currentChar) {
        if (currentChar == ' ' && nbOpening == 0 && operand.length() == 0) {
            return;
        }
        if (nbOpening == 0 && !operands.isEmpty()) {
            throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.open");
        }
        operand.append(currentChar);
    }

    private void processEndExpression(List<String> operands, StringBuilder operand, int nbOpening, char currentChar) {
        if (nbOpening == 0) {
            throw new IllegalArgumentException("expression.operation.operand.parentheses.missing.open");
        }
        if (nbOpening == 1) {
            operands.add(operand.toString());
            operand.setLength(0);
        } else {
            operand.append(currentChar);
        }
    }

    private void processStartExpression(StringBuilder operand, int nbOpening, char currentChar) {
        if (nbOpening == 1) {
            if (operand.length() > 0) {
                throw new IllegalArgumentException("expression.operation.malformed");
            }
        } else {
            operand.append(currentChar);
        }
    }

    private String escapeExpression(String expression) {
        StringBuilder escapedExpression = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char nextChar;
            char currentChar = expression.charAt(i);
            if (currentChar == '\\' && i + 1 < expression.length() && ('(' == (nextChar = expression.charAt(i + 1)) || ')' == nextChar)) continue;
            escapedExpression.append(currentChar);
        }
        return escapedExpression.toString();
    }

    public static class OperatorFunction<T> {
        private final String operator;
        private final BiFunction<T, T, T> function;

        public OperatorFunction(String operator, BiFunction<T, T, T> function) {
            this.operator = operator;
            this.function = function;
        }

        public String getOperator() {
            return this.operator;
        }

        public BiFunction<T, T, T> getFunction() {
            return this.function;
        }
    }
}

