/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.ConnectionPool;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlExecutor;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.persistence.jdbc.sql.ResultSetWrapper;
import org.silverpeas.core.persistence.jdbc.sql.SelectResultRowProcess;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlStatementParameterSetter;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
class DefaultJdbcSqlExecutor
implements JdbcSqlExecutor {
    private static final String SQL_REQUEST = ". SQL request: ";
    @Inject
    private SqlStatementParameterSetter sqlParamSetter;

    protected DefaultJdbcSqlExecutor() {
    }

    @Override
    public long selectCount(JdbcSqlQuery selectCountQueryBuilder) throws SQLException {
        try (Connection con = ConnectionPool.getConnection();){
            long l = this.selectCount(con, selectCountQueryBuilder);
            return l;
        }
    }

    @Override
    public long selectCount(Connection con, JdbcSqlQuery selectCountQueryBuilder) throws SQLException {
        try (PreparedStatement st = con.prepareStatement(selectCountQueryBuilder.getSqlQuery());){
            long l;
            block16: {
                this.setParameters(st, selectCountQueryBuilder.getParameters());
                ResultSet rs = st.executeQuery();
                try {
                    rs.next();
                    long count = rs.getLong(1);
                    if (rs.next()) {
                        throw new IllegalArgumentException("select count execution error");
                    }
                    l = count;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        SilverLogger.getLogger((Object)this).debug(e.getMessage() + SQL_REQUEST + selectCountQueryBuilder.getSqlQuery(), new Object[0]);
                        throw e;
                    }
                }
                rs.close();
            }
            return l;
        }
    }

    @Override
    public <R> ListSlice<R> select(JdbcSqlQuery selectQuery, SelectResultRowProcess<R> process) throws SQLException {
        try (Connection con = ConnectionPool.getConnection();){
            ListSlice<R> listSlice = this.select(con, selectQuery, process);
            return listSlice;
        }
    }

    @Override
    public <R> ListSlice<R> select(Connection con, JdbcSqlQuery selectQuery, SelectResultRowProcess<R> process) throws SQLException {
        String sqlQuery;
        JdbcSqlQuery.Configuration queryConf = selectQuery.getConfiguration();
        boolean countOverPaginationMethod = this.isCountOverPaginationMethod(queryConf);
        if (countOverPaginationMethod) {
            String theQuery = selectQuery.getSqlQuery().toLowerCase();
            int selectIndex = theQuery.indexOf("select");
            if (selectIndex >= 0 && theQuery.indexOf("select", selectIndex + 1) < 0 && theQuery.indexOf("distinct", selectIndex) < 0) {
                sqlQuery = selectQuery.getSqlQuery().replaceFirst("(?i)(select .*)from ", "$1, COUNT(*) OVER() AS SP_MAX_ROW_COUNT FROM ");
            } else {
                sqlQuery = selectQuery.getSqlQuery();
                countOverPaginationMethod = false;
            }
        } else {
            sqlQuery = selectQuery.getSqlQuery();
        }
        try (PreparedStatement st = queryConf.isResultCountLimited() || queryConf.isFirstResultScrolled() ? con.prepareStatement(sqlQuery, 1004, 1007) : con.prepareStatement(sqlQuery);){
            ListSlice<R> listSlice;
            block21: {
                if (queryConf.isResultCountLimited()) {
                    st.setFetchSize(queryConf.getResultLimit());
                    if (!queryConf.isNeedRealOriginalSize() || countOverPaginationMethod) {
                        st.setMaxRows(queryConf.getOffset() + queryConf.getResultLimit());
                    }
                }
                this.setParameters(st, selectQuery.getParameters());
                ResultSet rs = st.executeQuery();
                try {
                    listSlice = this.fetchEntities(rs, process, queryConf, countOverPaginationMethod);
                    if (rs == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        SilverLogger.getLogger((Object)this).debug(e.getMessage() + SQL_REQUEST + sqlQuery, new Object[0]);
                        throw e;
                    }
                }
                rs.close();
            }
            return listSlice;
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public long executeModify(JdbcSqlQuery ... modifySqlQueries) throws SQLException {
        return this.executeModify(Arrays.asList(modifySqlQueries));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public long executeModify(Connection con, JdbcSqlQuery ... modifySqlQueries) throws SQLException {
        return this.executeModify(con, Arrays.asList(modifySqlQueries));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public long executeModify(List<JdbcSqlQuery> modifySqlQueries) throws SQLException {
        try (Connection con = ConnectionPool.getConnection();){
            long l = this.executeModify(con, modifySqlQueries);
            return l;
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public long executeModify(Connection con, List<JdbcSqlQuery> modifySqlQueries) throws SQLException {
        long nbUpdate = 0L;
        for (JdbcSqlQuery modifyQuery : modifySqlQueries) {
            modifyQuery.finalizeBeforeExecution();
            try {
                PreparedStatement prepStmt = con.prepareStatement(modifyQuery.getSqlQuery());
                try {
                    this.setParameters(prepStmt, modifyQuery.getParameters());
                    nbUpdate += (long)prepStmt.executeUpdate();
                }
                finally {
                    if (prepStmt == null) continue;
                    prepStmt.close();
                }
            }
            catch (SQLException e) {
                SilverLogger.getLogger((Object)this).debug(e.getMessage() + SQL_REQUEST + modifyQuery.getSqlQuery(), new Object[0]);
                throw e;
            }
        }
        return nbUpdate;
    }

    private <R> ListSlice<R> fetchEntities(ResultSet rs, SelectResultRowProcess<R> process, JdbcSqlQuery.Configuration queryConf, boolean countOverPaginationMethod) throws SQLException {
        boolean resultCountLimited;
        ResultSetWrapper rsw = new ResultSetWrapper(rs);
        int startIndex = queryConf.getOffset();
        if (queryConf.isFirstResultScrolled()) {
            rsw.next();
            rsw.relative(startIndex - 1);
        }
        int lastIdx = (resultCountLimited = queryConf.isResultCountLimited()) ? startIndex + queryConf.getResultLimit() - 1 : 0;
        ListSlice entities = new ListSlice(startIndex, lastIdx);
        if (!resultCountLimited) {
            this.fetchWithoutLimit(startIndex, rsw, process, entities);
        } else {
            this.fetchWithLimit(queryConf, startIndex, rsw, process, entities, countOverPaginationMethod);
        }
        return entities;
    }

    private <R> void fetchWithoutLimit(int startIdx, ResultSetWrapper rsw, SelectResultRowProcess<R> process, ListSlice<R> entities) throws SQLException {
        int idx = startIdx;
        while (rsw.next()) {
            this.handleRow(idx, rsw, process, entities);
            ++idx;
        }
        entities.setOriginalListSize(entities.size());
    }

    private <R> void fetchWithLimit(JdbcSqlQuery.Configuration queryConf, int startIdx, ResultSetWrapper rsw, SelectResultRowProcess<R> process, ListSlice<R> entities, boolean countOverPaginationMethod) throws SQLException {
        int offsetCountAtStart = rsw.getRow();
        int idx = startIdx;
        int originalSize = (int)entities.originalListSize();
        if (queryConf.isNeedRealOriginalSize() && countOverPaginationMethod && rsw.next()) {
            this.handleRow(idx++, rsw, process, entities);
            originalSize = rsw.getInt("SP_MAX_ROW_COUNT");
        }
        while (entities.size() < queryConf.getResultLimit() && rsw.next()) {
            this.handleRow(idx, rsw, process, entities);
            ++idx;
        }
        if (originalSize <= 0 && queryConf.isNeedRealOriginalSize()) {
            originalSize = rsw.last() ? rsw.getRow() : (offsetCountAtStart == 0 ? offsetCountAtStart : idx);
        }
        entities.setOriginalListSize(originalSize);
    }

    private <R> void handleRow(int idx, ResultSetWrapper rsw, SelectResultRowProcess<R> process, ListSlice<R> entities) throws SQLException {
        rsw.setCurrentRowIndex(idx);
        R entity = process.currentRow(rsw);
        if (entity != null) {
            entities.add(entity);
        }
    }

    private boolean isCountOverPaginationMethod(JdbcSqlQuery.Configuration queryConf) {
        return queryConf.isResultCountLimited() && queryConf.isNeedRealOriginalSize() && DefaultJdbcSqlExecutor.isCountOverPaginationMethod();
    }

    private static boolean isCountOverPaginationMethod() {
        return ResourceLocator.getGeneralSettingBundle().getBoolean("jdbc.pagination.method.countOver", false);
    }

    private void setParameters(PreparedStatement preparedStatement, Object statementParameters) throws SQLException {
        Collection<Object> parameters = DefaultJdbcSqlExecutor.getParameters(statementParameters);
        int paramIndex = 1;
        for (Object parameter : parameters) {
            this.setParameter(preparedStatement, paramIndex, parameter);
            ++paramIndex;
        }
    }

    private void setParameter(PreparedStatement preparedStatement, int paramIndex, Object parameter) throws SQLException {
        if (parameter == null) {
            preparedStatement.setObject(paramIndex, null);
        } else {
            this.sqlParamSetter.setParameter(preparedStatement, paramIndex, parameter);
        }
    }

    private static Collection<Object> getParameters(Object statementParameters) {
        Collection<Object> parameters = statementParameters instanceof Object[] ? Arrays.asList((Object[])statementParameters) : (statementParameters instanceof Collection ? (Collection)statementParameters : (statementParameters != null ? Collections.singletonList(statementParameters) : Collections.emptyList()));
        return parameters;
    }
}

