/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.repository.QueryCriteria;
import org.silverpeas.core.util.SilverpeasList;

public interface EntityRepository<T extends IdentifiableEntity> {
    public SilverpeasList<T> getAll();

    public T getById(String var1);

    default public SilverpeasList<T> getById(String ... ids) {
        return this.getById(Arrays.asList(ids));
    }

    public SilverpeasList<T> getById(Collection<String> var1);

    public SilverpeasList<T> findByCriteria(QueryCriteria var1);

    default public T save(T entity) {
        return (T)((IdentifiableEntity)this.save(Collections.singletonList(entity)).get(0));
    }

    default public SilverpeasList<T> save(T ... entities) {
        return this.save(Arrays.asList(entities));
    }

    public SilverpeasList<T> save(List<T> var1);

    default public void delete(T ... entity) {
        this.delete(Arrays.asList(entity));
    }

    public void delete(List<T> var1);

    default public long deleteById(String ... ids) {
        return this.deleteById(Arrays.asList(ids));
    }

    public long deleteById(Collection<String> var1);

    default public long deleteByComponentInstanceId(String componentInstanceId) {
        throw new UnsupportedOperationException();
    }

    public void flush();

    public boolean contains(T var1);
}

